<?php
abstract class AdminTab
{
	public $className;

	public $table;

	/** @var boolean Tab Automatically displays edit/delete icons if true */
	public $edit = false;

	/** @var boolean Tab Automatically displays view icon if true */
	public $view = false;

	/** @var boolean Tab Automatically displays delete icon if true */
	public $delete = false;

	/** @var array tabAccess */
	public $tabAccess;

	/** @var array Errors displayed after post processing */
	public $_errors = array();

	/** @var array Confirmations displayed after post processing */
	protected $_conf;

	public static $currentIndex;

	public static $begin;

	/** @var object Object corresponding to the tab */
	protected $_object = false;


	private $tabs = array(
		'AdminStats' => array('profile' => 3, 'name' => 'Mes informations'),
		'AdminPage' => array('profile' => 3, 'name' => 'Créer une page'),
		'AdminModules' => array('profile' => 3, 'name' => 'Modules'),
		'AdminGallery' => array('profile' => 3, 'name' => 'Gestionnaire de documents'),
		'AdminConfiguration' => array('profile' => 1, 'name' => 'Configuration'),
		'AdminEmployee' => array('profile' => 1, 'name' => 'Utilisateurs'),
		'AdminLogger' => array('profile' => 1, 'name' => 'Historique')
	);


	public $tabSelect;

	public function __construct()
	{
		$this->_conf = array(
			1 => 'Suppression réussie',
			2 => 'Selection successfully deleted',
			3 => 'Création réussie',
			4 => 'Mise à jour réussie',
			5 => 'Status update successful',
			6 => 'Settings update successful',
			7 => 'Image successfully deleted',
			8 => 'Module downloaded successfully',
			9 => 'Thumbnails successfully regenerated',
			10 => 'Message sent to the customer',
			11 => 'Comment added',
			12 => 'Module installé',
			13 => 'Module désinstallé',
			14 => 'Language successfully copied',
			15 => 'Translations successfully added',
			16 => 'Module ajouté au point d\'accroche',
			17 => 'Module supprimé du point d\'accroche',
			18 => 'Upload successful',
			19 => 'Duplication completed successfully',
			20 => 'Translation added successfully but the language has not been created',
			21 => 'Module reset successfully',
			22 => 'Module deleted successfully',
			23 => 'Localization pack imported successfully',
			24 => 'Refund Successful',
			25 => 'Images successfully moved',
			26 => 'Nouveau sous dossier créé (via le FTP)',
			27 => 'New sub directory has been created',
			28 => 'Nouveau dossier créé (via le FTP)',
			29 => 'New directory has been created');

		$this->ajax = Tools::getValue('ajax') || Tools::isSubmit('ajax');
	}

	public function postProcess()
	{

		if(Tools::isSubmit('submitAdd'.$this->className))
		{
			$this->ValidateRules();
			if (!sizeof($this->_errors))
			{
				$id = (int)(Tools::getValue('id_'.$this->table));
				// Update an existing object
				if (isset($id) AND !empty($id))
				{
					$object = new $this->className($id);
					if (Validate::isLoadedObject($object))
					{
						$this->copyFromPost($object, $this->table);
						if($object->update())
						{
							Logger::addLog('Modification', 1, NULL, $this->className, $object->id);
							Tools::redirectAdmin(self::$currentIndex.'&conf=4&id_'.$this->table.'='.$object->id);
						}
					}
				}
				// Add a new object
				else
				{
					$object = new $this->className();
					$this->copyFromPost($object, $this->table);
					if($object->add())
					{
						Logger::addLog('Ajout', 1, NULL, $this->className, $object->id);
						Tools::redirectAdmin(self::$currentIndex.'&conf=3&id_'.$this->table.'='.$object->id);
					}
				}
			}
		}
		elseif(Tools::isSubmit('delete'.$this->className))
		{
			$id = (int)(Tools::getValue('id_'.$this->table));
			$object = new $this->className($id);

			if (Validate::isLoadedObject($object))
				if($object->delete())
				{
					Logger::addLog('Suppression', 1, NULL, $this->className, $object->id);
					Tools::redirectAdmin(self::$currentIndex.'&conf=1');
				}
		}

	}

	abstract public function display();

	public function displayHeader()
	{
		global $kameleon_user;

		// Je garde au cas ou la Configuration d'avant avec le prefix old_ mais afin de ne pas alourdir inutilement la ram je commente

		// $old_jsImport = array(
		// 	'jquery' 								=>	'https://code.jquery.com/jquery-2.1.1.min.js',
		// 	'jquery-ui'							=>	'https://code.jquery.com/ui/1.10.4/jquery-ui.min.js',
		// 	'jquery-ui-datepicker'	=>	'../js/jquery.ui.datepicker-fr.js',
		// 	'jquery-mousewheel'			=>	'../js/jquery.mousewheel-3.0.6.pack.js',
		// );


		// New Version FancyBox mais je n'arrive pas a la rendre 100% operationnel
		// 'jquery-fancybox'				=>	'https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.1.20/jquery.fancybox.min.js',
		// 'jquery-fancybox'				=>	'https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.1.20/jquery.fancybox.min.css',
		// old:css/smoothness/jquery-ui-1.10.4.custom.min.css

		$cssImport = array(
				'jquery-ui'							=>	'https://code.jquery.com/ui/1.12.0/themes/smoothness/jquery-ui.css',
				'incomm-style'					=>	'css/style.css',
				'drag-drop-folder-tree'	=>	'../js/dhtmlgoodies/css/drag-drop-folder-tree.css',
				'jquery-fancybox'				=>	'../js/fancybox/jquery.fancybox.css',
				'fileuploader'					=>	'../js/fileuploader/fileuploader.css',
		);
		$jsImport = array(
				'jquery'								=>	'https://code.jquery.com/jquery-3.2.1.min.js',
				'jquery-ui'							=>	'https://code.jquery.com/ui/1.12.1/jquery-ui.min.js',
				'jquery-ui-datepicker'	=>	'https://cdnjs.cloudflare.com/ajax/libs/jquery-datetimepicker/2.5.4/build/jquery.datetimepicker.min.js',
				'jquery-mousewheel'			=>	'https://cdn.jsdelivr.net/mousewheel/3.1.13/jquery.mousewheel.min.js',
				'jquery-fancybox'				=>	'../js/fancybox/jquery.fancybox.pack.js',
				'drag-drop-folder-tree'	=>	'../js/dhtmlgoodies/drag-drop-folder-tree.js',
				'fileuploader'					=>	'../js/fileuploader/fileuploader.js',
				'jquery-tablednd'				=>	'../js/jquery.tablednd_0_5.js',
				'tinymce'								=>	'../js/tinymce/tinymce.min.js',
				'tinymce-inc'						=>	'../js/tinymce.inc.js',
				'incomm-arbo'						=>	'../js/arbo.js',
				'incomm-admin'					=>	'../js/admin.js',
		);


		$txt = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
	<html>
	<head>
			<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
			<title>SynK - '.Configuration::get('website_name').'</title>
			<link rel="icon" type="image/vnd.microsoft.icon" href="img/favicon.ico'.self::$begin.'" />
			<link rel="shortcut icon" type="image/x-icon" href="img/favicon.ico?'.self::$begin.'" />
			<!--[if lt IE 9]><link type="text/css" href="css/style.ie.css" rel="stylesheet" /><![endif]-->
			';
		foreach ($cssImport as $css) {

			$txt .= '<link type="text/css" href="'.$css.'" rel="stylesheet" />
			';
		}
		foreach ($jsImport as $js) {
			$txt .= '<script type="text/javascript" src="'.$js.'"></script>
			';
		}
		$txt .= '
			<script type="text/javascript">
				var lang = "fr";
				var editorWidth = "'.(Configuration::get('editor_width') + 19).'";
				var pathCSS = "'._BASE_THEME_.'css/style.css, '._BASE_THEME_.'mep/mep.css";
				var ad = "../js/";
			</script>
	</head>
	<body id="'.$this->tabSelect.'">
		<div id="adminPage">
			<div id="adminPannelHeader">'.((int)Configuration::get('maintenance_BO') ? '<div class="maintenance left">BackOffice en maintenance <img src="img/warning.gif" alt="" style="vertical-align:text-bottom" /></div>' : '').''.((int)Configuration::get('maintenance_FO') ? '<div class="maintenance right">FrontOffice en maintenance <img src="img/warning.gif" alt="" style="vertical-align:text-bottom" /></div>' : '').'
				<h1><a href="../" target="_blank">'.Configuration::get('website_name').'</a></h1>
				<a id="logout" title="Déconnexion"></a>
				<div id="user">
						<div id="usercontent"><div class="user"><span>'.$kameleon_user->name.'</span>'.($kameleon_user->isAdmin(true) ? ' <div class="arrow"></div>' : '').'</div>';
						if($kameleon_user->isAdmin(true))
						{
							$txt .= '<ul>';
							foreach(Employee::getList() as $employee)
								if($employee['id'] != $kameleon_user->id_employee)
									$txt .= '<li class="user"><span><a href="index.php?userSimulation='.$employee['id'].'">'.$employee->name.'</a></span></li>';
							$txt .= '</ul>';
						}
						$txt .= '</div>
				</div>
				<ul id="menu">';
					foreach($this->tabs as $key => $tab){

						if ($key == 'AdminGallery') {
							$txt .= '<li><a class="'.$key.' help fancybox fancybox.iframe" href="../js/filemanager/dialog.php?type=2">'.$tab['name'].'</a></li>';
						}
						elseif($kameleon_user->profile <= $tab['profile']){
							$txt .= '<li><a class="'.$key.' help'.($this->tabSelect == $key ? ' selected' : '').'" href="index.php?tab='.$key.'">'.$tab['name'].'</a></li>';
						}
					}

				$txt .= '</ul>
				<div class="clear"></div>
				<div id="adminFooter">
					<p>
						<b>v. '._VERSION_.'</b>';
						if((int)Configuration::get('contrat') == '0'){
							$txt.='&nbsp; Réalisé par <a href="mailto:sylvestrenickypro@gmail.com" target="_blank">Sylvestre Nicky</a>';
						}else{
							$txt.='&nbsp; Réalisé par <a href="mailto:sylvestrenickypro@gmail.com" target="_blank">Sylvestre Nicky</a>';
						}
						 $txt.=' - <span style="font-size:9px">Temps de chargement : '.number_format(microtime(true) - self::$begin, 3, '.', '').'s</span>
					</p>
				</div>
			</div>
				<div id="adminColumns">
					<div id="adminPannel" class="adminBlock">
						<fieldset class="fieldset arbo">
							<legend class="legend">Pages</legend>
							'.Tree::getArboHTML($kameleon_user->isAccess(2)).'
						</fieldset>';

						$optimizations = $this->checkOptimizations();

						if($kameleon_user->isAdmin() && count($optimizations))
						{
							$txt .= '<fieldset class="fieldset">
								<legend class="legend">Optimisation du site <img src="img/warning.gif" alt="" style="display:inline" /></legend>
								<ul>';
									foreach($optimizations as $optimization)
										$txt .= '<li><a href="'.$optimization['link'].'">'.$optimization['label'].'</a></li>';
							$txt .= '</ul>
							</fieldset>';
						}

						$txt .= '<fieldset class="fieldset liensutiles">
							<legend class="legend">Liens utiles</legend>';

						if((int)Configuration::get('contrat') == '0'){
						$txt.='<ul>
								
							</ul>';
						}else{
						$txt.='<ul>
								
							</ul>';
						}
						$txt.='</fieldset>';

					$txt .= '</div>
					<div id="adminContent" class="adminBlock">
						<fieldset class="fieldset">';
					echo $txt;
				}

	public function displayFooter()
	{
						$txt = '</fieldset></div>
						<div class="clear"></div>
						</div>

						<div id="dialog-confirm" title="">
							<p></p>
						</div>
						</div>
						<script type="text/javascript">
							$(document).ready(function() {
								$(".fancybox").fancybox({
									autoSize:false,
									width:1920,
								});
							});
						</script>

			</body>
		</html>';

		echo $txt;
	}

	public function checkOptimizations()
	{
		$optimizations = array();

		if((int)Configuration::get('smarty_compil') == 0)
		{
			$optimization['link'] = 'index.php?tab=AdminConfiguration#smarty_compil_off';
			$optimization['label'] = 'Désactiver la compilation de Smarty';

			$optimizations[] = $optimization;
		}

		return $optimizations;
	}

	/**
	 * Return field value if possible (both classical and multilingual fields)
	 *
	 * Case 1 : Return value if present in $_POST / $_GET
	 * Case 2 : Return object value
	 *
	 * @param object $obj Object
	 * @param string $key Field name
	 * @param integer $id_lang Language id (optional)
	 * @return string
	 */
	protected function getFieldValue($obj, $key, $id_lang = NULL)
	{
		if ($id_lang)
			$defaultValue = ($obj->id AND isset($obj->{$key}[$id_lang])) ? $obj->{$key}[$id_lang] : '';
		else
			$defaultValue = isset($obj->{$key}) ? $obj->{$key} : '';

		return Tools::getValue($key.($id_lang ? '_'.$id_lang : ''), $defaultValue);
	}

	/**
	 * Load class object using identifier in $_GET (if possible)
	 * otherwise return an empty object, or die
	 *
	 * @param boolean $opt Return an empty object if load fail
	 * @return object
	 */
	protected function loadObject($opt = false)
	{
		if ($id = (int)(Tools::getValue('id_'.$this->table)) AND Validate::isUnsignedId($id))
		{
			if (!$this->_object)
				$this->_object = new $this->className($id);
			if (Validate::isLoadedObject($this->_object))
				return $this->_object;
			$this->_errors[] = Tools::displayError('object cannot be loaded (not found)');
		}
		elseif ($opt)
		{
			$this->_object = new $this->className();
			return $this->_object;
		}
		else
			$this->_errors[] = Tools::displayError('object cannot be loaded (identifier missing or invalid)');

		$this->displayErrors();
	}

	/**
	 * Copy datas from $_POST to object
	 *
	 * @param object &$object Object
	 * @param string $table Object table
	 */
	protected function copyFromPost(&$object, $table)
	{
		global $listLang;

		/* Classical fields */
		foreach ($_POST AS $key => $value)
			if (key_exists($key, $object) && $key != 'id_'.$table)
			{
				/* Do not take care of password field if empty */
				if ($key == 'passwd' && Tools::getValue('id_'.$table) && empty($value))
					continue;
				/* Automatically encrypt password in MD5 */
				if ($key == 'passwd' && !empty($value))
					$value = Tools::encrypt($value);
				$object->{$key} = $value;
			}

		/* Multilingual fields */
		$rules = call_user_func(array(get_class($object), 'getValidationRules'), get_class($object));
		if (sizeof($rules['validateLang']))
			foreach ($listLang AS $language)
				foreach ($rules['validateLang'] AS $field => $validation)
					if (isset($_POST[$field.'_'.$language]))
						$object->{$field}[$language] = $_POST[$field.'_'.$language];
	}

	protected function displayAddButton($param = NULL)
	{
		return '<a style="vertical-align:bottom" href="'.self::$currentIndex.'&add'.$this->table.($param ? $param : '').'"><img src="'._KAM_URI_.'img/add.gif" border="0" /> Ajouter</a><br /><br />';
	}

	public function validateRules()
	{
		global $listLang;

		$rules = call_user_func(array($this->className, 'getValidationRules'), $this->className);

		/* Checking for required fields */
		foreach ($rules['required'] AS $field)
			if (($value = Tools::getValue($field)) == false AND (string)$value != '0')
					$this->_errors[] = 'Le champ <b>'.call_user_func(array($this->className, 'displayFieldName'), $field, $this->className).'</b> est requis';

		/* Check multilingual required fields */
		foreach ($rules['requiredLang'] AS $fieldLang)
			if (!Tools::getValue($fieldLang.'_fr'))
				$this->_errors[] = 'Le champ <b>'.call_user_func(array($this->className, 'displayFieldName'), $fieldLang, $this->className).'</b> est requis au moins pour la langue fr';

		/* Checking for maximum fields sizes */
		foreach ($rules['size'] AS $field => $maxLength)
			if (Tools::getValue($field) !== false AND Tools::strlen(Tools::getValue($field)) > $maxLength)
				$this->_errors[] = 'Le champ <b>'.call_user_func(array($this->className, 'displayFieldName'), $field, $this->className).'</b> est trop long ('.$maxLength.' caractères max)';

		/* Check multilingual fields sizes */
		foreach ($rules['sizeLang'] AS $fieldLang => $maxLength)
			foreach ($listLang AS $language)
				if ($value = Tools::getValue($fieldLang.'_'.$language) AND Tools::strlen($value) > $maxLength)
					$this->_errors[] = 'Le champ <b>'.call_user_func(array($this->className, 'displayFieldName'), $fieldLang, $this->className).' ('.$language.')</b> est trop long ('.$maxLength.'  caractères max)';

		/* Checking for fields validity */
		foreach ($rules['validate'] AS $field => $function)
			if (($value = Tools::getValue($field)) !== false)
				if (!Validate::$function($value))
					$this->_errors[] = 'Le champ <b>'.call_user_func(array($this->className, 'displayFieldName'), $field, $this->className).'</b> est invalide';

		/* Check multilingual fields validity */
		foreach ($rules['validateLang'] AS $fieldLang => $function)
			foreach ($listLang AS $language)
				if ($value = Tools::getValue($fieldLang.'_'.$language))
					if (!Validate::$function($value))
						$this->_errors[] = 'Le champ <b>'.call_user_func(array($this->className, 'displayFieldName'), $fieldLang, $this->className).' ('.$language.')</b> est invalide';

		/* Checking for required fields */
		foreach ($rules['array'] AS $field => $function)
			if (($values = Tools::getValue($field)) !== false)
				foreach($values AS $value)
					if (!Validate::$function($value))
						$this->_errors[] = 'Le champ <b>'.call_user_func(array($this->className, 'displayFieldName'), $field, $this->className).'</b> est invalide';

	}

	/**
	 * Display errors
	 */
	public function displayErrors()
	{
		if ($nbErrors = count($this->_errors))
		{
			echo '<script type="text/javascript">
				$(document).ready(function() {
					$(\'#hideError\').unbind(\'click\').click(function(){
						$(\'.error\').hide(\'slow\', function (){
							$(\'.error\').remove();
						});
						return false;
					});
				});
			  </script>
			<div class="error"><span style="float:right"><a id="hideError" href=""><img alt="X" src="img/close.png" /></a></span><img src="img/error2.png" />
			';
			if (count($this->_errors) == 1)
				echo $this->_errors[0];
			else
			{
				echo $nbErrors.' erreurs<br /><ol>';
				foreach ($this->_errors AS $error)
					echo '<li>'.$error.'</li>';
				echo '</ol>';
			}
			echo '</div>';
		}
	}

	/**
	 * Display confirmations
	 */
	public function displayConf()
	{
		if ($conf = Tools::getValue('conf'))
			echo '
			<div class="conf">
				<img src="img/ok.png" alt="" /> '.$this->_conf[(int)($conf)].'
			</div>';
	}

	public function displayFlags()
	{
		global $listLang;

		if(!count($listLang))
			return '';
		$txt = '
		<script type="text/javascript">
		$(function(){
			$(".display").hide();
			$(".fr").show();
			$(".flag").click(function(){
				$(".flag").parent().removeClass();
				$(".display").hide();
				$(this).parent().addClass("selected");
				$("."+$(this).attr("rel")).show();
				lang = $(this).attr("rel");
			});
		});
		</script>';

		$txt .=  'Pour changer de langue, cliquez sur un des drapeaux ci-dessous
		<ul id="flag">';
		foreach($listLang as $lang)
			$txt .= '<li'.($lang == 'fr' ? ' class="selected"' : '').'><img class="flag" src="img/lang/'.$lang.'.gif" rel="'.$lang.'" /></li>';
		return $txt .= '</ul>';
	}
}
