<?php
class KameleonUser
{
	public $id_employee;
	
	public $name;
	
	private $login;
	
	private $password;
	
	public $profile;
	
	public $real_profile;
	
	private $cryptage;
	
	public function __construct()
	{
		global $cookie;
		$cookie = new Cookie('kameleon_admin');
		
		if(isset($cookie->id_employee) && $cookie->id_employee)
		{
			$this->id_employee = $cookie->id_employee;
			$this->name = $cookie->name;
			$this->login = $cookie->login;
			$this->password = $cookie->password;
			$this->profile = $cookie->profile;
			$this->real_profile = $cookie->real_profile;
		}
		else
		{
			$cookie->logout();
			$this->login = false;
		}
	}
	
	public function connect($login, $password, $admin = false)
	{
		global $cookie;
		
		$employee = Employee::getByLogin($login, $password, $admin);
		if($employee)
		{
			$this->id_employee = $cookie->id_employee = $employee->id;
			$this->name = $cookie->name = $employee->name;
			$this->login = $cookie->login = $employee->login;
			$this->password = $cookie->password = $employee->password;
			$this->profile = $cookie->profile = $employee->profile;
			$this->real_profile = $cookie->real_profile = $employee->real_profile;
			$cookie->write();
			return true;
		}
		return false;
	}
	
	public function connectAdmin($id_employee)
	{
		global $cookie;
		
		$employee = new Employee($id_employee, NULL, true);
		if($employee)
		{
			$this->id_employee = $cookie->id_employee = $employee->id;
			$this->name = $cookie->name = $employee->name;
			$this->login = $cookie->login = $employee->login;
			$this->password = $cookie->password = $employee->password;
			$this->profile = $cookie->profile = $employee->profile;
			$this->real_profile = $cookie->real_profile = 1;
			$cookie->write();
			return true;
		}
		return false;
	}
	
	public function isLogged()
	{
		global $cookie;
		
		if($this->connect($this->login, $this->password, $this->real_profile == 1 ? true : false))
			return true;
		$cookie->logout();
		return false;
	}
	
	public function isAdmin($real = false)
	{
		if($this->profile == 1)
			return true;
		if($real && $this->real_profile == 1)
			return true;
		return false;
	}
	
	//-----Fonction ajoutée-----
	public function isUser()
	{
		if($this->profile == 3)
			return true;
		return false;
	}
	
	public function isAccess($profile = 1)
	{
		if($this->profile <= (int)$profile)
			return true;
		return false;
	}
}