<?php
class Logger extends ObjectModel
{
	public static $xml = _FILE_LOG_;
	
	protected $table = 'log';

	/** @var string User */
	public		$user;
	
	/** @var integer Log severity */
	public		$severity;

	/** @var integer Error code */
	public		$error_code;

	/** @var string Message */
	public 		$message;

	/** @var string Object type (eg. Order, Customer...) */
	public		$object_type;

	/** @var integer Object ID */
	public 		$object_id;

	/** @var string Object creation date */
	public 		$date_add;

	/** @var string Object last modification date */
	public 		$date_upd;

	protected	$fieldsRequired = array('severity', 'message');
	protected	$fieldsSize = array();
	protected	$fieldsValidate = array(
	'user' => 'isGenericName',
	'severity' => 'isInt',
	'error_code' => 'isUnsignedInt',
	'message' => 'isMessage',
	'object_id' => 'isUnsignedInt',
	'object_type' => 'isString',
	'date_add' => 'isDate',
	'date_upd' => 'isDate');

	public static function addLog($message, $severity = 1, $errorCode = NULL, $objectType = NULL, $objectId = NULL, $allowDuplicate = false)
	{
		global $cookie;
		
		$log = new Logger();
		$log->user = $cookie->name;
		$log->severity = intval($severity);
		$log->error_code = intval($errorCode);
		$log->message = $message;
		$log->date_add = date('Y-m-d H:i:s');
		$log->date_upd = date('Y-m-d H:i:s');
		if (!empty($objectType) AND !empty($objectId))
		{
			$log->object_type = $objectType;
			$log->object_id = intval($objectId);
		}

		$res = $log->add();
		if ($res)
			return true;
			
		return false;
	}
	
	public static function getList($page = false, $limit = false, &$nbPages = false)
	{
		$xml = self::getXML();
		$result = $xml->sortedXPath('//log', '@id', SORT_DESC);
		
		if(!$page)
			return $result;
			
		$nbPages = ceil(count($result) / $limit);
		
		$return = array();
		for($i = ($page - 1) * $limit; $i < $limit * $page; $i++)
			if(isset($result[$i]))
				$return[] = $result[$i];
			
		return $return;
	}
}

