<?php
class Page extends ObjectModel
{	
	public static $xml = _FILE_PAGES_;
	
	protected $table = 'page';
	
	public $module = array();
	
	public $content_front; /* uniquement pour le front */
	
	public $menu = 1;
	
	public $footer = 1;

	public $copyright = 1;
	
	public $popup = 0;
	
	public $lien = 0;

	public $active = 1;
	
	public $target_blank = 0;
	
	public $name_menu;
	
	public $title_menu;
	
	public $name_footer;
	
	public $title_footer;

	public $name_copyright;
	
	public $title_copyright;	
	
	public $meta_title;
	
	public $meta_description;
	
	public $meta_keywords;
	
	public $meta_robots;
	
	public $h1;
	
	public $link_rewrite;
	
	public $content;
		
 	protected $fieldsAttributes = array(
		'menu' => 'isBool',
		'footer' => 'isBool',
		'popup' => 'isBool',
		'lien' => 'isBool',
		'target_blank' => 'isBool',
		'active' => 'isBool',
		'copyright' => 'isBool');
	
	protected $fieldsRequiredLang = array(
		'name_menu',
		'title_menu',
		'name_footer',
		'title_footer',
		'name_copyright',
		'title_copyright',	
		'link_rewrite');
	
	protected $fieldsSizeLang = array(
		'meta_description' => 500,
		'meta_keywords' => 500,
		'link_rewrite' => 128);
		
	protected $fieldsValidateLang = array(
		'name_menu' => 'isGenericName',
		'title_menu' => 'isGenericName',
		'name_footer' => 'isGenericName',
		'title_footer' => 'isGenericName',
		'name_copyright' => 'isGenericName',
		'title_copyright' => 'isGenericName',
		'meta_description' => 'isGenericName',
		'meta_keywords' => 'isGenericName',
		'meta_title' => 'isGenericName',
		'meta_robots' => 'isGenericName',
		'h1' => 'isGenericName',
		'link_rewrite' => 'isLinkRewrite',
		'content' => 'isString');
		
	protected $fieldsArray = array(
		'module' => 'isModuleName'
	);
	
	public function getModules($content = true)
	{
		$this->content_front = '';
		if(is_array($this->module))				
			foreach($this->module as $module)
			{
				if($module != 'pagecontent')
					$this->content_front .= Module::getModuleFront($module);
				elseif($content)
					$this->content_front .= '<div id="kameleon">'.Tools::htmlentitiesDecodeUTF8($this->content).'</div>';
			}
	}
	
	public function add()
	{
		if(parent::add())
			return Tree::add($this->id);
		return false;
	}
	
	public function update()
	{
		if(parent::update())
			return Tree::update($this->id);
		return false;
	}
	
	public function delete()
	{
		if(parent::delete())
			return Tree::delete($this->id);
		return false;
	}
	
	public static function updatePageLite($param)
	{
		global $listLang;
		
		$xml = self::getXML();
		
		$page = $xml->xpath("//page[@id='".$param['id']."']");
		foreach($listLang as $lang)
			$page[0]->$lang->content = $param['content_'.$lang];
		self::saveXML($xml);
		return $page[0]['id'];
    }
	
	public static function deleteModule($moduleName)
	{
		$xml = self::getXML();
		
		$modulesPages = $xml->xpath("//module[contains(.,'".$moduleName."')]");
	
		foreach($modulesPages as $k => $modulePage)
		{
			$modules = explode(',',$modulePage);
			foreach($modules as $k => $module)
			{
				/*$module = explode('=', (String)$module);
				if($module[0] == $moduleName)
				{
					unset($modules[$k]);
					continue;
				}*/
				
				if($module == $moduleName)
				{
					unset($modules[$k]);
					continue;
				}
			}
			$modulePage[0] = implode(',',$modules);
		}
		return self::saveXML($xml);
	}
	
	public function getLinkRewrite($lang = _DEFAULT_LANG_)
	{
		return Link::make($this->id, $this->link_rewrite, $lang);
	}
	
	public static function pageModuleInstalled($moduleName)
	{
		$xml = self::getXML();
		$results = $xml->xpath("//page[module[contains(.,'".$moduleName."')]]");
		foreach($results as $result)
		{
			$modules = explode(',', $result->module);
			foreach($modules as $module)
				if($module == $moduleName)
					return $result;
		}
		return false;
	}
}