<?php
class AdminPage extends AdminTab
{
	public function __construct()
	{
		parent::__construct();

		$this->className = 'Page';
		$this->table = 'page';
	}

	public function postProcess()
	{
		global $kameleon_user, $listLang;

		if($kameleon_user->isAccess(2))
		{
			parent::postProcess();

			if(Tools::isSubmit('generateQRCODE') && Tools::isSubmit('id_page') && Tools::isSubmit('lang'))
			{
				QRcode::png(Tree::getLink(Tools::getValue('id_page'), Tools::getValue('lang')), _QRCODE_DIR_.Tools::getValue('id_page').'-'.Tools::getValue('lang').'.png', 1, 3, 0);
				Tools::redirectAdmin(self::$currentIndex.'&conf=4&id_'.$this->table.'='.Tools::getValue('id_page'));
			}

			if(Tools::isSubmit('deleteQRCODE') && Tools::isSubmit('id_page') && Tools::isSubmit('lang'))
			{
				@unlink(_QRCODE_DIR_.Tools::getValue('id_page').'-'.Tools::getValue('lang').'.png');
				Tools::redirectAdmin(self::$currentIndex.'&conf=4&id_'.$this->table.'='.Tools::getValue('id_page'));
			}
		}
		else
		{
			if(Tools::isSubmit('popup'))
			 parent::postProcess();
			else if(Tools::isSubmit('submitAdd'.$this->className))
			{
				$page = new Page(Tools::getvalue('id_page'));
				foreach($listLang as $lang)
					$page->content[$lang] = Tools::stripslashes(Tools::getvalue('content_'.$lang));
				$page->update();
				Logger::addLog('Modification', 1, NULL, $this->className, $page->id);
				Tools::redirectAdmin(self::$currentIndex.'&conf=4&id_'.$this->table.'='.$page->id);
			}
			elseif(Tools::isSubmit('delete'.$this->className))
					{
						$id = (int)(Tools::getValue('id_'.$this->table));
						$object = new $this->className($id);

						if (Validate::isLoadedObject($object))
							if($object->delete())
							{
								Logger::addLog('Suppression', 1, NULL, $this->className, $object->id);
								Tools::redirectAdmin(self::$currentIndex.'&conf=1');
							}
					}
			}

	}

	protected function getFieldValue($obj, $key, $id_lang = NULL)
	{
		$value = parent::getFieldValue($obj, $key, $id_lang);
		if ($key == 'module')
		{
			$defaultValue = isset($obj->{$key}) ? $obj->{$key} : '';
			$value = Tools::getValue($key, $defaultValue);
			if($value != '')
				return implode(',', !is_array($value) ? array($value) : $value);
		}
		return $value;
	}

	public function displayAjaxGetTree()
	{
		echo json_encode(Tree::getMenu('fr', true));
	}

	public function displayAjaxUpdatePageFront()
	{
		global $kameleon_user;

		if($kameleon_user->isAdmin())
		{
			$page = new Page(Tools::getvalue('id_page'));
			$page->content[Tools::getvalue('lang')] = utf8_encode(Tools::getvalue('content'));
			return $page->update();
		}
		return false;
	}

	public function displayAjaxFormUpdatePage()
	{
		echo '<fieldset class="fieldset">';
		$this->display();
		echo '</fieldset>';
	}

	public function displayAjaxUpdateTree()
	{
		global $kameleon_user;

			if($kameleon_user->isAccess(3))
			Tree::moveOnglet(Tools::getvalue('id'), Tools::getvalue('next'), Tools::getvalue('newid'));
	}

	public function display()
	{
		global $listLang, $kameleon_user;

		echo '<script type="text/javascript">
			$(function(){
				setupMCEBack();
			});
		</script>';

		if(Tools::isSubmit('id_page') || $kameleon_user->isAccess(3))
			echo $this->displayForm();
	}

	private function displayFormLite()
	{
		global $listLang;

		if(!($page = $this->loadObject(true))) return;

		$txt = '
			<legend class="legend">Modifier la page</legend>';

		$txt .= $this->displayFlags();

		$txt .= '<form method="post" action="'.self::$currentIndex.'&id_page='.$page->id.'">';
		foreach($listLang as $lang)
		{
			$imgFlag = '&nbsp;<img src="img/lang/'.$lang.'.gif" />';
			$txt .= '<div class="display '.$lang.'">';
			$txt .= '<div style="width:'.(Configuration::get('editor_width') + 19).'px; margin:auto"><textarea name="content_'.$lang.'" class="editor">'.$this->getFieldValue($page, 'content', $lang).'</textarea></div>';
			$txt .= '</div>';
		}
		$txt .= '<div class="margin-form"><button type="submit" class="button" name="submitAddPage">Enregistrer</button></div></form>';
		return $txt;
	}

	private function displayForm()
	{
		global $listLang, $kameleon_user;

		if(!($page = $this->loadObject(true))) return;

		$currentIndex = self::$currentIndex;
		if ($page->id)
			$currentIndex .= '&id_page='.$page->id;

		$txt = '';

		if($page->id)
		{
			$txt .= '
			<script type="text/javascript">
				$(function(){';
					if (($kameleon_user->isAccess(2) || $kameleon_user->isAdmin()) && $this->getFieldValue($page, 'lien') == 0)
						$txt .= 'updateFriendlyURL();';
					$txt .= '$(".confirm").click(function(){
						$("#dialog-confirm").html("<p>Êtes-vous sur de vouloir supprimer cette page ?</p>");
						$("#dialog-confirm").dialog({
							resizable: false,
							height: 150,
							modal: true,
							title: "Suppression",
							buttons: {
								Oui: function(){
									location.href = "'.$currentIndex.'&deletePage";
								},
								Non: function(){
									$("#dialog-confirm").dialog("close");
								}
							}
						});
					});
					$("#sortable").sortable();
					$("#sortable").disableSelection();
				});
			</script>';
			$titre = 'Modifier une page';
		}
		else if($kameleon_user->isUser())
			$titre = 'Créer un pop-up';
		else
			$titre = 'Créer une page';

		$txt .= '<legend class="legend">'.$titre.'</legend>';

		$txt .= '<form method="post" action="'.$currentIndex.'" id="formPage">';

		$txt .= $this->displayFlags();

		foreach($listLang as $lang)
		{
			if(!$page->popup && $page->id)
				$txt .= '<div class="display '.$lang.'" style="text-align:center"><a href="'.Tree::getLink($page->id, $lang).'" target="_blank" class="accesfront"><img src="img/cloudblack.png"/>&nbsp;Voir la page publiée</a></div>';
		}

		//--------------------------------------------------------------
		//Ce 'if' permet à l'utilisateur de pouvoir créer des pages popup
		//--------------------------------------------------------------
		if($kameleon_user->isUser() && !$page->id)
		{
			$txt .= '<br />
			<input type="hidden" name="module[]" value="pagecontent" />
			<label class="label">Page Pop-up (sans style graphique) :</label>
			<div class="margin-form">
				<input type="radio" name="popup" id="popup_on" value="1" '.($this->getFieldValue($page, 'popup') == 1 ? 'checked="checked"' : 'checked="checked"').' />
				<label class="t" for="popup_on"><img src="img/enabled.gif" alt="Activé" title="Activé"></label>
			</div>';
			foreach($listLang as $lang)
			{
				$imgFlag = '&nbsp;<img src="img/lang/'.$lang.'.gif" />';
				$txt .= '<div class="display '.$lang.'">';

				$txt .= '
				<label class="label" for="name_menu_'.$lang.'">Nom de l\'onglet :</label>
				<div class="margin-form"><input id="name_menu_'.$lang.'" onKeyUp="copy2friendly(); copy2friendlyURL(); copy2friendlyMeta();" class="medium" type="text" value="'.$this->getFieldValue($page, 'name_menu', $lang).'" name="name_menu_'.$lang.'" />'.$imgFlag.'</div>';

				$txt .= '
				<div class="margin-form" style="display:none;">
					<input type="radio" name="menu" id="menu_on" value="1" '.($this->getFieldValue($page, 'menu') == 1 ? '' : '').' />
					<input type="radio" name="menu" id="menu_off" value="0" '.($this->getFieldValue($page, 'menu') == 0 ? 'checked="checked"' : 'checked="checked"').' />
				</div>';

				$txt .= '




				<div class="margin-form" style="display:none;">
					<input type="radio" name="footer" id="footer_on" value="1" '.($this->getFieldValue($page, 'footer') == 1 ? '' : '').' />
					<input type="radio" name="footer" id="footer_off" value="0" '.($this->getFieldValue($page, 'footer') == 0 ? 'checked="checked"' : 'checked="checked"').' />
				</div>';

				$txt .= '
				<label class="label" for="title_menu_'.$lang.'" style="display:none;">Nom du title dans le menu :</label>
				<div class="margin-form" style="display:none;"><input id="title_menu_'.$lang.'" class="medium" type="text" value="'.$this->getFieldValue($page, 'title_menu', $lang).'" name="title_menu_'.$lang.'" />'.$imgFlag.'</div>';

				$txt .= '
				<label class="label" for="name_footer_'.$lang.'" style="display:none;">Nom de l\'onglet dans le footer :</label>
				<div class="margin-form" style="display:none;"><input id="name_footer_'.$lang.'" class="medium" type="text" value="'.$this->getFieldValue($page, 'name_footer', $lang).'" name="name_footer_'.$lang.'" />'.$imgFlag.'</div>';
				$txt .= '
				<label class="label" for="title_footer_'.$lang.'" style="display:none;">Nom du title dans le footer :</label>
				<div class="margin-form" style="display:none;"><input id="title_footer_'.$lang.'" class="medium" type="text" value="'.$this->getFieldValue($page, 'title_footer', $lang).'" name="title_footer_'.$lang.'" />'.$imgFlag.'</div>';

				$txt .= '
					<label class="label" for="meta_title_'.$lang.'" style="display:none;">Meta title :</label>
					<div class="margin-form" style="display:none;"><input id="meta_title_'.$lang.'" class="large" type="text" value="'.$this->getFieldValue($page, 'meta_title', $lang).'" name="meta_title_'.$lang.'" />'.$imgFlag.' </div>';
					$txt .= '
					<label class="label" for="meta_description_'.$lang.'" style="display:none;">Meta description :</label>
					<div class="margin-form" style="display:none;"><input id="meta_description_'.$lang.'" class="large" type="text" value="'.$this->getFieldValue($page, 'meta_description', $lang).'" name="meta_description_'.$lang.'" />'.$imgFlag.'</div>';
					$txt .= '
					<label class="label" for="meta_keywords_'.$lang.'" style="display:none;">Meta keywords :</label>
					<div class="margin-form" style="display:none;"><input id="meta_keywords_'.$lang.'" class="large" type="text" value="'.$this->getFieldValue($page, 'meta_keywords', $lang).'" name="meta_keywords_'.$lang.'" />'.$imgFlag.'</div>';

				$txt .= '
				<label class="label" for="link_rewrite_'.$lang.'" style="display:none;">URL simplifiée :</label>
				<div class="margin-form" style="display:none;"><input id="link_rewrite_'.$lang.'" class="medium" type="text" name="link_rewrite_'.$lang.'" value="'.$this->getFieldValue($page, 'link_rewrite', $lang).'" onKeyUp="updateFriendlyURL();" onChange="updateFriendlyURL();" />'.$imgFlag.'</div>';

				$meta_robots = 'noindex, nofollow';

				$txt .= '
				<label class="label" for="meta_robots_'.$lang.'" style="display:none;">Meta robots :</label>
				<div class="margin-form" style="display:none;">
				<select name="meta_robots_'.$lang.'" id="meta_robots_'.$lang.'">
					<option value="noindex,nofollow"'.($meta_robots == 'noindex,nofollow' ? ' selected="selected"' : '').'>noindex,nofollow</option>
				</select>
				<!--<input name="meta_robots_'.$lang.'" id="meta_robots_'.$lang.'" class="large" type="text" value="'.$this->getFieldValue($page, 'meta_robots', $lang).'"  />-->'.$imgFlag.'</div>';

				if($page->id)
					$txt .= '<div class="margin-form">Lien complet : '.Tools::getHttpHost(true).Configuration::get('URI').(count($listLang) > 1 ? $lang.'/' : '').'<span id="view_rewrite_'.$lang.'">'.$this->getFieldValue($page, 'link_rewrite', $lang).'</span>-'.$page->id.'</div>';

				$txt .= '</div>';
			}
		}
		else if($kameleon_user->isUser() && $page->id)
		{
			if( $this->getFieldValue($page, 'lien') == 0 )
			{
				$pageModule = array();
				if($this->getFieldValue($page, 'module') != '')
					$pageModule = explode(',', $this->getFieldValue($page, 'module'));

				if(count($pageModule) > 1)
				{
					$irow = 0;
					$i = 0;
					$txt .= '
					<br/>
					<div style="margin-right:auto; margin-left:auto; width:255px;">
						<table class="table tableDnD" style="width:250px">
							<tr class="nodrag nodrop">
								<th style="width:30px">Position</th>
								<th>Nom des modules</th>
							</tr>';
					foreach($pageModule as $module)
					{
						$i++;
						if($module != 'pagecontent')
						{
							$module = Module::getInstanceByName($module);

							$moduleName = explode('=', (string)$module->name);
							if(method_exists($module, 'getInfos'))
								$module->getInfos();

							$txt .= '<tr'.($irow++ % 2 ? ' class="alt_row"' : '').'>
								<td style="text-align:center">'.$i.'</td>
								<td><label for="groupBox2_'.$irow.'" class="t">'.$module->displayName.'</label></td>
							</tr>';
						}
						else
							$txt .= '
							<tr'.($irow++ % 2 ? ' class="alt_row"' : '').'>
								<td style="text-align:center">'.$i.'</td>
								<td><label for="groupBox_'.$irow.'" class="t">Contenu de la page</label></td>
							</tr>';
					}
					$txt .= '</table></div><br/>';
				}
			}
		}
		else if($kameleon_user->isAccess(2))
		{
			$txt .= '<br />
			<label class="label">Activé :</label>
			<div class="margin-form">
				<input type="radio" name="active" id="active_on" value="1" '.($this->getFieldValue($page, 'active') == 1 ? 'checked="checked"' : '').' onchange="submit(this.form)"/>
				<label class="t" for="active_on"><img src="img/enabled.gif" alt="Activé" title="Activé"></label>
				<input type="radio" name="active" id="active_off" value="0" '.($this->getFieldValue($page, 'active') == 0 ? 'checked="checked"' : '').' onchange="submit(this.form)"/>
				<label class="t" for="active_off"><img src="img/disabled.gif" alt="Désactivé" title="Désactivé"></label>
			</div>';
			$txt .= '
			<label class="label">Lien externe :</label>
			<div class="margin-form">
				<input type="radio" name="lien" id="lien_on" value="1" '.($this->getFieldValue($page, 'lien') == 1 ? 'checked="checked"' : '').' onchange="submit(this.form)"/>
				<label class="t" for="lien_on"><img src="img/enabled.gif" alt="Activé" title="Activé"></label>
				<input type="radio" name="lien" id="lien_off" value="0" '.($this->getFieldValue($page, 'lien') == 0 ? 'checked="checked"' : '').' onchange="submit(this.form)"/>
				<label class="t" for="lien_off"><img src="img/disabled.gif" alt="Désactivé" title="Désactivé"></label>
			</div>';

			if( $this->getFieldValue($page, 'lien') == 0 )
			{
				$txt .= '
				<label class="label">Page Pop-up (sans style graphique) :</label>
				<div class="margin-form">
					<input type="radio" name="popup" id="popup_on" value="1" '.($this->getFieldValue($page, 'popup') == 1 ? 'checked="checked"' : '').' />
					<label class="t" for="popup_on"><img src="img/enabled.gif" alt="Activé" title="Activé"></label>
					<input type="radio" name="popup" id="popup_off" value="0" '.($this->getFieldValue($page, 'popup') == 0 ? 'checked="checked"' : '').' />
					<label class="t" for="popup_off"><img src="img/disabled.gif" alt="Désactivé" title="Désactivé"></label>
				</div>';
			}else{
				$txt .= '
				<label class="label">Ouvrir dans une nouvelle fenêtre :</label>
				<div class="margin-form">
					<input type="radio" name="target_blank" id="target_blank_on" value="1" '.($this->getFieldValue($page, 'target_blank') == 1 ? 'checked="checked"' : '').' />
					<label class="t" for="target_blank_on"><img src="img/enabled.gif" alt="Activé" title="Activé"></label>
					<input type="radio" name="target_blank" id="target_blank_off" value="0" '.($this->getFieldValue($page, 'target_blank') == 0 ? 'checked="checked"' : '').' />
					<label class="t" for="target_blank_off"><img src="img/disabled.gif" alt="Désactivé" title="Désactivé"></label>
				</div>';
			}

			$txt .= '
			<label class="label">Afficher dans le menu :</label>
			<div class="margin-form">
				<input type="radio" name="menu" id="menu_on" value="1" '.($this->getFieldValue($page, 'menu') == 1 ? 'checked="checked"' : '').' />
				<label class="t" for="menu_on"><img src="img/enabled.gif" alt="Activé" title="Activé"></label>
				<input type="radio" name="menu" id="menu_off" value="0" '.($this->getFieldValue($page, 'menu') == 0 ? 'checked="checked"' : '').' />
				<label class="t" for="menu_off"><img src="img/disabled.gif" alt="Désactivé" title="Désactivé"></label>
			</div>';

			$txt .= '
			<label class="label">Afficher dans le footer :</label>
			<div class="margin-form">
				<input type="radio" name="footer" id="footer_on" value="1" '.($this->getFieldValue($page, 'footer') == 1 ? 'checked="checked"' : '').' />
				<label class="t" for="footer_on"><img src="img/enabled.gif" alt="Activé" title="Activé"></label>
				<input type="radio" name="footer" id="footer_off" value="0" '.($this->getFieldValue($page, 'footer') == 0 ? 'checked="checked"' : '').' />
				<label class="t" for="footer_off"><img src="img/disabled.gif" alt="Désactivé" title="Désactivé"></label>
			</div>';

			$txt .= '
			<label class="label">Afficher sur la ligne copyright :</label>
			<div class="margin-form">
				<input type="radio" name="copyright" id="copyright_on" value="1" '.($this->getFieldValue($page, 'copyright') == 1 ? 'checked="checked"' : '').' />
				<label class="t" for="copyright_on"><img src="img/enabled.gif" alt="Activé" title="Activé"></label>
				<input type="radio" name="copyright" id="copyright_off" value="0" '.($this->getFieldValue($page, 'copyright') == 0 ? 'checked="checked"' : '').' />
				<label class="t" for="copyright_off"><img src="img/disabled.gif" alt="Désactivé" title="Désactivé"></label>
			</div>';

			if( $this->getFieldValue($page, 'lien') == 0 )
			{
				$pageModule = array();
				if($this->getFieldValue($page, 'module') != '')
					$pageModule = explode(',', $this->getFieldValue($page, 'module'));

				if(count($pageModule) <= 1)
					$txt .= '<input type="hidden" name="module[]" value="pagecontent" />';

				$moduleTr = '';
				$irow = 0;
				foreach(Module::getHookListModule('NOT_ASSIGN') as $module)
				{
					if(!in_array($module->name, $pageModule))
					{
						$moduleName = explode('=', (string)$module->name);
						if(method_exists($module, 'getInfos'))
							$module->getInfos();

						$moduleTr .= '<tr'.($irow++ % 2 ? ' class="alt_row"' : '').'>
							<td><input type="checkbox" name="module[]" id="groupBox1_'.$irow.'" value="'.$module->name.'" /></td>
							<td><label for="groupBox1_'.$irow.'" class="t">'.$module->displayName.''.(method_exists($module, 'getContent') ||  property_exists($module, 'adminTab') ? ' <a href="index.php?tab=AdminModules&configure='.$moduleName[0].($module->id ? '&id_'.$moduleName[0].'='.$module->id : '').'" class="button grey small">Configurer</a>' : '').'</label></td>
						</tr>';
					}
				}

				if($moduleTr)
				{

					$txt .= '<script>
					$(function(){
					$("#tablenav").hide();
				$("#bt-toggle").click(function(){

						$("#tablenav").slideToggle("quick");
					});
				});</script>';


					$txt .= '
					<label class="label">Attacher un module :</label>
					<div class="margin-form">

					<a href="#" id="bt-toggle" class="button grey" >Afficher/Masquer les modules</a>
					<br><br>
						<table class="table" id="tablenav">
							<tr>
								<th style="width:13px"></th>
								<th>Nom du module</th>
							</tr>
							'.$moduleTr.'
						</table>
					</div>';
				}

				if(count($pageModule) > 1)
				{
					$irow = 0;
					$txt .= '
					<label class="label">Position des modules :</label>
					<div class="margin-form">
						<table class="table tableDnD">
							<tr class="nodrag nodrop">
								<th style="width:13px"></th>
								<th>Nom du module</th>
								<th style="width:20px"></th>
							</tr>';
					foreach($pageModule as $module)
					{
						if($module != 'pagecontent')
						{
							$module = Module::getInstanceByName($module);

							$moduleName = explode('=', (string)$module->name);
							if(method_exists($module, 'getInfos'))
								$module->getInfos();

							$txt .= '<tr'.($irow++ % 2 ? ' class="alt_row"' : '').'>
								<td><input type="checkbox" name="module[]" id="groupBox2_'.$irow.'" value="'.$module->name.'" checked="checked" /></td>
								<td><label for="groupBox2_'.$irow.'" class="t">'.$module->displayName.''.(method_exists($module, 'getContent') ||  property_exists($module, 'adminTab') ? ' <a href="index.php?tab=AdminModules&configure='.$moduleName[0].($module->id ? '&id_'.$moduleName[0].'='.$module->id : '').'" class="button grey small">Configurer</a>' : '').'</label></td>
								<td class="dragHandle"><img src="img/updown.gif" alt="" /></td>
							</tr>';
						}
						else
							$txt .= '
							<tr'.($irow++ % 2 ? ' class="alt_row"' : '').'>
								<td><input type="hidden" name="module[]" value="pagecontent" /></td>
								<td><label for="groupBox_'.$irow.'" class="t">Contenu de la page</label></td>
								<td class="dragHandle"><img src="img/updown.gif" alt="" /></td>
							</tr>';
					}
					$txt .= '</table></div>';
				}
			}
		}

		foreach($listLang as $lang)
		{
			$imgFlag = '&nbsp;<img src="img/lang/'.$lang.'.gif" />';
			$txt .= '<div class="display '.$lang.'">';

			if($kameleon_user->isAccess(2))
			{
				$txt .= '
					<script>
		$(document).ready(function(e) {

  	$("#compteur_meta_title_'.$lang.'").text(" " + jQuery.trim($("#meta_title_'.$lang.'").val()).split("").length + " mot(s) | " + $("#meta_title_'.$lang.'").val().length + " Caractere(s) / 256");
   	$("#compteur_meta_description_'.$lang.'").text(" " + jQuery.trim($("#meta_description_'.$lang.'").val()).split("").length + " mot(s) | " + $("#meta_description_'.$lang.'").val().length + " Caractere(s) / 256");

    $("#compteur_meta_keywords_'.$lang.'").text(" " + jQuery.trim($("#meta_keywords_'.$lang.'").val()).split("").length + " mot(s) | " + $("#meta_keywords_'.$lang.'").val().length + " Caractere(s) / 256");
   	$("#meta_title_'.$lang.'").keyup(function() {

    var nombreCaractere = $(this).val().length;

    var nombreMots = jQuery.trim($(this).val()).split(" ").length;
    if($(this).val() === "") {
     	nombreMots = 0;
    }

    var msg = " " + nombreMots + " mot(s) | " + nombreCaractere + " Caractere(s) / 256";
    $("#compteur_meta_title_'.$lang.'").text(msg);
    if (nombreCaractere > 256) { $("#compteur_meta_title_'.$lang.'").addClass("mauvais"); } else { $("#compteur_meta_title_'.$lang.'").removeClass("mauvais"); }

  	})


	  $("#meta_description_'.$lang.'").keyup(function() {
    var nombreCaractere = $(this).val().length;

    var nombreMots = jQuery.trim($(this).val()).split(" ").length;
    if($(this).val() === "") {
     	nombreMots = 0;
    }
    var msg = " " + nombreMots + " mot(s) | " + nombreCaractere + " Caractere(s) / 256";
    $("#compteur_meta_description_'.$lang.'").text(msg);
    if (nombreCaractere > 256) { $("#compteur_meta_description_'.$lang.'").addClass("mauvais"); } else { $("#compteur_meta_description_'.$lang.'").removeClass("mauvais"); }

	  })
	  $("#meta_keywords_'.$lang.'").keyup(function() {

	    var nombreCaractere = $(this).val().length;
	    var nombreMots = jQuery.trim($(this).val()).split(" ").length;
	    if($(this).val() === "") {
	     	nombreMots = 0;
	    }

	    var msg = " " + nombreMots + " mot(s) | " + nombreCaractere + " Caractere(s) / 256";
	    $("#compteur_meta_keywords_'.$lang.'").text(msg);
	    if (nombreCaractere > 256) { $("#compteur_meta_keywords'.$lang.'").addClass("mauvais"); } else { $("#compteur_meta_keywords_'.$lang.'").removeClass("mauvais"); }
	  })

	  $("img").addClass("img-responsive");


		});

		</script>
				<label class="label" for="name_menu_'.$lang.'">Nom de l\'onglet dans le menu :</label>
				<div class="margin-form"><input id="name_menu_'.$lang.'" onKeyUp="copy2friendly(); copy2friendlyURL();" class="medium" type="text" value="'.$this->getFieldValue($page, 'name_menu', $lang).'" name="name_menu_'.$lang.'" />'.$imgFlag.'</div>';
				$txt .= '
				<label class="label" for="title_menu_'.$lang.'">Nom du title dans le menu :</label>
				<div class="margin-form"><input id="title_menu_'.$lang.'" class="medium" type="text" value="'.$this->getFieldValue($page, 'title_menu', $lang).'" name="title_menu_'.$lang.'" />'.$imgFlag.'</div>';
				$txt .= '
				<label class="label" for="name_footer_'.$lang.'">Nom de l\'onglet dans le footer :</label>
				<div class="margin-form"><input id="name_footer_'.$lang.'" class="medium" type="text" value="'.$this->getFieldValue($page, 'name_footer', $lang).'" name="name_footer_'.$lang.'" />'.$imgFlag.'</div>';
				$txt .= '
				<label class="label" for="title_footer_'.$lang.'">Nom du title dans le footer :</label>
				<div class="margin-form"><input id="title_footer_'.$lang.'" class="medium" type="text" value="'.$this->getFieldValue($page, 'title_footer', $lang).'" name="title_footer_'.$lang.'" />'.$imgFlag.'</div>';
				$txt .= '
				<label class="label" for="name_copyright_'.$lang.'">Nom de  l\'onglet sur la ligne copyright :</label>
				<div class="margin-form"><input id="name_copyright_'.$lang.'" class="medium" type="text" value="'.$this->getFieldValue($page, 'name_copyright', $lang).'" name="name_copyright_'.$lang.'" />'.$imgFlag.'</div>';
				$txt .= '
				<label class="label" for="title_footer_'.$lang.'">Nom du title sur la ligne copyright :</label>
				<div class="margin-form"><input id="title_copyright_'.$lang.'" class="medium" type="text" value="'.$this->getFieldValue($page, 'title_copyright', $lang).'" name="title_copyright_'.$lang.'" />'.$imgFlag.'</div>';

				if( $this->getFieldValue($page, 'lien') == 0 )
				{
					$txt .= '
					<label class="label" for="meta_title_'.$lang.'">Meta title :</label>
					<div class="margin-form"><input id="meta_title_'.$lang.'" class="large" type="text" value="'.$this->getFieldValue($page, 'meta_title', $lang).'" name="meta_title_'.$lang.'" />'.$imgFlag.'&nbsp;&nbsp;&nbsp;[&nbsp;<span id="compteur_meta_title_'.$lang.'">0 mots - 0 Caractere / 256</span>&nbsp;]</div>';
					$txt .= '
					<label class="label" for="meta_description_'.$lang.'">Meta description :</label>
					<div class="margin-form"><input id="meta_description_'.$lang.'" class="large" type="text" value="'.$this->getFieldValue($page, 'meta_description', $lang).'" name="meta_description_'.$lang.'" />'.$imgFlag.'&nbsp;&nbsp;&nbsp;[&nbsp;<span id="compteur_meta_description_'.$lang.'">0 mots - 0 Caractere / 256</span>&nbsp;]</div>';
					$txt .= '
					<label class="label" for="meta_keywords_'.$lang.'">Meta keywords :</label>
					<div class="margin-form"><input id="meta_keywords_'.$lang.'" class="large" type="text" value="'.$this->getFieldValue($page, 'meta_keywords', $lang).'" name="meta_keywords_'.$lang.'" />'.$imgFlag.'&nbsp;&nbsp;&nbsp;[&nbsp;<span id="compteur_meta_keywords_'.$lang.'">0 mots - 0 Caractere / 256</span>&nbsp;]</div>';
				}

				$meta_robots = $this->getFieldValue($page, 'meta_robots', $lang);
				if(!$page->id)
					$meta_robots = 'noindex, nofollow';

				$txt .= '
				<label class="label" for="meta_robots_'.$lang.'">Meta robots :</label>
				<div class="margin-form">
				<select name="meta_robots_'.$lang.'" id="meta_robots_'.$lang.'">
					<option value="noindex,nofollow"'.($meta_robots == 'noindex,nofollow' ? ' selected="selected"' : '').'>noindex,nofollow</option>
					<option value="noindex,follow"'.($meta_robots == 'noindex,follow' ? ' selected="selected"' : '').'>noindex,follow</option>
					<option value="index,follow"'.($meta_robots == 'index,follow' ? ' selected="selected"' : '').'>index,follow</option>
					<option value="index,nofollow"'.($meta_robots == 'index,nofollow' ? ' selected="selected"' : '').'>index,nofollow</option>
					<option value=""'.($meta_robots == '' ? ' selected="selected"' : '').'>Désactivé (n\'affiche pas la balise)</option>
				</select>
				<!--<input name="meta_robots_'.$lang.'" id="meta_robots_'.$lang.'" class="large" type="text" value="'.$this->getFieldValue($page, 'meta_robots', $lang).'"  />-->'.$imgFlag.'</div>';

				if( $this->getFieldValue($page, 'lien') == 0 )
				{
					$txt .= '
					<label class="label" for="h1_'.$lang.'">Titre H1 :</label>
					<div class="margin-form"><input id="h1_'.$lang.'" class="medium" type="text" value="'.$this->getFieldValue($page, 'h1', $lang).'" name="h1_'.$lang.'" />'.$imgFlag.'</div>';
					$txt .= '
					<label class="label" for="link_rewrite_'.$lang.'">URL simplifiée :</label>
					<div class="margin-form"><input id="link_rewrite_'.$lang.'" class="medium" type="text" name="link_rewrite_'.$lang.'" value="'.$this->getFieldValue($page, 'link_rewrite', $lang).'" onKeyUp="updateFriendlyURL();" onChange="updateFriendlyURL();" />'.$imgFlag.'</div>';
					if($page->id && $page->id!=Configuration::get('home'))
						$txt .= '<div class="margin-form">Lien complet : '.Tools::getHttpHost(true).Configuration::get('URI').(count($listLang) > 1 ? $lang.'/' : '').'<span id="view_rewrite_'.$lang.'">'.$this->getFieldValue($page, 'link_rewrite', $lang).'</span>-'.$page->id.'</div>';
				}else{
					$txt .= '
					<label class="label" for="link_rewrite_'.$lang.'">URL simplifiée :</label>
					<div class="margin-form"><input id="link_rewrite_'.$lang.'" class="medium" type="text" name="link_rewrite_'.$lang.'" value="'.($this->getFieldValue($page, 'link_rewrite', $lang) != ''? $this->getFieldValue($page, 'link_rewrite', $lang) : 'http://').'" />'.$imgFlag.'</div>';

					if($page->id && $page->id!=Configuration::get('home'))
						$txt .= '<div class="margin-form">Lien complet : <span id="view_rewrite_'.$lang.'">'.$this->getFieldValue($page, 'link_rewrite', $lang).'</span></div>';
				}
			}

			if($kameleon_user->isAdmin())
			{
				if($page->id)
				{
					$txt .= '<br/>';
					if(file_exists(_QRCODE_DIR_.$page->id.'-'.$lang.'.png'))
						$txt .= '<label class="label">Code QR :</label>
						<div class="margin-form">
						<img src="'._BASE_URI_QRCODE_.$page->id.'-'.$lang.'.png" alt="" />
						<br />
						<a href="'.$currentIndex.'&deleteQRCODE&lang='.$lang.'"><img src="img/delete.gif" alt="" /> Supprimer</a>
						</div>';

					$txt .= '<div class="margin-form">
						<a href="'.$currentIndex.'&generateQRCODE&lang='.$lang.'" class="button grey">Générer le Code QR</a>'.$imgFlag.'</div>';
					$txt .= '<br/>';
				}
			}

			//-----Ajouté-----
			if($kameleon_user->isUser() && $page->popup)
				$txt .= '<div class="margin-form">Lien complet : '.Tools::getHttpHost(true).Configuration::get('URI').(count($listLang) > 1 ? $lang.'/' : '').'<span id="view_rewrite_'.$lang.'">'.$this->getFieldValue($page, 'link_rewrite', $lang).'</span>-'.$page->id.'</div>';

			if( $this->getFieldValue($page, 'lien') == 0 )
				$txt .= '<div style="width:'.(Configuration::get('editor_width') + 19).'px; margin:auto"><textarea name="content_'.$lang.'" class="editor">'.$this->getFieldValue($page, 'content', $lang).'</textarea></div>';


			$txt .= '</div>';
		}
		$txt .= '<br/>';
		$txt .= '<div class="margin-form"><button type="submit" class="button save big" name="submitAddPage">Enregistrer</button>&nbsp;&nbsp;&nbsp;&nbsp;';
		if( ($page->id && $kameleon_user->isAccess(2)) || ($kameleon_user->isUser() && $page->popup) ){
			$txt .='<button type="button" class="confirm button delete big">Supprimer</button>';
			}else{ $txt .='';}
		$txt .='</div></form>';
		return $txt;
	}

	protected function _cleanMetaKeywords($keywords)
	{
		if (!empty($keywords) && $keywords != '')
		{
			$out = array();
			$words = explode(',', $keywords);
			foreach ($words as $word_item)
			{
				$word_item = trim($word_item);
				if (!empty($word_item) && $word_item != '')
					$out[] = $word_item;
			}
			return ((count($out) > 0) ? implode(',', $out) : '');
		}
		else
			return '';
	}

	protected function copyFromPost(&$object, $table)
	{
		parent::copyFromPost($object, $table);

		global $listLang;

		foreach ($listLang as $language)
		{
			if (isset($_POST['meta_keywords_'.$language]))
			{
				$_POST['meta_keywords_'.$language] = $this->_cleanMetaKeywords(Tools::strtolower($_POST['meta_keywords_'.$language]));
				$object->meta_keywords[$language] = $_POST['meta_keywords_'.$language];
			}
			if (isset($_POST['meta_robots_'.$language]))
			{
				$_POST['meta_robots_'.$language] = $this->_cleanMetaKeywords(Tools::strtolower($_POST['meta_robots_'.$language]));
				$object->meta_robots[$language] = $_POST['meta_robots_'.$language];
			}
		}
	}
}
