<?php
class PageController
{
	protected $display_header = true;

	protected $display_footer = true;

	public $ajax = false;

	protected $page;

	public $error404 = false;

	protected $template = 'page';

	public function __construct()
	{
		if(basename($_SERVER['REQUEST_URI']) == 'index.php')
			Tools::redirect();
		if(basename($_SERVER['REQUEST_URI']) == '404.php')
			Tools::redirect('404');
		$this->ajax = Tools::getValue('ajax') || Tools::isSubmit('ajax');
	}

	public function init()
	{
		global $cookie, $smarty, $listLang;

		$cookie = new Cookie('kameleon_site');

		$kameleon_user = new KameleonUser();

		if(!isset($cookie->lang))
		{
			$cookie->lang = 'fr';
			$cookie->write();
		}

		if(Tools::isSubmit('iso_lang') && Tools::getValue('iso_lang') != $cookie->lang)
			if(in_array($_GET['iso_lang'], $listLang))
			{
				$cookie->lang = $_GET['iso_lang'];
				$cookie->write();
			}

		if(Tools::isSubmit('iso_lang'))
			if(!in_array(Tools::getValue('iso_lang'), $listLang))
			{
				$cookie->lang = 'fr';
				$cookie->write();
				Tools::redirect();
			}

		if(count($listLang) > 1 && !Tools::isSubmit('iso_lang') && !Tools::isSubmit('id_rss'))
			Tools::redirect($cookie->lang.'/');

		if(count($listLang) == 1 && Tools::isSubmit('iso_lang'))
			Tools::redirect();

		if($this->ajax)
		{
			$this->display_header = false;
			$this->display_footer = false;
		}

		if(Tools::getValue('content_only'))
		{
			$this->display_header = false;
			$this->display_footer = false;
		}

		$smarty->assign(array(
			'ajax' => $this->ajax,
			'admin' => $kameleon_user->isAdmin(),
			'request_uri' => Tools::safeOutput(urldecode($_SERVER['REQUEST_URI'])),
			'time' => time(),
			'home' => Configuration::get('home'),
			'lang' => $cookie->lang,
			'Tools' => new Tools,
			'website_name' => Configuration::get('website_name'),
			'contrat' => Configuration::get('contrat')
			));

		if((int)Configuration::get('maintenance_FO') && $kameleon_user->isAdmin())
		{
			$this->displayMaintenance();
			exit;
		}
	}

	public function run()
	{
		global $smarty, $cookie;

		$this->init();

		$id = Tools::isSubmit('id_page') ? Tools::getValue('id_page') : Configuration::get('home');
		$this->page = new Page($id, $cookie->lang);

		if(!Validate::isLoadedObject($this->page) && !$this->error404)
			Tools::redirect('404');

		if($this->error404)
		{
			$this->page = new Page();
			$this->page->meta_title = 'Erreur 404';
			$this->template = '404';
		}
		elseif(!$this->page->active)
		{
			$this->page = new Page();
			$this->page->meta_title = 'Erreur 404';
			$this->template = '404';
		}
		elseif($id != Configuration::get('home'))
		{
			if(Tools::isSubmit('rewrite') && (Tools::getValue('rewrite') != $this->page->link_rewrite))
				Tools::redirectAdmin($this->page->getLinkRewrite($cookie->lang));
		}//////////////// rajout 10/12/2015////////////
		elseif($id == Configuration::get('home')){
			if (Tools::isSubmit('rewrite'))
			Tools::redirectAdmin(_URI_);
		}
		///////////////////////////////////////////////

		$smarty->assign('page', $this->page);

		if ($this->ajax)
			$this->displayAjax();
		else
			$this->display();
	}

	public function display()
	{
		global $smarty, $cookie;

		$smarty->assign(array(
			'envLocal'					=>	false,
			'tree'							=>	new Tree(),
			'assets'						=>	Configuration::getAssets(),
			'particulars'				=>	Tools::nl2br(Configuration::get('particulars')),
			'mail'							=>	Configuration::get('mail'),
			'columnLeft'				=>	Configuration::get('columnLeft'),
			'columnRight'				=>	Configuration::get('columnRight'),
			'breadcrumb'				=>	Tree::getBreadcrumb($this->page->id, $cookie->lang)));

		$this->page->getModules();
		$this->getModulesHooks();

		// Ajout des js et CSS du theme :
		Module::$CSS['styles']       = _BASE_THEME_.'css/styleFlex.css';
		Module::$JS['KameleonTools'] = _BASE_URI_.'js/tools.js';
		Module::$JS['kameleonStack'] = _BASE_URI_.'js/stacktable.js';

		if (Configuration::get('smarty_compil')) {
			$allCSS = Tools::cccCss(Module::$CSS);
			$allJS  = Tools::cccJs(Module::$JS);
		}else {
			$allCSS = Module::$CSS;
			$allJS  = Module::$JS;
		}

    $smarty->assign(array(
			'ModuleCSSList' =>  $allCSS,
			'ModuleJSList'  => $allJS
		));

		if($this->page->popup)
		{
			$smarty->display(_THEMES_DIR_.'header.popup.tpl');
			$smarty->display(_THEMES_DIR_.'page.popup.tpl');
		}
		else
		{
			if ($this->display_header){
				$smarty->display('header.tpl');
			}
				$smarty->display($this->template.'.tpl');

			if ($this->display_footer)
				$smarty->display('footer.tpl');
			}
	}

	public function displayAjax()
	{
		global $smarty, $cookie;

		$smarty->assign(array(
			'tree' => new Tree(),
			'particulars' => Tools::nl2br(Configuration::get('particulars')),
			'mail' => Configuration::get('mail'),
			'breadcrumb' => Tree::getBreadcrumb($this->page->id, $cookie->lang)));

		$this->page->getModules();

		$smarty->assign(array(
			'ModuleCSSList' => Tools::cccCss(Module::$CSS),
			'ModuleJSList' => Tools::cccJs(Module::$JS)
		));

		$content = $smarty->fetch($this->template.'.tpl');
		$this->page->meta_title .= ' - '.Configuration::get('website_name');
		$this->page->content = $content;

		echo json_encode($this->page);
	}

	public function getModulesHooks()
	{
		global $smarty;

		foreach(Module::getHookList(false) as $hook)
			$smarty->assign($hook['id'], Module::getHook($hook['id']));
	}

	public function displayMaintenance()
	{
		global $smarty;

		$smarty->display(_THEMES_DIR_.'maintenance.tpl');
	}

	public function getCurrentPage()
	{
		return $this->page;
	}

}
