function str2url(str,encoding,ucfirst)
{
	str = str.toUpperCase();
	str = str.toLowerCase();

	str = str.replace(/[\u0105\u0104\u00E0\u00E1\u00E2\u00E3\u00E4\u00E5]/g,'a');
	str = str.replace(/[\u00E7\u010D\u0107\u0106]/g,'c');
	str = str.replace(/[\u010F]/g,'d');
	str = str.replace(/[\u00E8\u00E9\u00EA\u00EB\u011B\u0119\u0118]/g,'e');
	str = str.replace(/[\u00EC\u00ED\u00EE\u00EF]/g,'i');
	str = str.replace(/[\u0142\u0141]/g,'l');
	str = str.replace(/[\u00F1\u0148]/g,'n');
	str = str.replace(/[\u00F2\u00F3\u00F4\u00F5\u00F6\u00F8\u00D3]/g,'o');
	str = str.replace(/[\u0159]/g,'r');
	str = str.replace(/[\u015B\u015A\u0161]/g,'s');
	str = str.replace(/[\u00DF]/g,'ss');
	str = str.replace(/[\u0165]/g,'t');
	str = str.replace(/[\u00F9\u00FA\u00FB\u00FC\u016F]/g,'u');
	str = str.replace(/[\u00FD\u00FF]/g,'y');
	str = str.replace(/[\u017C\u017A\u017B\u0179\u017E]/g,'z');
	str = str.replace(/[\u00E6]/g,'ae');
	str = str.replace(/[\u0153]/g,'oe');
	str = str.replace(/[\u013E\u013A]/g,'l');
	str = str.replace(/[\u0155]/g,'r');

	str = str.replace(/[^a-z0-9\s\'\:\/\[\]-]/g,'');
	str = str.replace(/[\s\'\:\/\[\]-]+/g,' ');
	str = str.replace(/[ ]/g,'-');
	str = str.replace(/[\/]/g,'-');

	if (ucfirst == 1) {
		c = str.charAt(0);
		str = c.toUpperCase()+str.slice(1);
	}

	return str;
}

function copy2friendlyURL()
{
	$('#link_rewrite_' + lang).val(str2url($('#name_menu_' + lang).val().replace(/^[0-9]+\./, ''), 'UTF-8'));
	$('#view_rewrite_' + lang).html($('#link_rewrite_' + lang).val());
}

function copy2friendlyURL2()
{
	$('#meta_title_' + lang).val($('#title_' + lang).val());
	$('#link_rewrite_' + lang).val(str2url($('#title_' + lang).val().replace(/^[0-9]+\./, ''), 'UTF-8'));
}

function copy2friendlyURL3()
{
	$('#meta_title').val($('#title').val());
	$('#link_rewrite').val(str2url($('#title').val().replace(/^[0-9]+\./, ''), 'UTF-8'));
}

function copy2friendly()
{
	$('#name_footer_' + lang).val($('#name_menu_' + lang).val());
	$('#title_menu_' + lang).val($('#name_menu_' + lang).val());
	$('#title_footer_' + lang).val($('#name_menu_' + lang).val());

	$('#name_copyright_' + lang).val($('#name_menu_' + lang).val());
	$('#title_copyright_' + lang).val($('#name_menu_' + lang).val());
}

function copy2friendlyMeta()
{
	$('#meta_title_' + lang).val($('#name_menu_' + lang).val());
	$('#meta_description_' + lang).val($('#name_menu_' + lang).val());
	$('#meta_keywords_' + lang).val($('#name_menu_' + lang).val());
}



function updateFriendlyURL()
{
	$('#link_rewrite_' + lang).val(str2url($('#link_rewrite_' + lang).val(), 'UTF-8'));
	$('#view_rewrite_' + lang).html($('#link_rewrite_' + lang).val());
}

function gencode(size)
{
	$('#code').val('');
	var chars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
	var code = '';
	for (var i = 1; i <= size; ++i)
		code += chars.charAt(Math.floor(Math.random() * chars.length));
	$('#code').val(code);
}
	
$(function(){
	$("#logout").click(function(){
		$("#dialog-confirm").html("<p>Êtes-vous sur de vouloir vous déconnecter ?</p>");
		$("#dialog-confirm").dialog({
			resizable: false,
			height: 150,
			modal: true,
			title: 'Déconnexion',
			buttons: {
				Oui: function(){
					location.href = "index.php?logout";
				},
				Non: function(){
					$("#dialog-confirm").dialog('close');
				}
			}
		});
	});
	
	$('table.tableDnD').tableDnD({
		dragHandle: 'dragHandle'
	});
	
	$("a.fancybox").fancybox({
		tpl:{
			closeBtn: '<div title="Fermer" class="fancybox-item fancybox-close"></div>',
			next: '<a title="Suivant" class="fancybox-nav fancybox-next"><span></span></a>',
			prev: '<a title="Précédent" class="fancybox-nav fancybox-prev"><span></span></a>'
		}
	});
});