$(function(){
	
	var old_content = $("#kameleon").html();
	initContent();
	instanceMCE = false;
	btnShown = false;

	$("#kameleon").dblclick(function(){
		if(!instanceMCE)
		{
			if($("#kameleon").html() == '&lt;&lt; double-clic pour intégrer du contenu &gt;&gt;')
					$("#kameleon").html('');
					
			editorWidth = nbPixel($("#kameleon").css('width')) + 19;
			setupMCEFront();
			instanceMCE = true;
		}
		else
			tinyMCE.activeEditor.show();
		showBtn();
	});
	
	function hideBtn()
	{
		$('p.btnEditor').hide();
	}
	
	function showBtn()
	{
		if(!btnShown)
		{
			var buttons = '<p class="btnEditor"><input type="submit" class="btnEditor saveEditor" value="Enregistrer" /><input type="submit" class="btnEditor previewEditor" value="Aperçu" /><input type="submit" class="btnEditor cancelEditor" value="Annuler" /></p>'
			$("#kameleon").before(buttons).after(buttons);
			btnShown = true;
			$(".cancelEditor").on('click', function(){
				if(window.confirm('Toutes les modification depuis le dernier enregistrement seront perdues, cliquer sur "ok" pour confirmer'))
				{
					tinyMCE.activeEditor.hide();
					$("#kameleon").html(old_content);
					hideBtn();
					initContent();
				}
			});
			
			$(".previewEditor").on('click', function(){
				tinyMCE.activeEditor.save();
				tinyMCE.activeEditor.hide();
				hideBtn();
				initContent();
			});
			
			$(".saveEditor").on('click', function(){
				tinyMCE.activeEditor.save();
				var content = tinyMCE.activeEditor.getContent();
				$.ajax({
					type: "POST",
					url: base_dir+'kameleon/index.php?tab=AdminPage&ajax=1&action=UpdatePageFront',
					data: 'content='+escape(content)+'&id_page='+id_page+'&lang='+lang,
					complete: function(){
						old_content = tinyMCE.activeEditor.getContent();
						if(!window.confirm('Enregistrement effectué, cliquer sur "ok" pour continuer la saisie'))
						{
							tinyMCE.activeEditor.hide();
							hideBtn();
							initContent();
						}
					}
				});
			});
		}
		else
			$('p.btnEditor').show();
	}
	
	function initContent()
	{
		if($("#kameleon").html() == '')
			$("#kameleon").html('&lt;&lt; double-clic pour intégrer du contenu &gt;&gt;');
	}
	
	function nbPixel(string)
	{
		return parseInt(string.substring(0,string.length-2));
	}
	
});