
jQuery(document).ready(function(){

	$("input.date").datepicker({
		firstDay : 1,
		changeMonth: true,
      	changeYear: true,
		closeText: 'Fermer',
		prevText: 'Précédent',
		nextText: 'Suivant',
		currentText: 'Aujourd\'hui',
		monthNames: ['Janvier', 'Février', 'Mars', 'Avril', 'Mai', 'Juin', 'Juillet', 'Août', 'Septembre', 'Octobre', 'Novembre', 'Décembre'],
		monthNamesShort: ['Janv.', 'Févr.', 'Mars', 'Avril', 'Mai', 'Juin', 'Juil.', 'Août', 'Sept.', 'Oct.', 'Nov.', 'Déc.'],
		dayNames: ['Dimanche', 'Lundi', 'Mardi', 'Mercredi', 'Jeudi', 'Vendredi', 'Samedi'],
		dayNamesShort: ['Dim.', 'Lun.', 'Mar.', 'Mer.', 'Jeu.', 'Ven.', 'Sam.'],
		dayNamesMin: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
		weekHeader: 'Sem.',
		dateFormat: 'dd/mm/yy'

	});


	$(".bloc_pdts ul li input").each(function() {
		$(this).change(function() {
			var idt = $(this).attr('id');
			var prix = $(this).attr('data-price');
			var label = $(this).siblings('label').html();
			var nom = $(this).siblings('span').text();
			var ids = $(this).attr('data-id');
			if($(this).prop('checked') == true)
			{
				$('.bloc_caisse table.calcul tbody').append('<tr id="'+idt+'"><td><label class="d-flex align-items-center p-1 w-100">'+label+'</label><input name="noms[]" type="hidden" value="'+nom+'"></td><td><input name="ids[]" type="hidden" value="'+ids+'"><input name="pu[]" class="font-weight-bold pu" type="text" value="'+prix+'" readonly></td><td><input name="qte[]" class="font-weight-bold qte" type="number" min="1" value="1"></td><td><input name="totalligne[]" class="font-weight-bold totalligne" type="text" placeholder="Total" value="'+prix+'" readonly></td>');
			}
			else
			{
				$('.bloc_caisse table.calcul tbody tr#'+idt).remove();
			}

			CalculTotalAchat();
		});
	});

	$("table.calcul input").each(function() {
		$(document).on('change input paste','table.calcul input.qte',function(e){
			var qte = parseInt($(this).val());
			var pu = parseInt($(this).parents('tr').find('input.pu').val());

			$(this).parents('tr').find('input.totalligne').val(qte*pu);

			CalculTotalAchat();

		});
	});

	$(document).on('change input paste','table.calcul input.avance',function(e){
		CalculTotalAchat();
	});
	$(document).on('change input paste','table.calcul input.reduction',function(e){
		CalculTotalAchat();
	});

	$(document).on('change input paste','table.calcul input.transport',function(e){
		CalculTotalAchat();
	});

	$(document).on('click','ul#myTab li a',function(e){
	  e.preventDefault();
	  var id = $(this).attr('id');
	  
	  $('#myTabContent .tab-pane').removeClass('show active');
	  $('#myTabContent .tab-pane').hide();
	   $('aside.bloc_vente').removeClass('d-flex');
	  $('aside.bloc_vente').hide();

	  $('#myTabContent div#'+id).show();
	  $('#myTabContent div#'+id).addClass('show active');
	  $('aside#'+id).show();
	  $('aside#'+id).addClass('d-flex');
	})

});

function CalculTotalAchat() 
{
	var reduction = parseInt($('table.calcul input.reduction').val());
	var transport = parseInt($('table.calcul input.transport').val());
	var avance = parseInt($('table.calcul input.avance').val());
	var reste = parseInt($('table.calcul input.reste').val());

	$('table.calcul').each(function(){
      var totalAchat = 0;
      $(this).find('input.totalligne').each(function(i,n){
        totalAchat += parseInt($(n).val(),10); 
      });
      //alert(totalAchat);
      $('table.calcul input.totalachat').val(totalAchat);
      $('table.calcul input.netapayer').val(totalAchat+transport-reduction);
      $('table.calcul input.reste').val(totalAchat+transport-reduction-avance);
    });
    
}

function CalculMonnaie() 
{
	var espece = parseInt($('table.calcul input.espece').val());
	var totalach = parseInt($('table.calcul input.totalachat').val());
	var reduction = parseInt($('table.calcul input.reduction').val());
	var netapayer = parseInt($('table.calcul input.netapayer').val());

	$('table.calcul input.rendu').val(espece-totalach+reduction);
	$('table.calcul input.netapayer').val(totalach-reduction);

	var monnaie = $('table.calcul input.rendu').val();

	if((monnaie < 0) || (monnaie == 'NaN'))
	{
		$('table.calcul input.rendu').css('color', 'red').val('Espèces insuffisantes');
		$('table.calcul tr.valide_achat').hide('slow');
	}
	else
	{
		$('table.calcul input.rendu').css('color', 'black').val(monnaie);
		$('table.calcul tr.valide_achat').show('slow');
	}
}

function printDiv(divName) {
     var printContents = document.getElementById(divName).innerHTML;
     var originalContents = document.body.innerHTML;


     /*document.getElementById('mycanvas').style.display = 'none';
     document.getElementById('header').style.display = 'none';
     document.getElementsByClassName('temps')[0].classList.remove('d-flex');
     document.getElementsByClassName('temps')[0].classList.add('d-none');*/


     document.body.innerHTML = printContents;

     var head = document.getElementsByTagName('head')[0];  
  
        // Create new link Element 
        var link = document.createElement('link'); 
        var linkflex = document.createElement('link'); 
  
        // set the attributes for link element  
        link.rel = 'stylesheet';  
        linkflex.rel = 'stylesheet';  
      
        link.type = 'text/css'; 
        linkflex.type = 'text/css';

        linkflex.href = 'https://caisse.gdfprestations.com/themes/default_3_columns/css/style.css';    
        link.href = 'https://caisse.gdfprestations.com/themes/default_3_columns/css/style-print.css'; 
         
  
        // Append link element to HTML head 
        head.appendChild(linkflex);  
        head.appendChild(link);  

     window.print();

     document.body.innerHTML = originalContents;
}
