<?php
define('_FILE_ALERTE_',	dirname(__FILE__).'/alerte.xml');

class AlerteClass extends ObjectModel
{
	public static $xml = _FILE_ALERTE_;
	
	protected $table = 'alerte';
	
	public $name;
	
	public $mail;
	
	public $rechercheCategory;
	
	public $rechercheCity;
	
	public $recherchePrice;
	
	protected $fieldsAttributes = array();
	
	protected $fieldsRequired = array(
		'name',
		'mail');
		
	protected $fieldsValidate = array(
		'recherchePrice' => 'isString',
		'rechercheCategory' => 'isString',
		'rechercheCity' => 'isString',
		'name' => 'isGenericName',
		'mail' => 'isEmail');
	
	public static function getList()
	{
		$xml = self::getXML();
		return $xml->sortedXPath('//alerte', '@id', SORT_DESC);
	}
}