<?php
class Article extends ObjectModelDB
{
	public $id_article;
	public $price=0;
	public $nom_article;
	public $qte_article;

	public $id_user;
	
	public $date_add;
	public $date_upd;

	public $path;
	public $uri;

	public $images = array();
	public $image_cover = NULL;

	public $active = 1;
	public $position = 0;

	protected $fieldsRequired = array(
	);
		
	protected $fieldsValidate = array(
		'active' => 'isBool',
		'nom_article' => 'isGenericName',	
		'price' => 'isPrice',
		'qte_article' => 'isInt',
		'position' => 'isInt',
		'id_user' => 'isInt',
		'date_add' => 'isDateFormat',
		'date_upd' => 'isDateFormat'
	);
		

	public static $definition = array(
		'table' => 'article',
		'primary' => 'id_article',
		'multilang' => false);
		
	public function __construct($id = null)
	{
		parent::__construct($id);
		
		$this->path = dirname(__FILE__).'/images/';
		$this->uri = _BASE_URI_MODULES_.'immo/images/';
		
		if($this->id)
		{
			$this->getFullInfos();
			$this->getImages();
			$this->getCoverImage();
		}
	}

	static protected $cacheName = array();
	
	public static function getNameById($id_article)
	{
		if (!isset(self::$cacheName[$id_article]))
			self::$cacheName[$id_article] = Db::getInstance()->getValue('
				SELECT `nom_article`
				FROM `'._DB_PREFIX_.'article` a
				WHERE a.`id_article` = '.(int)$id_article.'
				');

		return self::$cacheName[$id_article];
	}
	
	public function getFullInfos()
	{
		$infosarticle = $this->getInfosByIdArticle((int)$this->id_article);
		
	}
	
	public function delete()
	{
		if(parent::delete())
		{
			$this->cleanImages();
			return true;
		}
		return false;
	}

	public static function getArticles()
	{
		$articles = new Collection('article');
		//$articles->where('active = 1 and id_article > 1');			
		$articles->orderby('nom_article ASC');			
		return $articles;
	}

	public static function changePositionListArticle($ordreas = false)
	{		
		if(is_array($ordreas))		
			foreach($ordreas as $position => $id)
			{
				Db::getInstance()->Execute('UPDATE article SET position = 0 WHERE id_article = '.(int)$id);
				Db::getInstance()->Execute('UPDATE article SET position = '.((int)$position + 1).' WHERE id_article = '.(int)$id);
			}
	
	}
	
	public function addImage()
	{
		$image = new Image();
		$image->id_article = $this->id;
		$image->cover = 0;
		$image->position = 1;
		$image->add();
					
		$upload = new Upload();
		$result = $upload->handleUpload($this->path, false, $image->id_article.'-'.$image->id);
		
		if(isset($result['success']) && $result['success'])
		{
			$filename = array_shift(explode('.',$result['filename']));
			$validate = Upload::validateUpload($this->path.$result['filename'], null, 'image');
			if($validate)
			{
				$image->getFullInfos();
				$image->generateImages();
				
				$result['filename'] = $filename;
				$result['id'] = $image->id;
			}
		}
		
		if((isset($validate) && $validate) || (isset($result['error']) && $result['error']))
			return htmlspecialchars(json_encode($result), ENT_NOQUOTES);
		$image->delete();
		return htmlspecialchars(json_encode(array('error' => 'Le fichier est de type invalide')), ENT_NOQUOTES);
	}
	
	public function getImages()
	{
		$images = Db::getInstance()->ExecuteS('SELECT * FROM image WHERE id_article = '.$this->id.' ORDER BY position ASC');
		foreach($images as $image)
		{
			if(file_exists($this->path.$this->id_article.'-'.$image['id_image'].'.jpg'))
			{
				$image['normal'] = $this->uri.$this->id_article.'-'.$image['id_image'].'.jpg';
				$image['min'] = $this->uri.$this->id_article.'-'.$image['id_image'].'-min.jpg';
				$image['cover'] = (bool)$image['cover'];
				$this->images[] = $image;
			}
		}
	}
	
	public function getCoverImage()
	{
		$image = Db::getInstance()->getRow('SELECT * FROM image WHERE id_article = '.$this->id.' AND cover = 1');
		if($image && file_exists($this->path.$this->id_article.'-'.$image['id_image'].'.jpg'))
		{
			$image['normal'] = $this->uri.$this->id_article.'-'.$image['id_image'].'.jpg';
			$image['min'] = $this->uri.$this->id_article.'-'.$image['id_image'].'-min.jpg';
			$this->image_cover = $image;
		}
		elseif($image && file_exists($this->path.$this->id_article.'-'.$image['id_image'].'.jpeg'))
		{
			$image['normal'] = $this->uri.$this->id_article.'-'.$image['id_image'].'.jpeg';
			$image['min'] = $this->uri.$this->id_article.'-'.$image['id_image'].'-min.jpeg';
			$this->image_cover = $image;
		}
		elseif($image && file_exists($this->path.$this->id_article.'-'.$image['id_image'].'.png'))
		{
			$image['normal'] = $this->uri.$this->id_article.'-'.$image['id_image'].'.png';
			$image['min'] = $this->uri.$this->id_article.'-'.$image['id_image'].'-min.png';
			$this->image_cover = $image;
		}
	}
	
	public function cleanImages()
	{
		$this->getImages();
		foreach($this->images as $imageDelete)
		{
			$image = new Image((int)$imageDelete['id_image']);
			$image->getFullInfos();
			$image->delete();
		}
	}

	public static function getInfosByIdArticle($id_article)
	{
		$infosarticle ="";

		$infos_article = Db::getInstance()->executeS('
			SELECT *
			FROM `article` a
			LEFT JOIN `user_ad` u ON (u.`id_user_ad` = a.`id_user`)
			WHERE a.`id_article` = '.(int)$id_article.'
		');

		foreach($infos_article as $info_article)
		{
			$infosarticle = $info_article;
		}
		return $infosarticle;
	}
}