<?php
class Client extends ObjectModelDB
{
	public $id_client;
	public $nom_client;
	public $prenom_client;
	public $active_client;
	public $adresse_client;
	public $contact_client;
	public $cni_client;
	public $date_add;	
	public $date_upd;

		
	protected $fieldsRequired = array();
		
	protected $fieldsValidate = array(
		'id_client' => 'isUnsignedId',
		'nom_client' => 'isAnything',
		'prenom_client' => 'isAnything',
		'active_client' => 'isAnything',	
		'adresse_client' => 'isAnything',	
		'contact_client' => 'isAnything',
		'cni_client' => 'isAnything',
		'date_add' => 'isDateFormat',
		'date_upd' => 'isDateFormat');
		

	public static $definition = array(
		'table' => 'client',
		'primary' => 'id_client',
		'multilang' => false
	);

	public static function getClients()
	{
		$clients = new Collection('client');
		
		return $clients;
	}

	public static function getClientsActifs()
	{
		$clients = new Collection('client');
		$clients->where('active_client = 1');
		
		return $clients;
	}
	

	public function getFullInfos()
	{
	}

	static protected $cacheName = array();
	
}