<?php
class Departement extends ObjectModelDB
{
	public $id_departement;
	public $id_ministere;
	public $nom_departement;
	public $description_departement;
	public $id_directeur_departement;
	public $date_add;
	public $date_upd;
		
		protected $fieldsRequired = array(
		'id_ministere',
		'nom_departement',
		'id_directeur_departement',
		'description_departement'
	);
		
	protected $fieldsValidate = array(
		'id_ministere' => 'isUnsignedId',
		'id_directeur_departement' => 'isUnsignedId',
		'nom_departement' => 'isGenericName',	
		'description_departement' => 'isAnything',
		'date_add' => 'isDateFormat',
		'date_upd' => 'isDateFormat');
		

	public static $definition = array(
		'table' => 'departement',
		'primary' => 'id_departement',
		'multilang' => false);

	public static function getDepartements()
	{
		$departements = new Collection('departement');
		return $departements;
	}
	
	static protected $cacheName = array();
	
	public static function getNameById($id_departement)
	{
		if (!isset(self::$cacheName[$id_departement]))
			self::$cacheName[$id_departement] = Db::getInstance()->getValue('
				SELECT `nom_departement`
				FROM `'._DB_PREFIX_.'departement` m
				WHERE m.`id_departement` = '.(int)$id_departement.'
				');

		return self::$cacheName[$id_departement];
	}

	public function getFullInfos()
	{
		$this->nom_ministere = Ministere::getNameById((int)$this->id_ministere);
		$this->detail_ministere = Ministere::getDetailById((int)$this->id_ministere);
		$this->info_directeur = Membre::getNameById((int)$this->id_directeur_departement);
	}
}