<?php
class Eglise extends ObjectModelDB
{
	public $id_zone;
	public $id_eglise;
	public $nom_eglise;
	public $description_eglise;
	public $id_directeur_eglise;
	public $date_add;
	public $date_upd;
		
		protected $fieldsRequired = array(
		'id_zone',
		'nom_eglise',
		'id_directeur_eglise',
		'description_eglise'
	);
		
	protected $fieldsValidate = array(
		'id_zone' => 'isUnsignedId',
		'id_directeur_eglise' => 'isUnsignedId',
		'nom_eglise' => 'isGenericName',	
		'description_eglise' => 'isAnything',
		'date_add' => 'isDateFormat',
		'date_upd' => 'isDateFormat');
		
		
	public static $definition = array(
		'table' => 'eglise',
		'primary' => 'id_eglise',
		'multilang' => false);

	public static function getEglises()
	{
		$eglises = new Collection('eglise');
		$eglises->orderby('nom_eglise ASC');
		
		return $eglises;
	}
	
	static protected $cacheName = array();
	
	public static function getNameById($id_eglise)
	{
		if (!isset(self::$cacheName[$id_eglise]))
			self::$cacheName[$id_eglise] = Db::getInstance()->getValue('
				SELECT `nom_eglise`
				FROM `'._DB_PREFIX_.'eglise` d
				WHERE d.`id_eglise` = '.(int)$id_eglise.'
				');

		return self::$cacheName[$id_eglise];
	}

	public function getFullInfos()
	{
		$this->nom_zone = Zone::getNameById((int)$this->id_zone);
		$this->info_directeur = Membre::getNameById((int)$this->id_directeur_eglise);
	}

	public static function getInfosEgliseByIdEglise($id_eglise)
	{
		$infoseglise ="";

		$infos_eglise = Db::getInstance()->executeS('
			SELECT *
			FROM `division` d
			LEFT JOIN `station` s ON (d.`id_division` = s.`id_division`)
			LEFT JOIN `region` r ON (r.`id_station` = s.`id_station`)
			LEFT JOIN `zone` z ON (z.`id_region` = r.`id_region`)
			LEFT JOIN `eglise` e ON (e.`id_zone` = z.`id_zone`)
			WHERE e.`id_eglise` = '.(int)$id_eglise.'
		');

		foreach($infos_eglise as $info_eglise)
		{
			$infoseglise = $info_eglise;
		}

		return $infoseglise;
	}
}