<?php
class Employe extends ObjectModelDB
{
	public $id_employe;
	public $nom_employe;
	public $prenom_employe;
	public $active_employe;
	public $type_employe;
	public $infos_employe;
	public $date_entree;
	public $date_sortie;	
	public $date_add;	
	public $date_upd;

		
	protected $fieldsRequired = array();
		
	protected $fieldsValidate = array(
		'id_employe' => 'isUnsignedId',
		'nom_employe' => 'isAnything',
		'prenom_employe' => 'isAnything',
		'active_employe' => 'isAnything',	
		'type_employe' => 'isAnything',	
		'infos_employe' => 'isAnything',
		'date_entree' => 'isAnything',
		'date_sortie' => 'isAnything',
		'date_add' => 'isDateFormat',
		'date_upd' => 'isDateFormat');
		

	public static $definition = array(
		'table' => 'employe',
		'primary' => 'id_employe',
		'multilang' => false
	);

	public static function getEmployes()
	{
		$employes = new Collection('employe');
		
		return $employes;
	}

	public static function getEmployesActifs()
	{
		$employes = new Collection('employe');
		$employes->where('active_employe = 1');
		
		return $employes;
	}
	

	public function getFullInfos()
	{
	}

	static protected $cacheName = array();
	
}