<?php
class Image extends ObjectModelDB
{
	public $id_image;
	
	public $id_article;
	
	public $cover = 0;
	public $position = 0;
	
	public $path = NULL;
	public $filename = NULL;
	
	protected $fieldsRequired = array(
		'id_article'
	);
		
	protected $fieldsValidate = array(
		'id_article' => 'isUnsignedId',
		'cover' => 'isInt',
		'position' => 'isInt');

	public static $definition = array(
		'table' => 'image',
		'primary' => 'id_image');
		
	public function __construct($id = null, $lang = null)
	{
		parent::__construct($id, $lang);
		$this->path = dirname(__FILE__).'/images/';
	}
	
	public function getFullInfos()
	{
		$this->filename = $this->id_article.'-'.$this->id;
	}
		
	public function setCover()
	{
		Db::getInstance()->Execute('UPDATE image SET cover = 0 WHERE id_article = '.$this->id_article);
		$this->cover = 1;		
		$this->update();
	}
	
	public function delete()
	{
		if(parent::delete())
		{
			@unlink($this->path.$this->filename.'.jpg');
			@unlink($this->path.$this->filename.'-min.jpg');
			
			return true;
		}
	}
	
	public function generateImages()
	{
		if (@getimagesize($this->path.$this->filename.'.jpg'))
		{
			ImageManager::resize($this->path.$this->filename.'.jpg', $this->path.$this->filename.'-min.jpg', 132, 170);
		}
		
		if (@getimagesize($this->path.$this->filename.'.png'))
		{
			ImageManager::resize($this->path.$this->filename.'.png', $this->path.$this->filename.'-min.png', 132, 170);
		}

		if (@getimagesize($this->path.$this->filename.'.jpeg'))
		{
			ImageManager::resize($this->path.$this->filename.'.jpeg', $this->path.$this->filename.'-min.jpeg', 132, 170);
		}
	}
	
	public static function changePosition($imgs = false)
	{
		if(is_array($imgs))
			foreach($imgs as $position => $id)
				Db::getInstance()->Execute('UPDATE image SET position = '.((int)$position + 1).' WHERE id_image = '.(int)$id);
	}
	
	public static function getList()
	{
		$images = new Collection('image');		
		return $images;
	}
}