<?php
class Ministere extends ObjectModelDB
{
	public $id_ministere;
	public $id_bloc_ministeriel;
	public $nom_ministere;
	public $description_ministere;
	public $id_directeur_ministere;
	public $date_add;
	public $date_upd;
		
		protected $fieldsRequired = array(
		'id_bloc_ministeriel',
		'nom_ministere',
		'id_directeur_ministere',
		'description_ministere'
	);
		
	protected $fieldsValidate = array(
		'id_bloc_ministeriel' => 'isUnsignedId',
		'id_directeur_ministere' => 'isUnsignedId',
		'nom_ministere' => 'isGenericName',	
		'description_ministere' => 'isAnything',
		'date_add' => 'isDateFormat',
		'date_upd' => 'isDateFormat');
		

	public static $definition = array(
		'table' => 'ministere',
		'primary' => 'id_ministere',
		'multilang' => false);

	public static function getMinisteres()
	{
		$ministeres = new Collection('ministere');
		$ministeres->where('a.nom_ministere != "Inconnu"');
		
		return $ministeres;
	}
	
	static protected $cacheName = array();
	
	public static function getNameById($id_ministere)
	{
		if (!isset(self::$cacheName[$id_ministere]))
			self::$cacheName[$id_ministere] = Db::getInstance()->getValue('
				SELECT `nom_ministere`
				FROM `'._DB_PREFIX_.'ministere` m
				WHERE m.`id_ministere` = '.(int)$id_ministere.'
				');

		return self::$cacheName[$id_ministere];
	}
	public static function getDetailById($id_ministere)
	{
		$detail_ministere = Db::getInstance()->getValue('
			SELECT `description_ministere`
			FROM `'._DB_PREFIX_.'ministere` m
			WHERE m.`id_ministere` = '.(int)$id_ministere.'
		');
		
		$abrev = strstr($detail_ministere, '(');

		return $abrev;
	}

	public function getFullInfos()
	{
		$this->nom_bloc_ministeriel = Bloc_ministeriel::getNameById((int)$this->id_bloc_ministeriel);
		$this->info_directeur = Membre::getNameById((int)$this->id_directeur_ministere);
	}
}