<?php
class Region extends ObjectModelDB
{
	public $id_station;
	public $id_region;
	public $nom_region;
	public $description_region;
	public $id_directeur_region;
	public $date_add;
	public $date_upd;
		
		protected $fieldsRequired = array(
		'id_station',
		'nom_region',
		'id_directeur_region',
		'description_region'
	);
		
	protected $fieldsValidate = array(
		'id_station' => 'isUnsignedId',
		'id_directeur_region' => 'isUnsignedId',
		'nom_region' => 'isGenericName',	
		'description_region' => 'isAnything',
		'date_add' => 'isDateFormat',
		'date_upd' => 'isDateFormat');
		
		
	public static $definition = array(
		'table' => 'region',
		'primary' => 'id_region',
		'multilang' => false);

	public static function getRegions()
	{
		$regions = new Collection('region');
		
		return $regions;
	}
	
	static protected $cacheName = array();
	
	public static function getNameById($id_region)
	{
		if (!isset(self::$cacheName[$id_region]))
			self::$cacheName[$id_region] = Db::getInstance()->getValue('
				SELECT `nom_region`
				FROM `'._DB_PREFIX_.'region` d
				WHERE d.`id_region` = '.(int)$id_region.'
				');

		return self::$cacheName[$id_region];
	}

	public function getFullInfos()
	{
		$this->nom_station = Station::getNameById((int)$this->id_station);
		$this->info_directeur = Membre::getNameById((int)$this->id_directeur_region);
	}

}