<?php
class Sector_Ad extends ObjectModelDB
{
	public $id_sector_ad;
	
	public $name;
		
	protected $fieldsRequiredLang = array(
		'name');
	
	protected $fieldsValidateLang = array(
		'name' => 'isGenericName');
	
	protected $fieldsSizeLang = array(
		'name' => 100);

	public static $definition = array(
		'table' => 'sector_ad',
		'primary' => 'id_sector_ad',
		'multilang' => true);

	public static function getSectorAds($id_lang = _DEFAULT_LANG_)
	{
		$sectorAds = new Collection('sector_ad', $id_lang);
		$sectorAds->orderBy('name');
		return $sectorAds;
	}
	
	static protected $cacheName = array();
	
	public static function getNameById($id_sector_ad, $lang)
	{
		if (!isset(self::$cacheName[$id_sector_ad.$lang]))
			self::$cacheName[$id_sector_ad.$lang] = Db::getInstance()->getValue('
				SELECT `name`
				FROM `'._DB_PREFIX_.'sector_ad` c
				LEFT JOIN `'._DB_PREFIX_.'sector_ad_lang` cl ON (c.`id_sector_ad` = cl.`id_sector_ad`)
				WHERE c.`id_sector_ad` = '.(int)$id_sector_ad.'
				AND cl.lang = "'.$lang.'"'
			);

		return self::$cacheName[$id_sector_ad.$lang];
	}
}