<?php
class Station extends ObjectModelDB
{
	public $id_station;
	public $id_division;
	public $nom_station;
	public $description_station;
	public $id_directeur_station;
	public $date_add;
	public $date_upd;
		
		protected $fieldsRequired = array(
		'id_division',
		'nom_station',
		'id_directeur_station',
		'description_station'
	);
		
	protected $fieldsValidate = array(
		'id_division' => 'isUnsignedId',
		'id_directeur_station' => 'isUnsignedId',
		'nom_station' => 'isGenericName',	
		'description_station' => 'isAnything',
		'date_add' => 'isDateFormat',
		'date_upd' => 'isDateFormat');
		

	public static $definition = array(
		'table' => 'station',
		'primary' => 'id_station',
		'multilang' => false);

	public static function getStations()
	{
		$stations = new Collection('station');
		
		return $stations;
	}

	public function getFullInfos()
	{
		$this->nom_division = Division::getNameById((int)$this->id_division);
		$this->info_directeur = Membre::getNameById((int)$this->id_directeur_station);
	}
	
	static protected $cacheName = array();
	
	public static function getNameById($id_station)
	{
		if (!isset(self::$cacheName[$id_station]))
			self::$cacheName[$id_station] = Db::getInstance()->getValue('
				SELECT `nom_station`
				FROM `'._DB_PREFIX_.'station` d
				WHERE d.`id_station` = '.(int)$id_station.'
				');

		return self::$cacheName[$id_station];
	}
}