<?php
class User_Ad extends ObjectModelDB
{
	public $id_user_ad;
	
	public $login;
	public $name;
	public $type;
	public $password;
	public $statut = 1;
	
	public $typeTab = array();

	protected $fieldsRequired = array(
		'statut');
		
	protected $fieldsValidate = array(
		'id_user_ad' => 'isUnsignedId',
		'statut' => 'isBool');
	
	protected $fieldsValidateLang = array(
		'id_user_ad' => 'isUnsignedId',
		'name' => 'isString',
		'type' => 'isGenericName',
		'login' => 'isGenericName',
		'password' => 'isGenericName');
	
	
	public static $definition = array(
		'table' => 'user_ad',
		'primary' => 'id_user_ad',
		'multilang' => true);
		
		
	public function __construct($id = null, $lang = null)
	{
		parent::__construct($id, $lang);
		
			
		if($this->id && $lang)
		{
			$this->getTypesByUser();
			
		}			
		
	}	
		

	public static function getUserAds($id_lang = _DEFAULT_LANG_)
	{
		$userAds = new Collection('user_ad', $id_lang);
		$userAds->orderBy('a.id_user_ad ASC');
		return $userAds;
	}

	public static function getCaissieres($id_lang = _DEFAULT_LANG_)
	{
		$userAds = new Collection('user_ad', $id_lang);
		$userAds ->where('type = "Caissière"');
		$userAds->orderBy('a.id_user_ad ASC');
		return $userAds;
	}
	
	
	public function getFullInfos($lang = _DEFAULT_LANG_)
	{
		//$this->type_name = Type_Ad::getNameById((int)$this->id_type_ad, $lang);

	}
	
		static protected $cacheName = array();
	
	public static function getNameById($id_user_ad, $lang)
	{
		if (!isset(self::$cacheName[$id_user_ad.$lang]))
			self::$cacheName[$id_user_ad.$lang] = Db::getInstance()->getValue('
				SELECT `name`
				FROM `'._DB_PREFIX_.'user_ad` u
				LEFT JOIN `'._DB_PREFIX_.'user_ad_lang` ul ON (u.`id_user_ad` = ul.`id_user_ad`)
				WHERE u.`id_user_ad` = '.(int)$id_user_ad.'
				AND ul.lang = "'.$lang.'"'
			);

		return self::$cacheName[$id_user_ad.$lang];
	}
	
	public static function getUserByInfos($login, $password, $lang)
	{
		$infos = Db::getInstance()->ExecuteS('
				SELECT u.*, ul.*
				FROM `'._DB_PREFIX_.'user_ad` u
				LEFT JOIN `'._DB_PREFIX_.'user_ad_lang` ul ON (u.`id_user_ad` = ul.`id_user_ad`)
				WHERE ul.`login` = "'.$login.'"
				AND ul.`password` = "'.$password.'"
				AND ul.lang = "'.$lang.'"'
			);
		return $infos;
	}
	
	public static function getUserInfosByid($id_user_ad, $lang)
	{
		$infos = Db::getInstance()->ExecuteS('
				SELECT u.*, ul.*
				FROM `'._DB_PREFIX_.'user_ad` u
				LEFT JOIN `'._DB_PREFIX_.'user_ad_lang` ul ON (u.`id_user_ad` = ul.`id_user_ad`)
				WHERE ul.`id_user_ad` = '.(int)$id_user_ad.'
				AND ul.lang = "'.$lang.'"'
			);
		return $infos;
	}
	
	
	public  function getTypesByUser()
	{
		$typesUsers = Db::getInstance()->ExecuteS('SELECT distinct type FROM user_ad_lang WHERE id_user_ad = '.$this->id);
		
		foreach($typesUsers as $type)
		{
			$this->typeTab[] = $type['type'];
		
		}
		
	}	
	
}