<?php
class Zone extends ObjectModelDB
{
	public $id_region;
	public $id_zone;
	public $nom_zone;
	public $description_zone;
	public $id_directeur_zone;
	public $date_add;
	public $date_upd;
		
		protected $fieldsRequired = array(
		'id_region',
		'nom_zone',
		'id_directeur_zone',
		'description_zone'
	);
		
	protected $fieldsValidate = array(
		'id_region' => 'isUnsignedId',
		'id_directeur_zone' => 'isUnsignedId',
		'nom_zone' => 'isGenericName',	
		'description_zone' => 'isAnything',
		'date_add' => 'isDateFormat',
		'date_upd' => 'isDateFormat');
		
		
	public static $definition = array(
		'table' => 'zone',
		'primary' => 'id_zone',
		'multilang' => false);

	public static function getZones()
	{
		$zones = new Collection('zone');
		
		return $zones;
	}
	
	static protected $cacheName = array();
	
	public static function getNameById($id_zone)
	{
		if (!isset(self::$cacheName[$id_zone]))
			self::$cacheName[$id_zone] = Db::getInstance()->getValue('
				SELECT `nom_zone`
				FROM `'._DB_PREFIX_.'zone` d
				WHERE d.`id_zone` = '.(int)$id_zone.'
				');

		return self::$cacheName[$id_zone];
	}

	public function getFullInfos()
	{
		$this->nom_region = Region::getNameById((int)$this->id_region);
		$this->info_directeur = Membre::getNameById((int)$this->id_directeur_zone);
	}
}