<?php
class Vente extends ObjectModelDB
{
	public $id_vente;
	public $id_commande;
	public $id_article;
	public $pu;
	public $quantite;
	public $totalligne;
	public $reduction;
	public $totalachat;	
	public $netapayer;	
	public $espece;
	public $rendu;
	public $date_add;
	public $date_upd;
	public $id_user_ad;

		
		protected $fieldsRequired = array();
		
	protected $fieldsValidate = array(
		'id_vente' => 'isUnsignedId',
		'id_commande' => 'isUnsignedId',
		'id_article' => 'isUnsignedId',
		'pu' => 'isInt',	
		'quantite' => 'isInt',	
		'totalligne' => 'isInt',
		'totalachat' => 'isInt',
		'reduction' => 'isInt',
		'netapayer' => 'isInt',

		'espece' => 'isInt',
		'rendu' => 'isInt',
		'id_user_ad' => 'isUnsignedId',
		'date_add' => 'isDateFormat',
		'date_upd' => 'isDateFormat');
		

	public static $definition = array(
		'table' => 'vente',
		'primary' => 'id_vente',
		'multilang' => false);

	public static function getVentes()
	{
		$ventes = new Collection('vente');
		
		return $ventes;
	}
	

	public function getFullInfos()
	{
	}

	static protected $cacheName = array();
	
}