
{if $logged}
	{if $page->id == $home}
		<div class="d-flex justify-content-center w-100 p-2 accueil flex-wrap">		
			<div class="card text-white bg-warning m-2" style="max-width: 18rem;">
			  <div class="card-header font-weight-bold text-uppercase">Clients</div>
			  <div class="card-body">
			    <p class="card-text">Enregistrement d'un ou plusieurs clients.</p>
			    <a href="{$tree->getLink(12,$lang)}?addclt=1" class="btn btn-light">Procédez ></a>
			  </div>
			</div>

			<div class="card text-white bg-success m-2" style="max-width: 18rem;">
			  <div class="card-header font-weight-bold text-uppercase">Location</div>
			  <div class="card-body">
			    <p class="card-text">Enregistrement d'un ou plusieurs contrats de location.</p>
			    <a href="{$tree->getLink(2,$lang)}" class="btn btn-light">Procédez ></a>
			  </div>
			</div>

			<div class="card text-white bg-danger m-2" style="max-width: 18rem;">
			  <div class="card-header font-weight-bold text-uppercase">Dépenses</div>
			  <div class="card-body">
			    <p class="card-text">Enregistrement d'une ou plusieurs dépenses effectuées.</p>
			    <a href="{$tree->getLink(12,$lang)}?adddep=1" class="btn btn-light">Procédez ></a>
			  </div>
			</div>

			<div class="card text-white bg-secondary m-2" style="max-width: 18rem;">
			  <div class="card-header font-weight-bold text-uppercase">Articles</div>
			  <div class="card-body">
			  	{if $user[0]['type'] == "Admin"}
			    <p class="card-text">Ajout, modification ou suppression d'un ou plusieurs articles.</p>
			    {else}
			    <p class="card-text">Consultation de la liste des articles.</p>
			    {/if}
			    <a href="{$tree->getLink(10,$lang)}" class="btn btn-light">Procédez ></a>
			  </div>
			</div>
			{if $user[0]['type'] == "Admin"}
				<div class="card text-white bg-info m-2" style="max-width: 18rem;">
				  <div class="card-header font-weight-bold text-uppercase">Caissières</div>
				  <div class="card-body">
				    <p class="card-text">Ajout, modification ou suppression d'une ou plusieurs caissières.</p>
				    <a href="{$tree->getLink(12,$lang)}?addcai=1" class="btn btn-light">Procédez ></a>
				  </div>
				</div>

				<div class="card text-white bg-secondary m-2" style="max-width: 18rem;">
				  <div class="card-header font-weight-bold text-uppercase">Employés / Salaire</div>
				  <div class="card-body">
				    <p class="card-text">Gestion des employés et leur salaire.</p>
				    <a href="{$tree->getLink(12,$lang)}?addemp=1" class="btn btn-light">Procédez ></a>
				  </div>
				</div>

				<div class="card text-white bg-info m-2" style="max-width: 18rem;">
				  <div class="card-header font-weight-bold text-uppercase">Autres dépenses</div>
				  <div class="card-body">
				    <p class="card-text">Gestion des autres type de dépenses (Mairie, taxes,...).</p>
				    <a href="{$tree->getLink(12,$lang)}?adddep2=1" class="btn btn-light">Procédez ></a>
				  </div>
				</div>

				<div class="card text-white bg-warning m-2" style="max-width: 18rem;">
				  <div class="card-header font-weight-bold text-uppercase">Statistiques</div>
				  <div class="card-body">
				    <p class="card-text">Détails des ventes et dépenses effectuées par le magasin sur une période donnée.</p>
				    <a href="{$tree->getLink(9,$lang)}" class="btn btn-light">Voir ></a>
				  </div>
				</div>
			{/if}

		</div>
	{/if}

	{if $page->id == 2}

		{if $valid}
	        <div class="alert alert-success text-center d-flex flex-column align-items-center w-100" role="alert">
	            <p class="valid">{$valid}</p>
	            <a class="btn btn-primary" href="{$tree->getLink(2, $lang)}">Ajoutez une nouvelle vente</a>
	        </div>
	    {else}

	    	<div class="w-100 aimprimer" style="display: none;" id="aimprimer">
	    		<div id="contenu" class="w-100"></div>				 
	    	</div>


			<aside class="col-12 col-md-3 bloc_pdts">
				<div class="card bg-primary mb-3 w-100">
				  <div class="card-header text-white">Articles</div>
				  <ul class="list-group list-group-flush">
				    {$HOME}
				  </ul>
				</div>
			</aside>
			<aside class="col-12 col-md-9 bloc_caisse flex-column">
				<form role="form" action="{$request_uri|escape:'htmlall':'UTF-8'}" method="post" class="validachat-form" id="validachat-form" enctype="multipart/form-data">
					<legend class="gestion d-flex w-100 justify-content-center align-items text-center p-2">GESTION DES LOCATIONS</legend>
					<table class="calcul">
						<thead>
						  <div class="form-group mb-2 d-flex align-items-center">
						    <select class="form-control mr-3" id="id_client" name="id_client">
						      <option value="">Selectionnez le client</option>
						      {foreach from=$clients item=client}
						      	<option value="{$client->id_client}" nom="{$client->nom_client} {$client->prenom_client}" adr="{$client->adresse_client}" cel="{$client->contact_client}" cni="{$client->cni_client}">{$client->nom_client} {$client->prenom_client} ({$client->contact_client})</option>
						      {/foreach}
						    </select>
						    <a class="btn btn-primary" href="{$tree->getLink(12,$lang)}?addclt=1">Ajouter Client</a>
						  </div>

						  <div class="form-group mb-2 d-flex align-items-center">
						    <select class="form-control mr-3 d-none" id="date_add" name="date_add">
						      <option value="">Selectionnez une date</option>
						    </select>
						  </div>
 
							<tr>
								<th>Désignation</th>
								<th>Prix Unitaire</th>
								<th>Quantité</th>
								<th>Total</th>
							</tr>
						</thead>
						<tbody></tbody>
						<hr>
						<tfoot>
							<tr class="d-flex w-100 m-5"></tr>

							<tr>
								<td></td>
								<td></td>
								<td>Transport</td>
								<th><input required name="transport" class="text-center font-weight-bold transport text-success" type="number" min="0" value="0"></th>
							</tr>

							<tr>
								<td></td>
								<td></td>
								<th>Total</th>
								<td><input required name="totalachat" class="text-center font-weight-bold totalachat text-primary" type="number" placeholder="Total" readonly></td>
							</tr>

							<tr>
								<td></td>
								<td></td>
								<td>Remise</td>
								<th><input required name="reduction" class="text-center font-weight-bold reduction text-secondary" type="number" min="0" value="0"></th>
							</tr>
							<tr>
								<td></td>
								<td></td>
								<td>Net à payer</td>
								<th><input required name="netapayer" class="text-center font-weight-bold netapayer text-success" type="number" min="0" required readonly></th>
							</tr>

							<tr>
								<td></td>
								<td></td>
								<td>Avance</td>
								<th><input required name="avance" class="text-center font-weight-bold avance text-success" type="number" min="0" value="0"></th>
							</tr>

							<tr>
								<td></td>
								<td></td>
								<th>Reste à payer</th>
								<th><input required name="reste" class="text-center font-weight-bold reste text-info" type="number" min="0" value="0" readonly></th>
							</tr>
							<tr class="d-flex w-100 mt-3"></tr>
							<tr class="valide_achat">
								<td></td>
								<td></td>
								<td><input required name="iduser" value="{$user[0]['id_user_ad']}" type="hidden"></td>
								<td>
									<input class="text-center font-weight-bold valideachattest btn btn-success" name="valideachattest" id="valideachattest" type="submit" value="Valider">

									<input class="text-center font-weight-bold proformat btn btn-info" name="proformat" id="proformat" type="submit" value="Proformat">
								</td>
							</tr>
						</tfoot>
					</table>
				</form>
			</aside>
			<aside class="w-100 p-2 bloc_vente">
				<table class="table table-dark">
					<thead>
						<tr class="text-uppercase text-center" style="background:#ff6701">
							<th></th>
							<th></th>
							<th>Ventes du Jour</th>
							<th></th>
							<th></th>
						</tr>
						<tr>
							<th>Désignation</th>
							<th>Prix Unitaire</th>
							<th>Quantité</th>
							<th>Total</th>
							<th>Heure</th>
							{if $user[0]['type'] == "Admin"}<th>Action</th>{/if}
						</tr>
					</thead>
					<tbody>
						{$ventetab}
						<tr>
							<th></th>
							<th></th>
							<th></th>
							<th class="bg-warning">{$Tools->displayPrice($totalventedujour)}</th>
							<th class="bg-info text-center">{if $user[0]['type'] == "Admin"}<a href="{$tree->getLink(9,$lang)}">Statistiques ></a>{/if}</th>
						</tr>
					</tbody>					
				</table>
			</aside>
		{/if}
	{/if}

{$CENTER_TOP}
{$page->content_front}
{$CENTER_BOTTOM}
{/if}