<?php
/**
 * Class_dbMysql.php
 * 
 * Classe de gestion des bases de donnes de type Mysql.
 */


Class DataBase {
    
    /**
     * Stocke l'instance de connexion  la base
     * Type : object
    */
    protected $_dbConn;
    
    /**
     * Stocke le nom de la base
     * Type : string
    */
    protected $_dbName;
    
    /**
     * Stocke le nom d'utilisateur
     * Type : string
    */
    protected $_dbUserName;
    
    /**
     * Stocke le mot de passe
     * Type : string
    */
    protected $_dbPassword;
    
    /**
     * Stocke l'adresse du serveur
     * Type : string
    */
    protected $_dbHost;
    
    
    /**
     * Constructeur de la classe.
     * @params : adresse du serveur, nom de la base de donnes, nom d'utilisateur, mot de passe
     * @return null : initialise les valeurs par dfaut
     */
    public function __construct($host, $dbname, $username, $password) {
	/* Initialisation des variables globales */
	if (!empty($host)) { $this->_dbHost = $host; }
	if (!empty($dbname)) { $this->_dbName = $dbname; }
	if (!empty($username)) { $this->_dbUserName = $username; }
	if (!empty($password)) { $this->_dbPassword = $password; }
	/* Connexion  la base de donnes */
	$this->DbConnect();
    }
    
    /**
     * Mthode permettant d'envoyer les requtes SQl au serveur Mysql.
     * @params : requte SQL
     * @return object
     */
    public function DbQuery($sql) {
	$tabRes = @mysql_query($sql, $this->_dbConn) or trigger_error("Erreur dans l'excution de la requte.", E_USER_WARNING);
	return $tabRes;
    }
    
    /**
     * Mthode grant les requtes de slection sous forme associative.
     * @params : requte SQL
     * @return array : tableau associatif  2 dimensions
     */
    public function getSelectQueryAssocResults($sql) {
	if ($tab = $this->DbQuery($sql)) {
	    $tabReturn = array();
	    while ($row = @mysql_fetch_assoc($tab)) {
		$tabReturn[] = $row;
	    }
	    return $tabReturn;
	}
	else {
	    return false; }
    }
    
    /**
     * Mthode grant les requtes de slection sous forme d'indices numriques.
     * @params : requte SQL
     * @return array : tableau associatif  2 dimensions
     */
    public function getSelectQueryNumResults($sql) {
	if ($tab = $this->DbQuery($sql)) {
	    $tabReturn = array();
	    while ($row = @mysql_fetch_row($tab)) {
		$tabReturn[] = $row;
	    }
	    return $tabReturn;
	}
	else {
	    return false; }
    }
    
    /**
     * Mthode permettant de rcuprer un ID cr par un champ auto_increment.
     * @return integer : ID
     */
    public function DbReturnId() {
	$intID = @mysql_insert_id() or trigger_error("Impossible de retourner l'ID gnr.", E_USER_WARNING);
	return $intID;
    }
    
    /*
     * Methode recuperant la liste des tables de la base.
     * return array
     */
    public function getTablesList() {
	$sql = "SHOW TABLES FROM ".$this->_dbName;
	$tabRs = $this->getSelectQueryNumResults($sql);
	
	return $tabRs;
    }
    
    /*
     * Methode recuperant la structure d'une table.
     * @params : nom de la table
     * return array
     */
    public function getTableStructure($table) {
	$sql = "SHOW CREATE TABLE ".$table;
	$tabRs = $this->getSelectQueryNumResults($sql);
	
	return $tabRs;
    }
    
    /*
     * Methode recuperant les donnes d'une table.
     * @params : nom de la table
     * return array
     */
    public function getTableDatas($table) {
	$sql = "SELECT * FROM ".$table;
	$tabRs = $this->getSelectQueryNumResults($sql);
	
	return $tabRs;
    }
    
    /*
     * Methode recuperant les champs d'une table.
     * @params : nom de la table
     * return array
     */
    public function getTableFields($table) {
	$sql = "SHOW COLUMNS FROM ".$table;
	$tabRs = $this->getSelectQueryNumResults($sql);
	
	return $tabRs;
    }
    
    /**
     * Mthode fermant la base de donnes.
     */
    public function DbClose() {
	@mysql_close($this->_dbConn) or trigger_error("Impossible de fermer la base.", E_USER_WARNING);
    }
    
    
    /**
     * Mthode permettant la connexion  la base de donnes.
     */
    private function DbConnect() {
	$this->_dbConn = @mysql_connect($this->_dbHost, $this->_dbUserName, $this->_dbPassword) or trigger_error("Impossible d'tablir la connexion.", E_USER_ERROR);
	@mysql_select_db($this->_dbName, $this->_dbConn) or trigger_error("Impossible de slectionner la base de donnes.", E_USER_ERROR);
    }
    
}
?>