<?php
/**
 * Class_dumpMysql.php
 * 
 * Classe de dump d'une base de donnes de type mysql.
 * v. 1.0
 */

require "class_dbMysql.php";

Class DumpMysql extends DataBase {
    
    /**
     * Stocke l'emplacement du fichier de dump.
     * Type : string
     */
    private $_dumpFile;
    
    /**
     * Stocke l'instance du fichier de dump.
     * Type : object
     */
    private $_objFile;
    
    /**
     * Stocke le type de dump effectu.
     * Type : string
     */
    private $_dumpType;
    
    /**
     * Stocke le premier sparateur.
     * Type : string
     */
    private $_sp1;
    
    /**
     * Stocke le second sparateur.
     * Type : string
     */
    private $_sp2;
    
    
    /**
     * Constructeur de la classe.
     * @params : adresse du serveur, nom de la base de donnes, nom d'utilisateur, mot de passe
     * @return null : initialise les valeurs par dfaut de la classe database
     */
    public function __construct($host, $dbname, $username, $password) {
	parent::__construct($host, $dbname, $username, $password);
	
	$this->_sp1 = "--";
	$this->_sp2 = $this->_sp1." --------------------------------------------------------";
    }
    
    /*
     * Methode effectuant le dump de la base.
     * @params : path du fichier (optionnel)
     */
    public function dumpDatabase($file) {
	$this->_dumpType = "database";
	
	/* Gestion du fichier de dump */
	$this->setDumpFile($file);
	
	/* Rcupration des tables de la base */
	$arrayTablesList = $this->getTablesList();
	
	/* Ouverture du fichier et ecriture des en-tetes */
	if (!$this->_objFile = fopen($this->_dumpFile, "w+")) { trigger_error("Impossible d'ouvrir le fichier", E_USER_ERROR); }
	$strHeaders = $this->getHeaders();
	fwrite($this->_objFile, $strHeaders);
	
	/* Boucle d'ecriture sur les tables de la base */
	for ($n = 0; $n < sizeof($arrayTablesList); $n++) {
	    $this->dumpTable($arrayTablesList[$n][0], "");
	    
	    if ($n < (sizeof($arrayTablesList) - 1)) { fwrite($this->_objFile, "\n".$this->_sp2."\n\n"); }
	}
	
	fclose($this->_objFile);
	$this->_dumpType = "";
    }
    
    /**
     * Methode effectuant le dump d'une table.
     * @params : table sur laquelle faire le dump, fichier de sortie
     */
    public function dumpTable($table, $file) {
	/* Vrification du type de dump */
	if (!isset($this->_dumpType) || empty($this->_dumpType)) {
	    $this->_dumpType = "table";
	    
	    // Gestion du fichier de dump
	    $this->setDumpFile($file);
	    // Ouverture du fichier et ecriture des en-tetes
	    if (!$this->_objFile = fopen($this->_dumpFile, "w+")) { trigger_error("Impossible d'ouvrir le fichier", E_USER_ERROR); }
	    // Ecriture des en-ttes
	    $strHeaders = $this->getHeaders();
	    fwrite($this->_objFile, $strHeaders);
	}
	
	/* Nom de la table */
	fwrite($this->_objFile, $this->_sp1."\n".$this->_sp1." Table ".$table." structure\n".$this->_sp1."\n\n");
	
	/* Insertion de la structure de la table */
	$tabStructure = $this->getTableStructure($table);
	fwrite($this->_objFile, $tabStructure[0][1].";\n\n");
	
	/* Insertion des donnes de la table */
	fwrite($this->_objFile, $this->_sp1."\n".$this->_sp1." Table ".$table." datas\n".$this->_sp1."\n\n");
	$tabDatas = $this->getTableDatas($table);
	for ($i = 0; $i < sizeof($tabDatas); $i++) {
	    $strTmp = addslashes(stripslashes(implode($tabDatas[$i], "_____")));
	    $strTmp = str_replace("_____", "', '", $strTmp);
	    $str = "INSERT INTO `".$table."` VALUES ('".$strTmp."');";
	    fwrite($this->_objFile, $str."\n");
	}
	
	if ($this->_dumpType == "table") { fclose($this->_objFile); }
    }
    
    
    /**
     * Methode dfinissant l'en-tte du fichier.
     * @return : string
     */
    private function getHeaders() {
	$strReturn = $this->_sp1." Class dumpMysql\n".$this->_sp1." Version 1.0\n".$this->_sp1."\n";
	$strReturn .= $this->_sp1." Server : ".$_SERVER["SERVER_NAME"]."\n".$this->_sp1." Generated on : ".date("F d Y")." at ".date("H:i")."\n".$this->_sp1."\n";
	$strReturn .= $this->_sp1." DataBase : ".$this->_dbName."\n";
	$strReturn .= $this->_sp1."\n\n".$this->_sp2."\n\n";
	
	return $strReturn;
    }
    
    /*
     * Methode definissant le fichier d'export du dump.
     * @params : path du fichier
     */
    private function setDumpFile($file) {
	if (empty($file)) { $filename = "backup_".$this->_dbName.".sql"; }
	else {
	    /* Vrification du chemin du fichier et de l'extension */
	    if (is_dir(dirname($file))) {
		if (substr($file, (strrpos($file, ".")) + 1, strlen($file) - (strrpos($file, "."))) != "sql") {
		    $file .= ".sql";
		}
		$filename = $file;
	    }
	    else { trigger_error("Le rpertoire n'existe pas.", E_USER_ERROR); }
	}
	$this->_dumpFile = $filename;
    }
    
}
?>