<?php
/**
 * Class_errorsManager.php
 * 
 * Classe de gestion des erreurs.
 */

Class ErrorsManager {
    
    /**
     * Dfinit si les erreurs doivent tre affiches.
     * Type : boolean
     * Valeur par dfaut : true
     */
    private $_showError;
    
    /**
     * Dfinit si les erreurs doivent interrompre l'excution des scripts ou non.
     * Type : boolean
     * Valeur par dfaut : true
     */
    private $_trackError;
    
    /**
     * Fichier log des erreurs.
     * Type : file
     */
    private $_logfile;
    
    
    /**
     * Constructeur de la classe.
     * @return null : initialise les valeurs par dfaut
     */
    public function __construct() {
	$this->_trackError = true;
	$this->_showError = true;
	
	/* Path du fichier log */
	$this->_logfile = "chemin/du/fichier/de/log/class/errors/logs/errors.log";
	
	/* Dsactive le rapport d'erreur */
	error_reporting(0);
	
	/* Dfinition de la fonction utilisateur comme gestionnaire d'erreurs */
	set_error_handler(array($this, 'userErrorHandler'));
    }
    
    /**
     * Mthode affichant le tableau des erreurs.
     * @param (optionnel) : $file est le nom de la page sur laquelle on veut filtrer les erreurs
     * @return string : affichage des erreurs
     */
    public function GetErrors($file) {
	/* Vrification du fichier */
	if (is_file($this->_logfile)) {
	    /* Rcupration et controle du fichier */
	    $arrayFile = file($this->_logfile);
	    if (sizeof($this->_logfile) == 0) { return false; }
	    
	    /* Lecture du fichier */
	    echo "<center>";
	    echo "<font size='2' face='Verdana' color='#CCCCCC'>";
	    echo "<b><u>Liste des erreurs :</u></b><br>";
	    foreach ($arrayFile as $element) {
		$tmpErr = "<br>".str_replace("|", "<br>", $element)."<br>";
		echo $tmpErr;
	    }
	    echo "</font>";
	    echo "</center>";
	}
    }
    
    /**
     * Gestionnaire d'erreurs.
     * @param : numro d'erreur, message d'erreur, fichier gnrant l'erreur, ligne de l'erreur, variables
     */
    public function userErrorHandler($errno, $errmsg, $filename, $linenum, $vars) {
	/* Rcupration de la date du jour : format day/month/year */
	// $dt = date("Y-m-d H:i:s(T)");
	$getdate = getdate();
	$dt = "Error generated on ".str_pad($getdate['mday'], 2, 0, STR_PAD_LEFT)." ".str_pad($getdate['month'], 2, 0, STR_PAD_LEFT)." ".$getdate['year']." at ".$getdate['hours'].":".str_pad($getdate['minutes'], 2, 0, STR_PAD_LEFT).":".str_pad($getdate['seconds'], 2, 0, STR_PAD_LEFT);
	
	/* Dfinir un tableau associatif avec les chaines d'erreur */
	$errortype = array(
	    1 => "Erreur",
	    2 => "Alerte",
	    4 => "Erreur d'analyse",
	    8 => "Note",
	    16 => "Core Error",
	    32 => "Core Warning",
	    64 => "Compile Error",
	    128 => "Compile Warning",
	    256 => "Erreur spcifique",
	    512 => "Alerte spcifique",
	    1024 => "Note spcifique"
	);
	
	/* Niveaux d'erreur enregistrs */
	$user_errors = array(E_USER_ERROR, E_USER_WARNING, E_USER_NOTICE);
	
	/* Variable */
	$err = $dt;
	$err .= "|Error n ".$errno;
	$err .= "|Type : ".$errortype[$errno];
	$err .= "|".$errmsg;
	$err .= "|file ".$filename;
	$err .= "|Calling script ".getenv("SCRIPT_NAME");
	$err .= "|Line ".$linenum;
	$err .= "\r\n";
	
	/* Sauvegarde de l'erreur
	   error_log(string message, int message_type, string destination, string extra_headers)
	   envoie un message d'erreur  l'historique du serveur web.
	   Types : 0 -> message envoy  l'historique php, en fonction de la configuration de error_log
	   	1 -> message est envoy par email  l'adresse destination. Utilise extra_headers
	   	2 -> message envoy par la connexion de dbuggage php
	   	3 -> message ajout au fichier destination
	*/
	error_log($err, 3, $this->_logfile);
	
	/* Affichage de l'erreur : si variable globale est configure  true.
	   Les alertes de type Note sont ignores. */
	if (($this->_showError) && ($errno != 8)) {
	    echo "<center>";
	    echo "<font size='2' face='Verdana' color='#CCCCCC'>";
		/*$tmpErr = "<br>".str_replace("|", "<br>", $err)."<br>";
		echo $tmpErr;*/
		$tmpErr = explode("|", $err);
		echo $tmpErr[3]."<br>";
	    echo "</font>";
	    echo "</center>";
	    
	    /* Interruption du script si la variable est configure  true */
	    if ($this->_trackError) { exit; }
	}
    }

}
?>