<?php
class Browser
{
	private $props = array("Version" => "0.0.0",
						   "Name" => "unknown",
						   "Agent" => "unknown",
						   "OS" => "unknown");

	public function __Construct()
	{
		$browsers = array("firefox", "msie", "opera", "chrome", "safari",
						  "mozilla", "seamonkey", "konqueror", "netscape",
						  "gecko", "navigator", "mosaic", "lynx", "amaya",
						  "omniweb", "avant", "camino", "flock", "aol");

		$this->Agent = strtolower($_SERVER['HTTP_USER_AGENT']);
		foreach($browsers as $browser)
		{
			if(preg_match("#($browser)[/ ]?([0-9.]*)#", $this->Agent, $match))
			{
				switch($match[1])
				{
					case 'msie' :
						$match[1] = 'Internet Explorer';
					break;
					
					default :
						$match[1] = ucfirst($match[1]);
					break;
				}
				$this->Name = $match[1];
				$this->Version = $match[2];
				$this->OS = $this->getOS($this->Agent);
				break;
			}
		}
	}
	
	public function __Get($name)
	{
		if (!array_key_exists($name, $this->props))
		{
			die("No such property or function $name");
		}
		return $this->props[$name];
	}

	public function __Set($name, $val)
	{
		if (!array_key_exists($name, $this->props))
		{
			SimpleError("No such property or function.", "Failed to set $name", $this->props);
			die;
		}
		$this->props[$name] = $val;
	}
	
	public function getOS( $ua = '' )
	{
		if(! $ua ) $ua = $_SERVER['HTTP_USER_AGENT'];
		$os = 'Système d&#39;exploitation non détecté';
	   
		$os_arr = Array(
			// liste des os a detecter. Vous pouvez en ajouter des nouveaux
			'Windows NT 6.2'       => 'Windows 8',
			'Windows NT 6.1'       => 'Windows 7',
			'Windows NT 6.0'       => 'Windows Vista',
			'Windows NT 5.2'       => 'Windows Server 2003',
			'Windows NT 5.1'       => 'Windows XP',
			'Windows NT 5.0'       => 'Windows 2000',
			'Windows NT'           => 'Windows NT',
			'Windows CE'           => 'Windows Mobile',
			'Win 9x 4.90'          => 'Windows Millenium.',
			'Windows 98'           => 'Windows 98',
			'Windows 95'           => 'Windows 95',
			'Win95'                => 'Windows 95',
			'Ubuntu'               => 'Linux Ubuntu',
			'Fedora'               => 'Linux Fedora',
			'Linux'                => 'Linux',
			'Unix'                 => 'Unix',
			'Macintosh'            => 'Mac',
			'Mac OS X'             => 'Mac OS X',
	   );

		$ua = strtolower($ua);
		foreach($os_arr as $k => $v)
		{
			if(strpos($ua, strtolower($k)))
			{
				$os = $v;
				break;
			}
		}
		return $os;
	}
}