<?php
class Employee extends ObjectModel
{	
	public static $xml = _FILE_EMPLOYEE_;
	
	protected $table = 'employee';
	
	public $login;
	
	public $password;
	
	public $name;
	
	public $active = 1;
	
	public $profile = 3;
	
	public $real_profile;
	
	protected $fieldsAttributes = array(
		'active' => 'isBool',
		'profile' => 'isInt');
	
	protected $fieldsRequired = array(
		'login',
		'password',
		'name');
		
 	protected $fieldsValidate = array(
		'login' => 'isGenericName',
		'password' => 'isPasswd',
		'name' => 'isGenericName');
		
	public function __construct($id = NULL, $lang = NULL, $admin = false)
	{
		parent::__construct($id, $lang);
		if($admin)
			$this->real_profile = 1;
		else
			$this->real_profile = $this->profile;
	}
		
	public static function getList()
	{
		$xml = self::getXML();
		return $xml->sortedXPath('//employee', '@id', SORT_ASC);
	}
	
	public static $profiles = array(
		1 => 'Administrateur',
		2 => 'Utilisateur avancé',
		3 => 'Utilisateur');
	
	public static function getByLogin($login, $password = NULL, $admin = false)
	{
		if(!$password)
			return false;
			
		$xml = self::getXML();
		$result = $xml->xpath('//employee[login="'.(string)$login.'" and password="'.(string)$password.'" and @active=1]');
		
		if($result && count($result) == 1)
			return new Employee((int)$result[0]['id'], NULL, $admin);
		return false;
	}
}