<?php
// Rustine php 5.2
if(!function_exists('get_called_class')){
	function get_called_class ()
    {
        foreach ( debug_backtrace() as $trace ) {
            if ( isset( $trace['object'] ) )
                if ( $trace['object'] instanceof $trace['class'] )
                    return get_class( $trace['object'] );
        }

        return false;
    }
}
//***************//

abstract class ObjectModel
{
	/**
	 * List of field types
	 */
	const TYPE_INT = 1;
	const TYPE_BOOL = 2;
	const TYPE_STRING = 3;
	const TYPE_FLOAT = 4;
	const TYPE_DATE = 5;
	const TYPE_HTML = 6;
	const TYPE_NOTHING = 7;

	/**
	 * List of association types
	 */
	const HAS_ONE = 1;
	const HAS_MANY = 2;
	
	/** @var integer Object id */
	public $id;
	
	/** @var string SQL Table name or XML Element name (XML) */
	protected $table = NULL;
	
	/** @var bool if config data */
	protected $config = false;
	
	/** @var array Required fields for admin panel forms */
 	protected $fieldsRequired = array();
	
	/** @var array Required fields Array for admin panel forms */
 	protected $fieldsArray = array();
	
	/** @var array Fields attributes (XML) */
 	protected $fieldsAttributes = array();

 	/** @var array Maximum fields size for admin panel forms */
 	protected $fieldsSize = array();

 	/** @var array Fields validity functions for admin panel forms */
 	protected $fieldsValidate = array();

	/** @var array Multilingual required fields for admin panel forms */
 	protected $fieldsRequiredLang = array();

 	/** @var array Multilingual maximum fields size for admin panel forms */
 	protected $fieldsSizeLang = array();

 	/** @var array Multilingual fields validity functions for admin panel forms */
 	protected $fieldsValidateLang = array();

	/** @var array tables */
 	protected $tables = array();
	
	/**
	 * Build object
	 *
	 * @param integer $id Existing object id in order to load object (optional)
	 * @param integer $lang Required if object is multilingual (optional)
	 */
	public function __construct($id = NULL, $lang = NULL)
	{
		/* Load object from database or xml if object id is present */
		if(!is_null($id) || $this->config)
			if(self::getStaticPropertyValue(get_class($this), 'xml') && ($this->table || $this->config))
			{
				if(!$this->getFieldsWithSimpleDOM($this->config ? true : (int)$id, $lang))
					return false;
				$this->id = $this->config ? true : (int)($id);
			}
	}
	
	public function update()
	{
		if(self::getStaticPropertyValue(get_class($this), 'xml'))
			return $this->updateXML();
	}
	
	public function add()
	{
		if(self::getStaticPropertyValue(get_class($this), 'xml'))
			return $this->addXML();
	}
	
	public function delete()
	{
		if(self::getStaticPropertyValue(get_class($this), 'xml'))
			return $this->deleteXML();
	}
	
	protected static function getXML()
	{
		if (version_compare(PHP_VERSION, '5.3.0') >= 0)
		{
			$classe = get_called_class();
			return new SimpleDOM(self::getStaticPropertyValue($classe,'xml'), NULL, true);
		}
		else
			return new SimpleDOM(self::getStaticPropertyValue(@get_class($this) ? get_class($this) : get_called_class(), 'xml'), NULL, true);
	}
	
	protected static function saveXML($xml)
	{
		if (version_compare(PHP_VERSION, '5.3.0') >= 0)
		{
			$classe = get_called_class();
			return $xml->asXML(self::getStaticPropertyValue($classe,'xml'));
		}
		else
			return $xml->asXML(self::getStaticPropertyValue(@get_class($this) ? get_class($this) : get_called_class(), 'xml'));
	}
	
	
	
	protected function getFieldsWithSimpleDOM($id = false, $lang = false)
	{
		$xml = $this->getXML();
		$fields = !$this->config ? $xml->xpath("//".$this->table."[@id='".$id."']") : $xml;
		
		if(!$fields)
			return false;
		
		$fields = $fields[0];
		
		foreach($this->fieldsAttributes as $key => $value)
			if (isset($key, $this))
			{
				$this->{$key} = (int)stripslashes($fields[$key]);
			}
				
		foreach ($fields AS $key => $value)
				if (isset($key, $this))
				{
					if (get_class($this) == 'Gallery')
						$value = $fields->{$key};
					$this->{$key} = $value;
				}
		
		foreach($this->fieldsArray as $key => $value)
			if (isset($key, $this))
				$this->{$key} = explode(',', $fields->{$key});
				
		if(!$lang)
		{
			global $listLang;
			
			foreach($listLang as $language)
				if(isset($fields->{$language}))
					foreach((array)$fields->{$language} as $key => $value)
						if (isset($key, $this))
						{
							if (!is_array($this->{$key}))
								$this->{$key} = array();
							$this->{$key}[$language] = $value;
						}
		}
		else
		{
			if(!isset($fields->{$lang})) return false;
			foreach((array)$fields->{$lang} as $key => $value)
				if (isset($key, $this))
					$this->{$key} = $value;					
		}
		return true;
	}
	
	protected function updateXML()
	{
		$xml = $this->getXML();
		$object = !$this->config ? $xml->xpath("//".$this->table."[@id='".$this->id."']") : $xml;
		
		if(!$object) return false;
		
		$object = $object[0];
		
		if(!$this->config)
			$object['id'] = $this->id;
		
		foreach($this->getFields() as $key => $value)
		{
			if(array_key_exists($key, $this->fieldsAttributes))
				$object[$key] = (int)stripslashes($this->{$key});
			elseif(array_key_exists($key, $this->fieldsArray))
				$object->{$key} = implode(',', $this->{$key});
			else
				$object->{$key} = stripslashes($this->{$key});
		}
		
		$fields = $this->getTranslationsFieldsChild();
		foreach($fields as $key => $value)
		{
			if(!isset($object->{$key}))
				$object->addChild($key);
			foreach($value as $k => $v)
				$object->{$key}->{$k} = stripslashes($this->{$k}[$key]);
		}
		return $this->saveXML($xml);
	}
	
	protected function addXML()
	{
		$xml = $this->getXML();
		$object = $xml->addChild($this->table);
		
		$this->id = $object['id'] = $this->nextIdXML();
		
		foreach($this->getFields() as $key => $value)
			if(array_key_exists($key, $this->fieldsAttributes))
				$object[$key] = (int)stripslashes($this->{$key});
			elseif(array_key_exists($key, $this->fieldsArray))
				$object->{$key} = implode(',', $this->{$key});
			else
				$object->{$key} = stripslashes($this->{$key});
		
		$fields = $this->getTranslationsFieldsChild();
		foreach($fields as $key => $value)
		{
			if(!isset($object->{$key}))
				$object->addChild($key);
			foreach($value as $k => $v)
				$object->{$key}->{$k} = stripslashes($this->{$k}[$key]);
		}

		return $this->saveXML($xml);
	}
	
	protected function deleteXML()
	{
		$xml = $this->getXML();
		$result = $xml->getElementById((string)$this->id);
		$result->deleteSelf();
		return $this->saveXML($xml);
	}
	
	protected function nextIdXML()
	{
		$xml = $this->getXML();
		$elements = $xml->xpath("//".$this->table);
		if(count($elements) == 0)
			return 1;
		$list_id = array();
		foreach($elements as $element)
			$list_id[] = (int)$element['id'];
		return max($list_id)+1;
	}
	
	/*****************************/
	
	/**
	 * Returns object validation rules (fields validity)
	 *
	 * @param string $className Child class name for static use (optional)
	 * @return array Validation rules (fields validity)
	 */
	static public function getValidationRules($className = __CLASS__)
	{
		$object = new $className();
		return array(
		'attributes' => $object->fieldsAttributes,
		'required' => $object->fieldsRequired,
		'size' => $object->fieldsSize,
		'validate' => $object->fieldsValidate,
		'requiredLang' => $object->fieldsRequiredLang,
		'sizeLang' => $object->fieldsSizeLang,
		'validateLang' => $object->fieldsValidateLang,
		'array' => $object->fieldsArray);
	}
	
	static public function displayFieldName($field, $className = __CLASS__, $htmlentities = true)
	{
		global $_FIELDS;
		@include(_KAM_TRANSLATIONS_DIR_.'/fields.php');

		$key = $className.'_'.md5($field);
		return ((is_array($_FIELDS) AND array_key_exists($key, $_FIELDS)) ? ($htmlentities ? htmlentities($_FIELDS[$key], ENT_QUOTES, 'utf-8') : $_FIELDS[$key]) : $field);
	}
	
	public function validateFields($die = true, $errorReturn = false)
	{
		foreach ($this->fieldsRequired as $field)
			if (Tools::isEmpty($this->{$field}) AND (!is_numeric($this->{$field})))
			{
				if ($die) die (Tools::displayError().' ('.get_class($this).' -> '.$field.' is empty)');
				return $errorReturn ? get_class($this).' -> '.$field.' is empty' : false;
			}
		foreach ($this->fieldsSize as $field => $size)
			if (isset($this->{$field}) AND Tools::strlen($this->{$field}) > $size)
			{
				if ($die) die (Tools::displayError().' ('.get_class($this).' -> '.$field.' length > '.$size.')');
				return $errorReturn ? get_class($this).' -> '.$field.' length > '.$size : false;
			}
		$validate = new Validate();
		foreach ($this->fieldsValidate as $field => $method)
			if (!method_exists($validate, $method))
				die (Tools::displayError('validation function not found').' '.$method);
			elseif (($choc = (string)$this->{$field}) AND !empty($choc) AND !call_user_func(array('Validate', $method), $this->{$field}))
			{
				if ($die) die (Tools::displayError().' ('.get_class($this).' -> '.$field.' = '.$this->{$field}.')');
				return $errorReturn ? get_class($this).' -> '.$field.' = '.$this->{$field} : false;
			}
		foreach ($this->fieldsAttributes as $field => $method)
			if (!method_exists($validate, $method))
				die (Tools::displayError('validation function not found').' '.$method);
			elseif (!empty($this->{$field}) AND !call_user_func(array('Validate', $method), $this->{$field}))
			{
				if ($die) die (Tools::displayError().' ('.get_class($this).' -> '.$field.' = '.$this->{$field}.')');
				return $errorReturn ? get_class($this).' -> '.$field.' = '.$this->{$field} : false;
			}
		return true;
	}
	
	public function validateFieldsLang($die = true, $errorReturn = false)
	{
		$defaultLanguage = _DEFAULT_LANG_;
		foreach ($this->fieldsRequiredLang as $fieldArray)
		{
			if (!is_array($this->{$fieldArray}))
				continue ;
			if (!$this->{$fieldArray} OR !sizeof($this->{$fieldArray}) OR ($this->{$fieldArray}[$defaultLanguage] !== '0' AND empty($this->{$fieldArray}[$defaultLanguage])))
			{
				if ($die) die (Tools::displayError().' ('.get_class($this).'->'.$fieldArray.' '.Tools::displayError('is empty for default language').')');
				return $errorReturn ? get_class($this).'->'.$fieldArray.' '.Tools::displayError('is empty for default language') : false;
			}
		}
		foreach ($this->fieldsSizeLang as $fieldArray => $size)
		{
			if (!is_array($this->{$fieldArray}))
				continue ;
			foreach ($this->{$fieldArray} as $k => $value)
				if (Tools::strlen($value) > $size)
				{
					if ($die) die (Tools::displayError().' ('.get_class($this).'->'.$fieldArray.' '.Tools::displayError('length >').' '.$size.' '.Tools::displayError('for language').')');
					return $errorReturn ? get_class($this).'->'.$fieldArray.' '.Tools::displayError('length >').' '.$size.' '.Tools::displayError('for language') : false;
				}
		}
		$validate = new Validate();
		foreach ($this->fieldsValidateLang as $fieldArray => $method)
		{
			if (!is_array($this->{$fieldArray}))
				continue ;
			foreach ($this->{$fieldArray} as $k => $value)
				if (!method_exists($validate, $method))
					die (Tools::displayError('validation function not found').' '.$method);
				elseif (!empty($value) AND !call_user_func(array('Validate', $method), $value))
				{
					if ($die) die (Tools::displayError('The following field is invalid according to the validate method ').'<b>'.$method.'</b>:<br/> ('.get_class($this).'->'.$fieldArray.' = '.$value.' '.Tools::displayError('for language').' '.$k.')');
					return $errorReturn ? Tools::displayError('The following field is invalid according to the validate method ').'<b>'.$method.'</b>:<br/> ('. get_class($this).'->'.$fieldArray.' = '.$value.' '.Tools::displayError('for language').' '.$k : false;
				}
		}
		return true;
	}
	
	/**
	 * Prepare fields for ObjectModel class (add, update)
	 * All fields are verified (pSQL, intval...)
	 *
	 * @return array All object fields
	 */
	public function getFields()
	{
		$this->validateFields();
		$fields = array();
			
		foreach ($this->fieldsAttributes as $field => $value)
		{
			if (!Validate::isTableOrIdentifier($field))
					die(Tools::displayError());
			$fields[$field] = $value;
		}
		
		foreach ($this->fieldsArray as $field => $value)
		{
			if (!Validate::isTableOrIdentifier($field))
					die(Tools::displayError());
			$fields[$field] = $value;
		}
		
		foreach ($this->fieldsValidate as $field => $value)
		{
			if (!Validate::isTableOrIdentifier($field))
					die(Tools::displayError());
			$fields[$field] = $value;
		}
		return $fields;
	}
	
	/**
	* Check then return multilingual fields for database interaction
	*
	* @return array Multilingual fields
	*/
	public function getTranslationsFieldsChild()
	{
		$this->validateFieldsLang();

		global $listLang;
		
		$fields = array();
		foreach ($listLang as $language)
		{
			foreach ($this->fieldsValidateLang as $field => $value)
			{
				if (!Validate::isTableOrIdentifier($field))
					die(Tools::displayError());

				/* Check fields validity */
				if (isset($this->{$field}[$language]))
					$fields[$language][$field] = $this->{$field}[$language];
			}
		}
		return $fields;
	}
	
	public static function getStaticPropertyValue($class, $property)
	{
		$refl = new ReflectionClass($class);
		return $refl->getStaticPropertyValue($property);
	}
	
	/**
	 * Get object definition
	 *
	 * @param string $class Name of object
	 * @param string $field Name of field if we want the definition of one field only
	 * @return array
	 */
	public static function getDefinition($class, $field = null)
	{
		$reflection = new ReflectionClass($class);
		$definition = $reflection->getStaticPropertyValue('definition');
		$definition['classname'] = $class;
		if (!empty($definition['multilang']))
			$definition['associations'][Collection::LANG_ALIAS] = array(
				'type' => self::HAS_MANY,
				'field' => $definition['primary'],
				'foreign_field' => $definition['primary'],
			);

		if ($field)
			return isset($definition['fields'][$field]) ? $definition['fields'][$field] : null;
		return $definition;
	}
}