<?php
class Stats 
{
	public $browser_name;
	
	public $browser_version;
	
	public $os;
	
	public $nbFiles;
	
	public $fileSize; //Ko
	
	public $sizePercent;

	public function __construct()
	{
		$this->getUserAgent();
		$this->getFilesStats();
	}
	
	public function getFilesStats()
	{
		$this->nbFiles = 0;
		$this->fileSize = 0;
		foreach (glob(_GALLERIES_DIR_."*") as $path)
			if(is_dir($path))
				foreach (glob("".$path."/*") as $filename)
				{
					$this->nbFiles++;
					$this->fileSize += (int)filesize($filename);
				}
		
		$this->fileSize = round(($this->fileSize / 1000),0);
		
		$percent = round((1- (Configuration::get('filesizemax') * 1024 - $this->fileSize) / (Configuration::get('filesizemax') * 1024)) * 100,0);
		$this->sizePercent = ($percent > 100) ? '100' : $percent;
	}
	
	public function getUserAgent()
	{
		$browser = new Browser ;
		
		$this->browser_name = $browser->Name;
		$this->browser_version = $browser->Version;
		$this->os = $browser->OS;
	}
	
}