<?php
class Tree
{
	private static function getXML()
	{
		return new SimpleDOM(_FILE_ARBO_, NULL, true);
	}

	private static function saveXML($xml)
	{
		return $xml->asXML(_FILE_ARBO_);
	}

	public static function getArboHTML($drag = true, $arbo = false, $lang = 'fr')
	{
		$arboHTML = '<ul id="adminArbo" token="root">';
		if(!$arbo)
			$arbo = self::getXML();
		foreach($arbo as $onglet)
		{
			//-----Modifications-----
			$arboHTML .= '<li id="node'.$onglet['id'].'" token="'.$onglet['id'].'"'.(!$drag && $onglet['popup'] == 0 ? ' noDrag="true"' : '').'><a></a><a class="link'.(Tools::isSubmit('id_page') && $onglet['id'] == Tools::getValue('id_page') ? ' selected' : '').'" token="'.$onglet['id'].'" href="index.php?tab=AdminPage&id_page='.$onglet['id'].'">'.(string)$onglet->{$lang}->name_menu.''.($onglet['popup'] == 1 ? ' *' : '').'</a>';
				if($onglet->onglet)
					$arboHTML .= self::getArboHTML($drag, $onglet->onglet, $lang);
			$arboHTML .= '</li>';
		}
		$arboHTML .= '</ul>';
		return $arboHTML;
	}

	public static function getMenu($lang = 'fr', $admin = false)
	{
		return self::recurseMenu($lang, self::getXML(), $admin);
    }

	private static function recurseMenu($lang = 'fr', $element = false, $admin = false)
	{
		$i = 0;
		$arbo = array();
		if($element)
		{
			foreach($element as $onglet)
			{
				if((int)$onglet['menu'] || $admin)
				{
					if($onglet->$lang && ((String)$onglet->$lang->link_rewrite != '') && ($onglet['active'] == 1))
					{
						$arbo[$i]['id'] = (String)$onglet['id'];
						$arbo[$i]['text'] = (String)$onglet->$lang->name_menu;
						$arbo[$i]['title'] = (String)$onglet->$lang->title_menu;
						$arbo[$i]['popup'] = (bool)(int)$onglet['popup'];
						$arbo[$i]['target_blank'] = (bool)(int)$onglet['target_blank'];
						$arbo[$i]['link_rewrite'] = Link::make($onglet['id'], $onglet->$lang->link_rewrite, $lang);
						$arbo[$i]['children'] = $onglet->onglet ? self::recurseMenu($lang, $onglet->onglet, $admin) : array();
						$i++;
					}
				}
			}
		}
		return $arbo;
	}

	public static function getFooter($lang = 'fr')
	{
		$xml = self::getXML();
		$links = $xml->xpath("//onglet[@footer='1']");
		$i = 0;
		$footer = array();

		foreach($links as $link)
		{
			if($link->$lang && ((String)$link->$lang->link_rewrite != '') && ($link['active'] == 1))
			{
				$footer[$i]['popup'] = (bool)(int)$link['popup'];
				$footer[$i]['text'] = $link->$lang->name_footer;
				$footer[$i]['title'] = $link->$lang->title_footer;
				$footer[$i]['link_rewrite'] = Link::make($link['id'], $link->$lang->link_rewrite, $lang);
				$i++;
			}
		}
		return $footer;
    }

	public static function getCopyright($lang = 'fr')
	{
		$xml = self::getXML();
		$links = $xml->xpath("//onglet[@copyright='1']");
		$i = 0;
		$copyright = array();

		foreach($links as $link)
		{
			if($link->$lang && ((String)$link->$lang->link_rewrite != '') && ($link['active'] == 1))
			{
				$copyright[$i]['popup'] = (bool)(int)$link['popup'];
				$copyright[$i]['text'] = $link->$lang->name_copyright;
				$copyright[$i]['title'] = $link->$lang->title_copyright;
				$copyright[$i]['link_rewrite'] = Link::make($link['id'], $link->$lang->link_rewrite, $lang);
				$i++;
			}
		}
		return $copyright;
	}
	
	public static function getList($lang = 'fr')
	{
		$xml = self::getXML();
		$links = $xml->xpath("//onglet");
		$i = 0;
		$list = array();
		foreach($links as $link)
		{
			if($link['id'] != 'root')
			{
				$list[$i]['id'] = $link['id'];
				$list[$i]['text'] = $link->$lang->name_menu;
				$i++;
			}
		}
		return $list;
    }

	public static function update($id)
	{
		global $listLang;

		$xml = self::getXML();
		$page = new Page($id);

		$onglet = $xml->xpath("//onglet[@id='".$id."']");
		$onglet[0]['menu'] = $page->menu;
		$onglet[0]['footer'] = $page->footer;
		$onglet[0]['popup'] = $page->popup;
		$onglet[0]['target_blank'] = $page->target_blank;
		$onglet[0]['copyright'] = $page->copyright;
		$onglet[0]['active'] = $page->active;

		foreach($listLang as $lang)
		{

			if(isset($page->name_menu[$lang]) && isset($page->name_footer[$lang]))
			{
				$update = $onglet[0]->$lang;
				if(!isset($onglet[0]->$lang))
				{
					$update = $onglet[0]->addChild($lang);
					$update->addChild('name_menu');
					$update->addChild('title_menu');
					$update->addChild('name_footer');
					$update->addChild('title_footer');
					$update->addChild('name_copyright');
					$update->addChild('title_copyright');					
					$update->addChild('link_rewrite');
				}

				$update->name_menu = (string)$page->name_menu[$lang];
				$update->title_menu = (string)$page->title_menu[$lang];
				$update->name_footer = (string)$page->name_footer[$lang];
				$update->title_footer = (string)$page->title_footer[$lang];
				$update->name_copyright = (string)$page->name_copyright[$lang];
				$update->title_copyright = (string)$page->title_copyright[$lang];				
				$update->link_rewrite = (string)$page->link_rewrite[$lang];
			}
			else
				unset($onglet[0]->$lang);
		}
		return self::saveXML($xml);
	}

	public static function add($id)
	{
		global $listLang;

		$xml = self::getXML();
		$page = new Page($id);

		$parent = $xml->xpath("//onglet[@id='root']");
		$new_onglet = $parent[0]->addChild('onglet');
		$new_onglet['id'] = $page->id;
		$new_onglet['menu'] = $page->menu;
		$new_onglet['footer'] = $page->footer;
		$new_onglet['popup'] = $page->popup;
		$new_onglet['target_blank'] = $page->target_blank;
		$new_onglet['copyright'] = $page->copyright;
		$new_onglet['active'] = $page->active;

		foreach($listLang as $lang)
		{
			if(isset($page->name_menu[$lang]) && isset($page->name_footer[$lang]))
			{
				$new_onglet_lang = $new_onglet->addChild($lang);
				$new_onglet_lang->addChild('name_menu', $page->name_menu[$lang]);
				$new_onglet_lang->addChild('title_menu', $page->title_menu[$lang]);
				$new_onglet_lang->addChild('name_footer', $page->name_footer[$lang]);
				$new_onglet_lang->addChild('title_footer', $page->title_footer[$lang]);
				$new_onglet_lang->addChild('name_copyright', $page->name_copyright[$lang]);
				$new_onglet_lang->addChild('title_copyright', $page->title_copyright[$lang]);				
				$new_onglet_lang->addChild('link_rewrite', $page->link_rewrite[$lang]);
			}
		}
		return self::saveXML($xml);
	}

	public static function delete($id)
	{
		$xml = self::getXML();
		$result = $xml->getElementById((String)$id);
		$result->deleteSelf();
		return self::saveXML($xml);
	}

	public static function moveOnglet($id, $idNext, $idNewParent)
	{
		$dom = new DOMDocument();
		$dom->load(_FILE_ARBO_);
		$xpath = new DOMXPath($dom);
		$result = $xpath->query("//onglet[@id='".$id."']")->item(0);
		$parent = $xpath->query("//onglet[@id='".$idNewParent."']")->item(0);
		$next = $xpath->query("//onglet[@id='".$idNext."']")->item(0);
		$parent->insertBefore($result, $next);
		Logger::addLog('Modification', 1, NULL, 'Tree', $id);
		$dom->save(_FILE_ARBO_);
	}

	public static function getLink($id, $lang)
	{
		if(Configuration::get('home') == $id)
			return Link::make(Configuration::get('home'), '', $lang);

		$xml = self::getXML();
		$link_rewrite = $xml->xpath("//onglet[@id='".$id."']/".$lang."/link_rewrite");
		$link_rewrite = (string)$link_rewrite[0];
		if($link_rewrite != '')
			return Link::make($id, $link_rewrite, $lang);
		$onglets = $xml->xpath("//onglet/".$lang.'/..');
		foreach($onglets as $onglet)
			return Link::make($onglet['id'], $onglet->{$lang}->link_rewrite, $lang);
		return Link::make(Configuration::get('home'), '', $lang);
	}

	public static function getBreadcrumb($id, $lang)
	{
		if(Configuration::get('home') == $id || !$id)
			return false;

		$breadcrumb = array();
		self::recurseBreadcrumb($id, $lang, $breadcrumb);

		$home = new Page(Configuration::get('home'), $lang);

		$breadcrumb[] =  array(
			'name' => (string)$home->name_menu,
			'link_rewrite' => Link::make(Configuration::get('home'), '', $lang)
		);

		return array_reverse($breadcrumb);
	}

	private static function recurseBreadcrumb($id, $lang, &$breadcrumb)
	{
		$xml = self::getXML();

		$bread = $xml->xpath("//onglet[@id='".$id."']");
		$bread = $bread[0];

		if($bread['id'] != 'root')
		{
			$breadcrumb[] = array(
				'name' => (string)$bread->{$lang}->name_menu,
				'link_rewrite' => Link::make($bread['id'], (string)$bread->{$lang}->link_rewrite, $lang),
			);

			$parent = $xml->xpath("//onglet[@id='".$id."']/..");
			if($parent[0])
				self::recurseBreadcrumb($parent[0]['id'], $lang, $breadcrumb);
		}

		return $breadcrumb;
	}
}
