<?php
//ini_set('display_errors', 'on');

/* Improve PHP configuration to prevent issues */
ini_set('default_charset', 'utf-8');
ini_set('upload_max_filesize', '100M');

/* Correct Apache charset */
header('Content-Type: text/html; charset=utf-8');

define('_VERSION_',		'1.0.1');

/* Autoload */
function kamAutoload($className)
{
	if(!class_exists($className, false) && file_exists(_CLASSES_DIR_.$className.'.php'))
		require_once(_CLASSES_DIR_.$className.'.php');
	else
		smartyAutoload($className); //Si on ne trouve pas la classe demandée, alors c'est peut-être une classe de Smarty.
}

spl_autoload_register('kamAutoload');

include_once(dirname(__FILE__).'/define.php');

/* Functions */
include(_FUNCTION_DIR_.'function.php');

/* Chargement du fichier de configuration du site */
global $listLang, $_MODULES, $_GLOBALS, $_STATS;

Configuration::loadConfiguration();

if(Configuration::get('URI') == '' && !isset($install))
{
	echo 'URI indéfini, veuillez installer';
	exit;
}

$listLang = Configuration::listLang();

/* Pour la traduction des modules */
$_MODULES = array();
$_GLOBALS = array();

define('_DEFAULT_LANG_',		'fr');
define('_DB_PREFIX_',			'');
define('_DB_SERVER_',			Configuration::get('db_server'));
define('_DB_USER_',				Configuration::get('db_user'));
define('_DB_PASSWD_',			Configuration::get('db_passwd'));
define('_DB_NAME_',				Configuration::get('db_name'));
define('_DB_TYPE_',				Configuration::get('db_type'));


/**************/
define('_URI_',					Configuration::get('URI'));
define('_BASE_URI_', 			Tools::getHttpHost(true)._URI_);
define('_KAM_URI_', 			'');

/* Theme */
define('_THEME_DIR_',			_THEMES_DIR_.(Configuration::get('theme') && is_dir(_THEMES_DIR_.Configuration::get('theme').'/') ? Configuration::get('theme') : 'default_1_column').'/');
define('_TRANSLATIONS_DIR_',	_THEME_DIR_.'translations/');

define('_BASE_THEME_',			_BASE_URI_.'themes/'.(Configuration::get('theme') && is_dir(_THEMES_DIR_.Configuration::get('theme').'/') ? Configuration::get('theme') : 'default_1_column').'/');
define('_BASE_URI_IMG_',		_BASE_THEME_.'img/');
/*********/

/* Galleries */
define('_BASE_URI_GALLERIES_',	_BASE_URI_.'content/galleries/');
/*************/

/* QR Code */
define('_BASE_URI_QRCODE_',		_BASE_URI_.'content/qrcode/');
/*************/

define('_BASE_URI_JS_',			_BASE_URI_.'js/');
define('_BASE_URI_MODULES_',	_BASE_URI_.'modules/');
define('_BASE_URI_TOOLS_',		_BASE_URI_.'tools/');
define('_BASE_URI_IMG_LANG_',	_BASE_URI_.'img/lang/');
/**************/

$_STATS = new Stats();

/* It is not safe to rely on the system's timezone settings, and this would generate a PHP Strict Standards notice. */
if (function_exists('date_default_timezone_set'))
	@date_default_timezone_set('Europe/Paris');

/* Smarty */
include(_CONFIG_DIR_.'smarty.config.php');
include(_TOOLS_DIR_.'phpqrcode/qrlib.php');
