<?php
class AdminConfiguration extends AdminTab
{
	public function __construct()
	{
		parent::__construct();

		$this->className = 'Configuration';
	}

	public function postProcess()
	{
		global $kameleon_user, $smarty;


		if($kameleon_user->isAdmin())
		{
			if(Tools::isSubmit('submitAdd'.$this->className))
			{
				$this->ValidateRules();
				if (!sizeof($this->_errors))
				{
					$object = new $this->className();
					if (Validate::isLoadedObject($object))
					{
						$old_theme = $object->theme;
						$this->copyFromPost($object, $this->table);

						if($object->theme != $old_theme)
							$smarty->clearCompiledTemplate();

						if($object->update())
						{
							Logger::addLog('Modification', 1, NULL, $this->className, $object->id);
							Tools::redirectAdmin(self::$currentIndex.'&conf=4');
						}
					}
				}
			}

			if(Tools::isSubmit('htaccess'))
			{
				Tools::generateHtaccess();
				Tools::redirectAdmin(self::$currentIndex.'&conf=4');
			}

			if(Tools::isSubmit('sitemap'))
			{
				Tools::generateSitemap();
				Tools::redirectAdmin(self::$currentIndex.'&conf=4');
			}

			if(Tools::isSubmit('robots'))
			{
				Tools::generateRobots();
				Tools::redirectAdmin(self::$currentIndex.'&conf=4');
			}

			if(Tools::isSubmit('saveTranslation'))
			{
				$this->saveTranslation();
				Tools::redirectAdmin(self::$currentIndex.'&translations&conf=4');
			}

			if(Tools::isSubmit('clearCompiledTemplate'))
			{
				$smarty->clearCompiledTemplate();
				Tools::redirectAdmin(self::$currentIndex.'&conf=1');
			}

			if(Tools::isSubmit('linkxml'))
			{
				$old_site = Tools::getValue('old_site');
				$new_site = Tools::getValue('new_site');
				if ($old_site != '' || $new_site != '') {
					$old = 'http://'.$old_site.'/';
					$new = 'http://'.$new_site.'/';

					if (Tools::regenerateLinkXML($old, $new))
						Tools::redirectAdmin(self::$currentIndex.'&conf=4');
					else
						$this->_errors[] = 'L\'ancien nom de domaine '.$old_site.' n\'a pas été trouvé';
				}
				else
					$this->_errors[] = 'Veuillez indiquer un nom de domaine';

			}
		}
	}

	public function display()
	{
		global $kameleon_user, $listLang;

		if($kameleon_user->isAdmin())
		{
			if(Tools::isSubmit('translations'))
				echo $this->displayTranslations();
			else
				echo $this->displayConfiguration();
		}
	}

	public function displayConfiguration()
	{
		$configuration = $this->loadObject(true);

			$txt = '
			<script type="text/javascript">
				$(function(){
					var token = false;
					$("#linkxml").on("click", function(){
						token = !token;
						if (token)';
			$txt	.=			'$("#linkxml").parent().append("';
			$txt	.=				'<div id=\"thediv\"><br/><br/><form method=\"post\" action=\"'.self::$currentIndex.'&linkxml\">';
			$txt	.=					'<label class=\"label\"> Ancien nom de domaine </label>  <div class=\"margin-form\"><input type=\"text\" name=\"old_site\" placeholder=\"exemple: www.ancien_site.com\"/></div>';
			$txt	.=					'<label class=\"label\"> Nouveau nom de domaine </label> <div class=\"margin-form\"><input type=\"text\" name=\"new_site\" placeholder=\"exemple: www.ancien_site.com\"/></div>';
			$txt	.= 					'<div class=\"margin-form\"><button type=\"submit\" class=\"button\">OK</button></div>';
			$txt	.=				'</form></div>");
						else
							$("#thediv").remove();
					});
				})
			</script>';
			/*<legend class="legend">Configuration du site</legend>*/
			$txt .= '<div class="margin-form conf1">
				<a href="'.self::$currentIndex.'&htaccess" name="htacc" class="button grey"><img src="img/compasswhite.png" style="margin-right:7px"/>Régénérer le fichier .htaccess</a>
			</div>
			<div class="margin-form conf1">
				<a href="'.self::$currentIndex.'&sitemap" class="button grey"><img src="img/mapwhite.png" style="margin-right:7px"/>Régénérer le fichier sitemap.xml</a>
			</div>
			<div class="margin-form conf1">
				<a href="'.self::$currentIndex.'&robots" class="button grey"><img src="img/robotwhite.png" style="margin-right:7px"/>Régénérer le fichier robots.txt</a>
			</div>
			<div class="margin-form conf1">
				<a href="'.self::$currentIndex.'&translations" class="button grey"><img src="img/commentwhite.png" style="margin-right:7px"/>Gestion des traductions</a>
			</div>
			<div class="margin-form conf1 last">
				<a class="button grey" id="linkxml"><img src="img/mousewhite.png" style="margin-right:7px"/>Changement de domaine</a>
			</div>
			<div class="clear"></div>
			<form method="post" action="'.self::$currentIndex.'">';

			$txt .= '
			<hr />
			<h2>Général</h2>
			<label class="label" for="website_name">Nom du site :</label>
			<div class="margin-form"><input type="text" id="website_name" required name="website_name" value="'.$this->getFieldValue($configuration, 'website_name').'" /></div>'; // onchange="this.value=this.value.toLowerCase();" onmouseup="this.value=this.value.toLowerCase();" onkeyup="this.value=this.value.toLowerCase();"

			$txt .= '<label class="label" for="home">Page d\'accueil :</label>
			<div class="margin-form"><select name="home" id="home">';
			foreach(Tree::getMenu('fr', true) as $onglet)
				$txt .= '<option value="'.$onglet['id'].'"'.($this->getFieldValue($configuration, 'home') == $onglet['id'] ? 'selected="selected"' : '').'>'.$onglet['text'].'</option>';
			$txt .= '</select></div>';

			$txt .= '<label class="label">Langue(s) du site :</label>
			<div class="margin-form"><ul>';
			$listFlag = Configuration::getListFlag();
			foreach($listFlag as $flag)
				$txt .= '<li><label><input type="checkbox" name="list_lang[]" value="'.$flag['name'].'" '.(in_array($flag['name'] , $this->getFieldValue($configuration, 'list_lang')) ? 'checked="checked"' : '' ).' />&nbsp;<img src="'.$flag['path'].'" /></label></li>';
			$txt .= '</ul></div>';

			$txt .= '<br/><label class="label">Type de contrat :</label>
			<div class="margin-form">
				
				<input type="radio" name="contrat" id="contrat_incomm" value="0" '.($this->getFieldValue($configuration, 'contrat') == 0 ? 'checked="checked"' : '').' style="vertical-align:top"/>
				<label class="t contrat" for="contrat_incomm"><img src="img/synk.png" /></label>
			</div>';

			$txt .= '<hr />
			<h2>Paramètres SMTP</h2>

			<label class="label" for="smtp_host">Serveur SMTP :</label>
			<div class="margin-form"><input type="text" id="smtp_host" name="smtp_host" value="'.$this->getFieldValue($configuration, 'smtp_host').'"/></div>
			<label class="label" for="smtp_user">Utilisateur :</label>
			<div class="margin-form"><input type="text" id="smtp_user" name="smtp_user" value="'.$this->getFieldValue($configuration, 'smtp_user').'"/></div>
			<label class="label" for="smtp_passwd">Mot de passe :</label>
			<div class="margin-form"><input type="text" id="smtp_passwd" name="smtp_passwd" value="'.$this->getFieldValue($configuration, 'smtp_passwd').'"/></div>
			<label class="label" for="mail">Mail Principal :</label>
			<div class="margin-form"><input type="text" id="mail" name="mail" style="width:200px" required value="'.$this->getFieldValue($configuration, 'mail').'"/></div>
			<label class="label" for="smtp_port">Port :</label>
			<div class="margin-form"><input type="text" id="smtp_port" name="smtp_port" value="'.$this->getFieldValue($configuration, 'smtp_port').'"/></div>
			<label class="label" for="mail2">Mail secondaire :</label>
			<div class="margin-form"><input type="text" id="mail2" name="mail2" style="width:200px" value="'.$this->getFieldValue($configuration, 'mail2').'"/></div>
			';

			$txt .= '<hr />
			<h2>Métas Robots</h2>';

			$meta_robots = 'noindex, nofollow';

			$txt .= '
				<label class="label" for="meta_robots">Meta robots :</label>
				<div class="margin-form">
				<select name="meta_robots" id="meta_robots" onchange="submit();">
					<option value="">...</option>
					<option value="noindex,nofollow"'.($meta_robots == 'noindex,nofollow' ? ' selected="selected"' : '').'>noindex,nofollow</option>
					<option value="noindex,follow"'.($meta_robots == 'noindex,follow' ? ' selected="selected"' : '').'>noindex,follow</option>
					<option value="index,follow"'.($meta_robots == 'index,follow' ? ' selected="selected"' : '').'>index,follow</option>
					<option value="index,nofollow"'.($meta_robots == 'index,nofollow' ? ' selected="selected"' : '').'>index,nofollow</option>
					<option value=""'.($meta_robots == '' ? ' selected="selected"' : '').'>Désactivé (n\'affiche pas la balise)</option>
				</select>
				</div>';

			$txt .= '
				<div class="margin-form">
					<table class="table tableDnD" style="width:350px">
						<tr class="nodrag nodrop">
							<th>Pages</th>
							<th>Métas Robots</th>
						</tr>';
				$irow = 0;
				$pages = new SimpleDOM(_FILE_ARBO_, NULL, true);
				$lang = 'fr';
				foreach($pages as $p)
				{
					self::majAllMeta($p);
					$page = new Page($p['id']);
					$txt .= '
					<tr'.($irow++ % 2 ? ' class="alt_row"' : '').'>
						<td><label class="t">'.(string)$p->$lang->name_menu.'</label></td>
						<td><label class="t" style="color:grey">'.($this->getFieldValue($page, 'meta_robots', $lang) == "" ? "Désactivé" : $this->getFieldValue($page, 'meta_robots', $lang)).'</label></td>
					</tr>';
				}
			$txt .= '</table></div><br/>';

			$txt .= '<hr />
			<h2>Base de données</h2>';

			$txt .= '
			<label class="label" for="db_server">DB Server :</label>
			<div class="margin-form"><input type="text" id="db_server" name="db_server" value="'.$this->getFieldValue($configuration, 'db_server').'" /></div>';

			$txt .= '<label class="label" for="db_user">DB User :</label>
			<div class="margin-form"><input type="text" id="db_user" name="db_user" value="'.$this->getFieldValue($configuration, 'db_user').'" /></div>';

			$txt .= '<label class="label" for="db_passwd">DB Password :</label>
			<div class="margin-form"><input type="text" id="db_passwd" name="db_passwd" value="'.$this->getFieldValue($configuration, 'db_passwd').'" /></div>';

			$txt .= '<label class="label" for="db_name">DB Name :</label>
			<div class="margin-form"><input type="text" id="db_name" name="db_name" value="'.$this->getFieldValue($configuration, 'db_name').'" /></div>';

			$txt .= '<label class="label" for="db_type">DB Type :</label>
			<div class="margin-form"><input type="text" id="db_type" name="db_type" value="'.$this->getFieldValue($configuration, 'db_type').'" /></div>';

			$txt .= '<hr />
			<h2>&Eacute;dition du Htaccess</h2>';

			$txt .= '<label class="label" for="customHtaccess"></label>
			<div class="margin-form"><textarea type="text" id="customHtaccess" name="customHtaccess">'.$this->getFieldValue($configuration, 'customHtaccess').'</textarea><br/><img src="img/danger.png" alt="" /> Ne pas oublier de <a href="#htacc">régénérer le htaccess</a> une fois la configuration enregistrée !
			</div>';;

			$txt .= '<hr />
			<h2>Smarty</h2>';

			$txt .= '<label class="label">Forcer la compilation :</label>
			<div class="margin-form">
				<input type="radio" name="smarty_compil" id="smarty_compil_on" value="0" '.($this->getFieldValue($configuration, 'smarty_compil') == 0 ? 'checked="checked"' : '').' />
				<label class="t" for="smarty_compil_on"><img src="img/enabled.gif" alt="Activé" title="Activé"></label>
				<input type="radio" name="smarty_compil" id="smarty_compil_off" value="1" '.($this->getFieldValue($configuration, 'smarty_compil') == 1 ? 'checked="checked"' : '').' />
				<label class="t" for="smarty_compil_off"><img src="img/disabled.gif" alt="Désactivé" title="Désactivé"></label>
			</div>';

			// $txt .= '<div class="margin-form"><a href="'.self::$currentIndex.'&clearCompiledTemplate" class="button grey"><img src="img/closewhite.png" style="margin-right:7px"/>Supprimer les fichiers de compilation</a></div>';

			$txt .= '<hr />
			<h2>Avancés</h2>';

			$txt .= '<label class="label" for="URI">Dossier racine du site :</label>
			<div class="margin-form"><input type="text" id="URI" name="URI" value="'.$this->getFieldValue($configuration, 'URI').'" />
			<img src="img/danger.png" alt="" /> Ne modifier qu\'en cas de déplacement du site !</div>';

			$txt .= '<label class="label" for="editor_width">Largeur de l\'éditeur de texte :</label>
			<div class="margin-form"><input type="text" id="editor_width" required name="editor_width" value="'.$this->getFieldValue($configuration, 'editor_width').'" /> px</div>';

			$txt .= '<div class="margin-form" style="display:none!important;"><select name="theme" id="theme">';
			foreach(Configuration::getThemeList() as $theme)
				$txt .= '<option value="'.$theme['name'].'"'.($this->getFieldValue($configuration, 'theme') == $theme['name'] ? 'selected="selected"' : '').'>'.$theme['name'].'</option>';
			$txt .= '</select></div>';

			$leftModule = Module::getHookListModule("LEFT_COLUMN");
			$rightModule = Module::getHookListModule("RIGHT_COLUMN");
			$txt .= '<label class="label" for="theme">Thème :</label>
						<div class="margin-form">
							<table style="font-size:11px">
							<tr>
								<td>Colonne gauche</td>
								<td>
									<input type="radio" name="columnLeft" id="columnLeft_on" value="1" '.($this->getFieldValue($configuration, 'columnLeft') == 1 ? 'checked="checked"' : '').' />
									<label class="t" for="columnLeft_on"><img src="img/enabled.gif" alt="Activé" title="Activé"></label>
									<input type="radio" name="columnLeft" id="columnLeft_off" value="0" '.($this->getFieldValue($configuration, 'columnLeft') == 0 ? 'checked="checked"' : '').' />
									<label class="t" for="columnLeft_off"><img src="img/disabled.gif" alt="Désactivé" title="Désactivé"></label>
								</td>
								<td>'.( !empty($leftModule) ? '(Module(s) : ' : '(aucun module');
									foreach ($leftModule as $module) {
										$txt .= ''.$module->name.' - ';
									}
								$txt .= ')</td>
							</tr>
							<tr>
								<td>Colonne droite</td>
								<td>
									<input type="radio" name="columnRight" id="columnRight_on" value="1" '.($this->getFieldValue($configuration, 'columnRight') == 1 ? 'checked="checked"' : '').' />
									<label class="t" for="columnRight_on"><img src="img/enabled.gif" alt="Activé" title="Activé"></label>
									<input type="radio" name="columnRight" id="columnRight_off" value="0" '.($this->getFieldValue($configuration, 'columnRight') == 0 ? 'checked="checked"' : '').' />
									<label class="t" for="columnRight_off"><img src="img/disabled.gif" alt="Désactivé" title="Désactivé"></label>
								</td>
								<td>'.( !empty($rightModule) ? '(Module(s) : ' : '(aucun module');
									foreach ($rightModule as $module) {
										$txt .= ''.$module->name.' - ';
									}
								$txt .= ')</td>
							</tr>
							</table>
						</div>';

			$txt .= '<label class="label" for="filesizemax">Capacité maximale disponible :</label>
			<div class="margin-form"><input type="text" class="small" id="filesizemax" name="filesizemax" value="'.$this->getFieldValue($configuration, 'filesizemax').'" /> MégaOctet(s)</div>';

			$txt .= '<label class="label" for="uploadimgsizemax">Taille maximale des images :</label>
			<div class="margin-form"><input type="text" class="small" id="uploadimgsizemax" name="uploadimgsizemax" value="'.$this->getFieldValue($configuration, 'uploadimgsizemax').'" /> MégaOctet(s)</div>';

			$txt .= '<label class="label" for="uploaddocsizemax">Taille maximale des documents :</label>
			<div class="margin-form"><input type="text" class="small" id="uploaddocsizemax" name="uploaddocsizemax" value="'.$this->getFieldValue($configuration, 'uploaddocsizemax').'" /> MégaOctet(s)</div>';


			$labelsAdvanced = array(
				'redimAuto'	=>	'Redimensionnement automatique des images',
				'maintenance_FO'	=>	'Mettre le site en maintenance',
				'maintenance_BO'	=>	'Mettre l\'admin en maintenance',
			);
			$txt .= $this->addDevConfig(array(
				'redimAuto'	=>	$this->getFieldValue($configuration, 'redimAuto'),
				'maintenance_FO'	=>	$this->getFieldValue($configuration, 'maintenance_FO'),
				'maintenance_BO'	=>	$this->getFieldValue($configuration, 'maintenance_BO'),
			),'',$labelsAdvanced);


			$txt .=	'<br><h2>Utilisation des frameworks </h2>';
			foreach (Configuration::$assets as $asset) {
				$assets[$asset] = (int)$this->getFieldValue($configuration, 'dev_'.$asset);
			}
			$txt .= $this->addDevConfig($assets,'dev_');

			return $txt.'<div class="margin-form"><p>&nbsp;</p></div><div class="margin-form"><button type="submit" name="submitAddConfiguration" class="button save big">Enregistrer</button></div></form>';
	}

	protected function copyFromPost(&$object, $table)
	{
		parent::copyFromPost($object, $table);

		if(!Tools::isSubmit('list_lang'))
			$object->list_lang = array();
	}

	private function displayTranslations()
	{
		global $listLang;

		$listTranslation = $this->findTranslation();

		$txt = '<legend class="legend">Traductions</legend>';

		if($listTranslation)
		{
			$txt .= '<p>Note : la modification se fait langue par langue, on ne peut pas modifier plusieurs langues en même temps</p>';

			foreach($listLang as $lang)
			{
				if($lang != 'fr')
				{
					$txt .= '
					<fieldset class="fieldset">
						<legend class="legend"><img class="flag" src="img/lang/'.$lang.'.gif" /></legend>
					<form method="post" action="'.self::$currentIndex.'&saveTranslation">
					<input type="hidden" name="lang" value="'.$lang.'" />';
					foreach($listTranslation as $tplName => $translations)
					{
						$txt .= '<table id="listTranslation">';
						foreach($translations as $translation)
						{
							$md5 = md5(str_replace('\'', '\\\'', $translation));
							$txt .= '<tr>
							<td class="tdLeft"><label for="'.$md5.'_'.$lang.'">'.$translation.'</label></td>';
							$txt .= '<td class="tdCenter">=</td>';
							$txt .='<td class="tdRight"><input type="text" class="large" name="'.$tplName.'['.$md5.']" id="'.$md5.'_'.$lang.'" value="'.$this->l($translation, $tplName, $lang).'" /></td></tr>';
						}
						$txt .= '<tr></table>';
					}
					$txt .= '<div class="margin-form"><button class="button" type="submit">Enregistrer</button></div></form></fieldset>';
				}
				global $_GLOBALS;
				$_GLOBALS = array();
			}
		}

		return $txt;
	}

	public function findTranslation()
	{
		$dirTheme = _THEME_DIR_;

		$tplRegex = '/\{l s="(.*[^\\\\])"\}/U';

		$handle = opendir($dirTheme);
		$tabTranslatation = array();
		while($file = readdir($handle))
		{
			if(substr($file, -4) == '.tpl')
			{
				$dirFile = $dirTheme.$file;
				$handfleFile = fopen($dirFile, "r");
				$matches = array();

				$regex = $tplRegex;

				preg_match_all($regex, fread($handfleFile, filesize($dirFile)), $matches);
				fclose($handfleFile);
				foreach ($matches[1] as $key)
					$tabTranslatation[substr($file, 0, -4)][] = $key;
				if(isset($tabTranslatation[substr($file, 0, -4)]))
					array_unique($tabTranslatation[substr($file, 0, -4)]);
			}
		}
		closedir($handle);
		return $tabTranslatation;
	}

	public function saveTranslation()
	{
		$handleLang = fopen(_TRANSLATIONS_DIR_.Tools::getvalue('lang').'.php', 'w');
		$output = "<?php\nglobal \$_GLOBAL;\n\$_GLOBAL = array();\n";

		$dirTheme = _THEME_DIR_;
		$handle = opendir($dirTheme);
		$tabTranslatation = array();
		while($file = readdir($handle))
		{
			if(substr($file, -4) == '.tpl')
			{
				$tplName = substr($file, 0, -4);
				if(Tools::isSubmit($tplName))
					foreach(Tools::getvalue($tplName) as $k => $v)
						if(Validate::isMd5($k))
							$output .= '$_GLOBAL[\''.$tplName.'_'.$k.'\'] = \''.addslashes($v).'\';'."\n";
			}
		}
		closedir($handle);
		fwrite($handleLang, $output);
		fclose($handleLang);
	}

	public function l($string, $tplName, $lang)
	{
		global $_GLOBALS, $_GLOBAL;

		$file = _TRANSLATIONS_DIR_.$lang.'.php';
		if(Tools::file_exists_cache($file) AND include_once($file))
			$_GLOBALS = !empty($_GLOBALS) ? array_merge($_GLOBALS, $_GLOBAL) : $_GLOBAL;
		else
			return(str_replace('"', '&quot;', $string));
		if(!is_array($_GLOBALS))
			return(str_replace('"', '&quot;', $string));

		$string2 = str_replace('\'', '\\\'', $string);
		$currentKey = $tplName.'_'.md5($string2);

		if(key_exists($currentKey, $_GLOBALS))
			$ret = stripslashes($_GLOBALS[$currentKey]);
		else
			$ret = $string;
		return str_replace('"', '&quot;', $ret);
	}

	private function majAllMeta($p) {
		if ($p->onglet) {
			foreach ($p->onglet as $onglet) {
				self::majAllMeta($onglet);
			}
		}
		$lang = 'fr';
		$page = new Page($p['id']);
		if(Tools::isSubmit('meta_robots'))
			$page->meta_robots[$lang] = Tools::getvalue('meta_robots');
		$page->update();

	}

	private function addDevConfig($array,$prefix = '',$labelArray = array()){

		$txt = '';

		foreach ($array as $label => $value) {

			if (array_key_exists($label,$labelArray)) {
				$realLabel = $labelArray[$label];
			}else {
				$realLabel = 'Utilisation de '.ucfirst($label);
			}

			$txt .= '<label class="label">'.$realLabel.' :</label>
			<div class="margin-form">
				<input type="radio" name="'.$prefix.$label.'" id="'.$label.'_on" value="1" '.($value == 1 ? 'checked="checked"' : '').' />
				<label class="t" for="'.$label.'_on"><img src="img/enabled.gif" alt="Activé" title="Activé"></label>
				<input type="radio" name="'.$prefix.$label.'" id="'.$label.'_off" value="0" '.($value == 0 ? 'checked="checked"' : '').' />
				<label class="t" for="'.$label.'_off"><img src="img/disabled.gif" alt="Désactivé" title="Désactivé"></label>
			</div>';
		}

		return $txt;

	}


}
