<?php
class Footer extends Module
{
	public function __construct()
	{
		$this->name = 'footer';
		$this->version = 1.1;
		$this->hook = 'FOOTER';
		$this->category = 'Navigation';
		$this->visible = false;
		$this->module = false;
		$this->error = false;
		$this->valid = false;
		parent::__construct();
		$this->displayName = 'Liens du bas de page';
		$this->description = 'Affiche les liens en bas de la page';
		$this->picto = 'picto.png';
	}

	public function install()
	{
		if(parent::install())
			return Configuration::updateValue('footer_li', 5);
	}

	public function uninstall()
	{
		if(parent::uninstall())
			return Configuration::deleteByName('footer_li');
	}

	public function getContent()
	{
		if(Tools::isSubmit('submitFooter'))
			Configuration::updateValue('footer_li', Tools::getValue('footer_li'));

		$txt = '<form id="formFooter" method="post" action="'.self::$currentIndex.'">';

		$txt .= '<label class="label" for="footer_li">Nombre de lignes par listes : </label>
		<div class="margin-form"><input type="text" name="footer_li" id="footer_li" value="'.Configuration::get('footer_li').'" /></div>';

		echo $txt .= '<div class="margin-form"><button type="submit" class="button" name="submitFooter">Enregistrer</button></div></form>';
	}

	public function display_FOOTER()
	{
		global $smarty, $cookie;

		Module::$CSS[] = $this->_path.'footer.css';

		$smarty->assign(array(
			'footer' => Tree::getFooter($cookie->lang),
			'copyright' => Tree::getCopyright($cookie->lang),
			'footer_li' => Configuration::get('footer_li')));
 	 	return $this->display(__FILE__, 'footer.tpl');
	}
	
}
