<?php
require_once(dirname(__FILE__).'/Article.php');
require_once(dirname(__FILE__).'/User_Ad.php');
require_once(_MODULES_DIR_.'privateaccess/privateaccess.php');

class AdminArticle extends AdminTab
{
	public function __construct()
	{
		parent::__construct();
		
		if(Tools::isSubmit('addArticle') || Tools::isSubmit('id_article'))
		{
			$this->className = 'Article';
			$this->table = 'article';
		}
		elseif(Tools::isSubmit('addUser_Ad') || Tools::isSubmit('id_user_ad'))
		{
			$this->className = 'User_Ad';
			$this->table = 'user_ad';
		}
	}
	
	public function postProcess()
	{
		if(Tools::isSubmit('article') && Tools::isSubmit('active'))
		{
			$article = new Article(Tools::getValue('article'));
			if(Validate::isLoadedObject($article))
			{
				$article->active = Tools::getValue('active');
				if($article->update())
				{
					$nbCurrentPage = (Tools::isSubmit('page') && Tools::isSubmit('page') > 0 ? Tools::getValue('page') : 1);
					Tools::redirectAdmin(self::$currentIndex.'&page='.$nbCurrentPage.'&conf=4');
				}
			}
		}


		if(Tools::isSubmit('user') && Tools::isSubmit('statut'))
		{
			$user = new User_Ad(Tools::getValue('user'));
			if(Validate::isLoadedObject($user))
			{
				$user->statut = Tools::getValue('statut');
				if($user->update())
				{
					$this->instanceModule = new PrivateAccess();
					$this->instanceModule->updateTypeUserStatut(Tools::getValue('user'),Tools::getValue('statut'));				
				
					$nbCurrentPage = (Tools::isSubmit('page') && Tools::isSubmit('page') > 0 ? Tools::getValue('page') : 1);
					Tools::redirectAdmin(self::$currentIndex.'&page='.$nbCurrentPage.'&conf=4');
				}
			}
		}
		
		if(Tools::isSubmit('cover'))
		{
			$image = new Image((int)Tools::getValue('cover'));
			if(Validate::isLoadedObject($image) && !$image->cover)
				$image->setCover();
		}
		
		if(Tools::isSubmit('imgs'))
		{
			$imgs = (Tools::getValue('imgs'));
			Image::changePosition($imgs);
		}
		
		if(Tools::isSubmit('regenerateImages'))
		{
			ini_set('max_execution_time', 0);
			
			$images = Image::getList();
			foreach($images as $image)
			{
				$image->getFullInfos();
				$image->generateImages();				
			}
			
			global $listLang;
			
			foreach($listLang as $lang)
			{
				$path_lang = dirname(__FILE__).'/images/'.$lang;
				ImageManager::resize($path_lang.'.jpg', $path_lang.'-min.jpg', 80, 60);
				ImageManager::resize($path_lang.'.jpg', $path_lang.'-thumb.jpg', 64, 48);
			}
			
			Tools::redirectAdmin(self::$currentIndex.'&conf=4');
		}
		
		if(Tools::isSubmit('deleteAllArticle'))
		{
				foreach($articlesDel = Article::getArticles() as $articledel)
				{					
					$articledel->delete();					
				}
					Db::getInstance()->ExecuteS('TRUNCATE TABLE article');
					Db::getInstance()->ExecuteS('TRUNCATE TABLE image');
				
				Tools::redirectAdmin(self::$currentIndex.'&conf=1');
				
			}


		/////////////////////////////////////////// Gestion accès restreint
		
			if(Tools::isSubmit('id_user_ad'))
			{
				$this->instanceModule = new PrivateAccess();
				
				if(Tools::isSubmit('login_fr') && Tools::isSubmit('password_fr'))
					{
						$login = Tools::getValue('login_fr');
						$password = Tools::getValue('password_fr');
						$name = Tools::getValue('name_fr');
						$statut = Tools::getValue('statut');
						$type = Tools::getValue('type_fr');

						if($this->instanceModule->getUser(Tools::getValue('id_user_ad')))
						{
							$this->instanceModule->updateTypeUser(Tools::getValue('id_user_ad'), $login, $password, $name, $statut, $type);
						}
						else
						{
							$this->instanceModule->addTypeUser(Tools::getValue('id_user_ad'), $login, $password, $name, $statut, $type);
						}

					}
				if(Tools::isSubmit('deleteUser_Ad'))
					{
						$this->instanceModule->deleteUser(Tools::getValue('id_user_ad'));
					}
			
				}
		
		
		if(Tools::isSubmit('submitAddUser_Ad'))
		{
			$name = Tools::getValue('name_fr');
			$statut = Tools::getValue('statut');
			$login = Tools::getValue('login_fr');
			$password = Tools::getValue('password_fr');
			$type = Tools::getValue('type_fr');

			$user = new User_Ad(Tools::getValue('user'));

			$user->statut = (int)$statut;
			$user->name = array('fr' => $name);
			$user->login = array('fr' => $login);
			$user->password = array('fr' => $password);
			$user->type = array('fr' => $type);

			if(Tools::isSubmit('id_user_ad'))
				$user->update();
			else
				if($user->save())
					Tools::redirectAdmin(self::$currentIndex.'&conf=3');
				else
					echo('Enregistrement bdd echoué');

		}
				
		
		////////////////////////////////////////		
		
		parent::postProcess();
	}
	
	public function display()
	{
		if(Tools::isSubmit('addArticle') || Tools::isSubmit('id_article'))
			echo $this->displayFormArticle();
		elseif(Tools::isSubmit('addUser_Ad') || Tools::isSubmit('id_user_ad'))
			echo $this->displayFormUserAd();
		else
			echo $this->displayList();
	}
	
	public function displayAjaxAddImage()
	{
		$article = new Article((int)Tools::getValue('article'));
		echo $article->addImage();
	}
	
	public function displayAjaxDeleteImage()
	{
		$image = new Image((int)Tools::getValue('img'));
		echo $image->delete();
	}
	
	public function displayAjaxSortListArticle()
	{
		
		$orders = Tools::getValue('ordres');
		
		$orders = explode('tbliste[]=,', Tools::getValue('ordres'));
		
		$orders = explode(',', $orders[2]);
		
		$array = array();
		foreach($orders as $item) 
		{
			$item = explode('=', $item);
			array_filter($item);
			$item = explode('_', $item[1]);
			$array[] = $item[1];
		}
				
		Article::changePositionListArticle($array);		
	}

	private function displayList()
	{		
		$txt = '<script type="text/javascript">
		
	 $(document).ready(function(){
			 $("#tbliste").tableDnD({
					onDrop: function() {
					var ordres = $.tableDnD.serialize();
					ordres = ordres.split("&");
											
					var settings = {
	 					type : "POST",
						url : "'.self::$currentIndex.'",
						data : "ajax=1&action=SortListArticle&ordres="+ordres,
						complete : function(xhr, status){
						}
						}
					$.ajax(settings);
					}
				});
		
				
	
		
			$(".confirmDelAll").on(\'click\', function(){
						$("#dialog-confirm").html("<p>Êtes-vous sur de vouloir supprimer tous les articles ?</p>");
						$("#dialog-confirm").dialog({
							resizable: false,
							height: 150,
							modal: true,
							title: "Supprimer tous les articles",
							buttons: {
								Oui: function(){
									location.href = \''.self::$currentIndex.'&deleteAllArticle\';
								},
								Non: function(){
									$("#dialog-confirm").dialog("close");
								}
								
							
							}
						});	
					});	
					});	
		</script>';
		
		
		
		$txt .= '
		<div class="margin-form"><a href="'.self::$currentIndex.'&regenerateImages" class="button">Regénérer les images des articles</a></div>
		<h2>Annonces</h2>
		<a style="vertical-align:bottom" href="'.self::$currentIndex.'&addArticle"><img src="img/add.gif" border="0"> Ajouter</a><br /><br />';
		
		$nb = 30;
		$nbCurrentPage = (Tools::isSubmit('page') && Tools::isSubmit('page') > 0 ? Tools::getValue('page') : 1);
		$min = ($nbCurrentPage - 1) * $nb;
		
		$allArticles = Article::getArticles();
		$articles = Article::getArticles();
		
		$where = array();
		
		
		foreach($where as $query)
		{
			$allArticles->where($query);
			$articles->where($query);
		}
		
		$total = count($allArticles);
		$nbPages = ceil($total / $nb);
		
		$results = '<p style="margin:20px 0 0 10px; font-size:12px; font-style:italic; font-weight:bold; color:green;">'.$total.' Résultats</p>';
		
		$pagination = '<ul class="pagination">';
		if($nbPages > 1)
		{
			if($nbCurrentPage > 1)
				$pagination .= '<li><a href="'.self::$currentIndex.'&page='.($nbCurrentPage-1).'" class="arrow"><</a></li>';
			for($i = 1; $i <= $nbPages; $i++)
				$pagination .= '<li><a href="'.self::$currentIndex.'&page='.$i.'"'.($i == $nbCurrentPage ? ' class="selected"' : '').'>'.$i.'</a></li>';
			if($nbCurrentPage < $nbPages)
				$pagination .= '<li><a href="'.self::$currentIndex.'&page='.($nbCurrentPage+1).'" class="arrow">></a></li>';
		}
		$pagination .= '</ul><br/>';
		
		
		$search = '<form style="text-align:center;" method="post" id="formrechref" name="formrechref" action="'.self::$currentIndex.'" >';

		$search .= '<button class="button" style="margin-left:3%; font-size:11px; padding:2px 10px;" type="submit" name="submit">Rechercher</button>';
		
		$search .= '</form>';
		
		$txt .= $results.$pagination.'
			<span style="color:#00aaff;">Faites glisser les Articles, avec la souris, afin de les ordonner.</span><br/><br/>
			<table class="table documents tableDnD" id="tbliste">
				<tr class ="nodrag nodrop">
					<th style="padding:1% 0 1.5% 0; border-bottom: 1px solid #767161" colspan="10">'.$search.'</th>
				</tr>
				<tr class ="nodrag nodrop">
					<th style="width:16px">Position</th>
					<th>Image</th>
					<th>Nom</th>
					<th>Prix</th>
					<th style="text-align:center; width:20px">Active</th>
				</tr>';
		$irow = 0;
		
		
		$articles->limit($nb, $min);
		$articles->orderby('position ASC');
		
		foreach($articles as $article)
		{
			$article->getFullInfos();
			$article->getCoverImage();
			
			$onclick = 'onclick="document.location =\''.self::$currentIndex.'&id_article='.$article->id.'\'"';
			$txt .= '
				<tr'.($irow++ % 2 ? ' class="alt_row"' : '').' id="order_'.$article->id.'">';
				$txt .= '<td class="dragHandle"><img src="img/updown.gif" alt="" /></td>';

				$txt .= '<td '.$onclick.'>'.($article->image_cover ? '<img src="'.$article->image_cover['min'].'" width="25px" alt="" />' : '<img src="'.$article->uri.'fr-thumb.jpg" alt="" />' ).'</td>';

				$txt .= '<td '.$onclick.'>'.$article->nom_article.'</td>';
				$txt .= '<td '.$onclick.'>'.$article->price.'</td>';
				$txt .= '<td style="text-align:center;"><a href="'.self::$currentIndex.'&article='.$article->id.'&active='.($article->active ? 0 : 1 ).'&page='.$nbCurrentPage.'"><img src="img/'.($article->active ? 'enabled' : 'disabled' ).'.gif" alt="" /></a></td>';
			$txt .= '</tr>';
		}
		
		$txt .= '</table><br>';
		if($total>0)
		$txt .= '<a style="vertical-align:bottom; float:right; width:100px; display:block; text-align:center type="button" title="Supprimer tous les articles" class="confirmDelAll delete_all button"><img src="img/delete.gif" alt="" />Tout supprimer</a>';
		$txt .= ''.$pagination.'<br />';


		$txt .= '<hr />
			<h2>Utilisateurs</h2>
			<a style="vertical-align:bottom" href="'.self::$currentIndex.'&addUser_Ad"><img src="img/add.gif" border="0"> Ajouter</a><br /><br />
				<table class="table">
					<tr>
						<th style="width:16px">Id</th>
						<th>Nom</th>
						<th>Utilisateur</th>
						<th>Mot de passe</th>
						<th>Type</th>					
						<th>Active</th>
					</tr>';	
			$irow = 0;
			foreach(User_Ad::getUserAds('fr') as $user)
			{
				$user->getFullInfos();	
				
				$onclick = 'onclick="document.location =\''.self::$currentIndex.'&id_user_ad='.$user->id.'\'"';
				$txt .= '<tr'.($irow++ % 2 ? ' class="alt_row"' : '').'>';
					$txt .= '<td '.$onclick.'>'.$user->id.'</td>';
					$txt .= '<td '.$onclick.'>'.$user->name.'</td>';
					$txt .= '<td '.$onclick.'>'.$user->login.'</td>';
					$txt .= '<td '.$onclick.'>'.$user->password.'</td>';
					$txt .= '<td '.$onclick.'>'.$user->type.'</td>';
					$txt .= '<td><a href="'.self::$currentIndex.'&user='.$user->id.'&statut='.($user->statut ? 0 : 1 ).'&page='.$nbCurrentPage.'"><img src="img/'.($user->statut ? 'enabled' : 'disabled' ).'.gif" alt="" /></a></td>';
					
				$txt .= '</tr>';
			}
			$txt .= '</table><br /><br />';
		
		$kameleon_user = new KameleonUser();
	
		$txt .= '<div style="margin:8px">&nbsp;</div>';
		
		return $txt;
	}
	
	private function displayFormArticle()
	{
		$txt = "";
		
		if(!($article = $this->loadObject(true)))
			return;
		
		$txt .= '<form method="post" action="'.self::$currentIndex.'&add'.$this->className.'" enctype="multipart/form-data">';
		
		$txt .= '<script type="text/javascript">
			$(function(){
				setupMCEBack();
			});
		</script>
		<h2>Caractéristiques</h2>';

		
		if($article->id)
		{
			$infosarticle = Article::getInfosByIdArticle($article->id);
		}
		else
		{
			$infosarticle = "";
		}

		$txt .= '<table cellpadding="0" cellspacing="0" class="adminimmo">
					<tr><td><div class="inimmo">
		';
		$txt .= '<label class="label">Active :</label>
		<div class="margin-form">
			<input type="radio" name="active" id="active_on" value="1"'.($this->getFieldValue($article, 'active') == 1 ? ' checked="checked"' : '').' />
			<label class="t" for="active_on"><img src="img/enabled.gif" alt="Activé" title="Activé"></label>
			<input type="radio" name="active" id="active_off" value="0"'.($this->getFieldValue($article, 'active') == 0 ? ' checked="checked"' : '').' />
			<label class="t" for="active_off"><img src="img/disabled.gif" alt="Désactivé" title="Désactivé"></label>
		</div>';
		
		$txt .= '<label class="label" for="nom_article">Nom de l\'article: </label>
				<div class="margin-form">
					<input type="text" class="medium" name="nom_article" id="nom_article" value="'.$this->getFieldValue($article, 'nom_article').'"/>
				</div>';

			$txt .= '<label class="label" for="price">Prix : </label>
				<div class="margin-form">
					<input type="text" class="medium" name="price" id="price" value="'.$this->getFieldValue($article, 'price').'"/>
				</div>';

		$txt .= '</div>';
		
		if($article->id)
		{
			$txt .= '<hr />
			<h2>Images</h2>
			<input type="hidden" name="id_'.$this->table.'" value="'.$article->id.'" />
			<script type="text/javascript">
				var uri = \''.$article->uri.'\';				
				
				function addToList(img)
				{
					var elem =  $(\'#clone tr\');
					var clone = elem.clone(true);
					
					$(\'.image\', clone).attr(\'href\', uri+\''.$article->id.'-\'+img+\'-large.jpg\');
					$(\'.image img\', clone).attr(\'src\', uri+\''.$article->id.'-\'+img+\'-min.jpg\');
					$(\'input\', clone).attr(\'value\', img);
					$(\'.imageDelete\', clone).attr(\'item\', img);
					
					$(\'#imagesList\').append(clone);
				}
				
				$(function(){
					var uploader = new qq.FileUploader({
						element: document.getElementById(\'file-uploader\'),
						action: \''.self::$currentIndex.'\',
						params: {
							ajax: 1,
							action: \'addImage\',
							article: '.$article->id.'							
						},
						onComplete: function(id, fileName, responseJSON){
							if(responseJSON.success != undefined)
								addToList(responseJSON.id);
						}
					});
					
					$(\'.imageDelete\').on(\'click\', function(){
						var img = $(this).attr(\'item\');
						var del = $(this).parents(\'tr\');
						
						$("#dialog-confirm").html("<p>Êtes vous sûr de vouloir supprimer cette photo ?</p>");
						$("#dialog-confirm").dialog({
							resizable: false,
							height: 150,
							modal: true,
							title: "Suppression",
							buttons: {
								Oui: function(){
									$.ajax({
										type: \'POST\',
										url: \''.self::$currentIndex.'\',
										data: \'ajax=1&action=DeleteImage&article='.$article->id.'&img=\'+img+\'\',
										success: function(msg){
											if(msg == "1")
												del.remove();
										}
									});
									$("#dialog-confirm").dialog("close");
								},
								Non: function(){
									$("#dialog-confirm").dialog("close");
								}
							}
						});	
						return false;
					});
					
					$(".confirm").on(\'click\', function(){
						$("#dialog-confirm").html("<p>Êtes-vous sur de vouloir supprimer ce article ?</p>");
						$("#dialog-confirm").dialog({
							resizable: false,
							height: 150,
							modal: true,
							title: "Suppression",
							buttons: {
								Oui: function(){
									location.href = \''.self::$currentIndex.'&delete'.$this->className.'&id_article='.$article->id.'\';
								},
								Non: function(){
									$("#dialog-confirm").dialog("close");
								}
							}
						});	
					});
				});
			</script>';
			
			$txt .= '<div class="clear"></div>';
			
			$txt .= '<div id="file-uploader">		
					<noscript>			
						<p>Please enable JavaScript to use file uploader.</p>
						<!-- or put a simple form for upload here -->
					</noscript>         
				</div>';
				
			$txt .= '
			<table class="table tableDnD" id="imagesList">
				<tr class="nodrag nodrop">
					<th>Image</th>
					<th style="width:60px; text-align:center;">Principale</th>
					<th style="width:60px; text-align:center;">Position</th>
					<th style="width:60px; text-align:center;">Action</th>
				</tr>';

			$article->getImages();
			$key = 0;
			foreach($article->images as $img) 
			{
				$txt .= '<tr'.($key % 2 ? ' class="alt_row"' : '').'><td><a class="image" href="'.$img['large'].'">
				<input type="hidden" name="imgs[]" value="'.$img['id_image'].'" />
				<img src="'.$img['min'].'" class="imageGallery" /></a>
				</td>';
				
				$txt .= '<td style="text-align:center;"><input type="radio" name="cover" value="'.$img['id_image'].'"'.($img['cover'] ? ' checked="checked"' : '').' /></td>';
				
				$txt .= '<td class="dragHandle"><img src="img/updown.gif" alt="" /></td>
				<td style="text-align:center;"><a class="imageDelete" item="'.$img['id_image'].'"><img src="img/delete.gif" alt="" /></a></td>
				</tr>';
				$key++;
			}
			$txt .= '</table>';
		}
		
		$txt .= '<div class="margin-form"><button type="submit" class="button save" name="submitAdd'.$this->className.'">Enregistrer</button>&nbsp;&nbsp;&nbsp;&nbsp;'.($article->id  ? '<a type="button" class="confirm button delete">Supprimer</a>' : '').'</div></form>
		
		<table id="clone" style="display:none;">
			<tr>
				<td><a class="image" href="">
				<input type="hidden" name="img_name[]" value="" />
				<img src="" class="imageGallery" /></a></td>
				<td style="text-align:center;"><input type="radio" name="cover" /></td>';
				
		return $txt .= '<td class="dragHandle"><img src="img/updown.gif" alt="" /></td>
				<td style="text-align:center;"><a class="imageDelete" item=""><img src="img/delete.gif" alt="" /></a></td>
			</tr>
		</table>';		
	}

	////////////////////////  Gestion user///////////////
	
	
	private function displayFormUserAd()
	{
		global $listLang;
		
		$txt = $this->displayFlags();
		
		if(!($userAd = $this->loadObject(true))) return;
		
		$txt .= '<form method="post" action="'.self::$currentIndex.'&add'.$this->className.'">';
		
		if($userAd->id)
		{
			$txt .= '<script type="text/javascript">         
						$(function(){
						   $(".confirm").on(\'click\', function(){
							  $("#dialog-confirm").html("<p>Êtes-vous sur de vouloir supprimer cet Utilisateur?</p>");
							  $("#dialog-confirm").dialog({
								 resizable: false,
								 height: 150,
								 modal: true,
								 title: "Suppression",
								 buttons: {
									Oui: function(){
									   location.href = \''.self::$currentIndex.'&delete'.$this->className.'&id_user_ad='.$userAd->id.'\';
									},
									Non: function(){
									   $("#dialog-confirm").dialog("close");
									}
								 }
							  });   
						   });
						});
					 </script>';
			$txt .= '<input type="hidden" name="id_'.$this->table.'" value="'.$userAd->id.'" />';
			
			}

		$txt .= '<label class="label">Active :</label>
		<div class="margin-form">
			<input type="radio" name="statut" id="statut_on" value="1"'.($this->getFieldValue($userAd, 'statut') == 1 ? ' checked="checked"' : '').' />
			<label class="t" for="statut_on"><img src="img/enabled.gif" alt="Activé" title="Activé"></label>
			<input type="radio" name="statut" id="statut_off" value="0"'.($this->getFieldValue($userAd, 'statut') == 0 ? ' checked="checked"' : '').' />
			<label class="t" for="statut_off"><img src="img/disabled.gif" alt="Désactivé" title="Désactivé"></label>
		</div>';

		foreach($listLang as $lang)
		{
			$imgFlag = '&nbsp;<img src="img/lang/'.$lang.'.gif" />';
			$txt .= '<div class="display '.$lang.'">';
	if($userAd->id)
		$txt .= '<label class="label" for="type_'.$lang.'">Type : </label>
			<div class="margin-form">
			<select name="type_'.$lang.'" id="type" required>
				<option value=""></option>
				<option value="Admin"'.($this->getFieldValue($userAd, 'type', $lang) == "Admin" ? ' selected="selected"' : '').'>Admin</option>
				<option value="Caissière"'.($this->getFieldValue($userAd, 'type', $lang) == "Caissière" ? ' selected="selected"' : '').'>Caissière</option>

				<option value="Autre"'.($this->getFieldValue($userAd, 'type', $lang) == "Autre" ? ' selected="selected"' : '').'>Autre</option>
			</select>
			</div>';
		else
			$txt .= '<label class="label" for="type_'.$lang.'">Type : </label>
			<div class="margin-form">
			<select name="type_'.$lang.'" id="type" required>
				<option value=""></option>
				<option value="Admin">Admin</option>
				<option value="Caissière">Caissière</option>
				<option value="Autre">Autre</option>
			</select>
			</div>';
				

			$txt .= '<label class="label '.$lang.' display" for="name_'.$lang.'" for="name_'.$lang.'">Nom : </label>
			<div class="margin-form '.$lang.' display"><input class="medium" required type="text" name="name_'.$lang.'" id="name_'.$lang.'" value="'.$this->getFieldValue($userAd, 'name', $lang).'" />'.$imgFlag.'</div>';				
			$txt .= '<label class="label '.$lang.' display" for="login_'.$lang.'" for="login_'.$lang.'">Utilisateur : </label>
			<div class="margin-form '.$lang.' display"><input class="medium" required type="text" name="login_'.$lang.'" id="login_'.$lang.'" value="'.$this->getFieldValue($userAd, 'login', $lang).'" />'.$imgFlag.'</div>';		
			
			$txt .= '<label class="label '.$lang.' display" for="password_'.$lang.'" for="password_'.$lang.'">Mot de passe : </label>
			<div class="margin-form '.$lang.' display"><input class="medium" type="text" required name="password_'.$lang.'" id="password_'.$lang.'" value="'.$this->getFieldValue($userAd, 'password', $lang).'" />'.$imgFlag.'</div>';
			
		
			
			
			}
		
		return $txt .= '<div class="margin-form"><button type="submit" class="button save" name="submitAdd'.$this->className.'">Enregistrer</button>&nbsp;&nbsp;&nbsp;&nbsp;'.($userAd->id  ? '<a type="button" class="confirm button delete">Supprimer</a>' : '').'</div></form>';		
	
	}
	
	
	protected function _cleanMetaKeywords($keywords)
	{
		if (!empty($keywords) && $keywords != '')
		{
			$out = array();
			$words = explode(',', $keywords);
			foreach ($words as $word_item)
			{
				$word_item = trim($word_item);
				if (!empty($word_item) && $word_item != '')
					$out[] = $word_item;
			}
			return ((count($out) > 0) ? implode(',', $out) : '');
		}
		else
			return '';
	}
	
	protected function copyFromPost(&$object, $table)
	{
		parent::copyFromPost($object, $table);
		
		global $listLang;
		
		foreach ($listLang as $language)
		{
			if (isset($_POST['meta_keywords_'.$language]))
			{
				$_POST['meta_keywords_'.$language] = $this->_cleanMetaKeywords(Tools::strtolower($_POST['meta_keywords_'.$language]));
				$object->meta_keywords[$language] = $_POST['meta_keywords_'.$language];
			}
			if (isset($_POST['meta_robots_'.$language]))
			{
				$_POST['meta_robots_'.$language] = $this->_cleanMetaKeywords(Tools::strtolower($_POST['meta_robots_'.$language]));
				$object->meta_robots[$language] = $_POST['meta_robots_'.$language];
			}
		}
	}
}