<?php
class Agence_Ad extends ObjectModelDB
{
	public $id_agence_ad;
	
	public $name;
	public $adresse;
	public $codevendeur;
	public $description;
	public $telephone;
	public $lemail;
	public $typeagence;

	
		
	protected $fieldsRequiredLang = array(
		'name','lemail','codevendeur','typeagence');
	
	protected $fieldsValidateLang = array(
		'name' => 'isGenericName',
		'adresse' => 'isGenericName',
		'codevendeur' => 'isGenericName',
		'telephone' => 'isGenericName',
		'lemail' => 'isGenericName',
		'typeagence' => 'isGenericName',
		'description' => 'isString'
		);
	
	protected $fieldsSizeLang = array(
		'name' => 100,
		'adresse' => 50,
		'codevendeur' => 100,
		'telephone' => 20,
		'lemail' => 50,
		'typeagence' => 100,);

	public static $definition = array(
		'table' => 'agence_ad',
		'primary' => 'id_agence_ad',
		'multilang' => true);
		
/*public static $definition = array(
		'table' => 'agence_ref',
		'primary' => 'codevendeur',
		'multilang' => true);
*/		

	public static function getAgenceAds($id_lang = _DEFAULT_LANG_)
	{
		$agenceAds = new Collection('agence_ad', $id_lang);
		$agenceAds->orderBy('name');
		return $agenceAds;
	}
	
/*********************************************Recherche par reference***********************************************************/



	public static function getAgenceByRefAgences($id_lang = _DEFAULT_LANG_,$refag)
	{
		$agenceAds = new Collection('agence_ad', $id_lang);
		$agenceAds->where('codevendeur LIKE "%'.$refag.'%"');
		$agenceAds->orderBy('name');
		return $agenceAds;
	}
	
		public static function getAgenceByNameAgences($id_lang = _DEFAULT_LANG_,$namag)
	{
		$agenceAds = new Collection('agence_ad', $id_lang);
		$agenceAds->where('name LIKE "%'.$namag.'%"');
		$agenceAds->orderBy('name');
		return $agenceAds;
	}
	
			public static function getAgenceByTypeAgences($id_lang = _DEFAULT_LANG_,$typag)
	{
		$agenceAds = new Collection('agence_ad', $id_lang);
		$agenceAds->where('typeagence LIKE "'.$typag.'"');
		//$agenceAds->orderBy('name');
		return $agenceAds;
	}
	
	static protected $cacheName = array();
	
	public static function getNameById($id_agence_ad, $lang)
	{
		if (!isset(self::$cacheName[$id_agence_ad.$lang]))
			self::$cacheName[$id_agence_ad.$lang] = Db::getInstance()->getValue('
				SELECT `name`
				FROM `'._DB_PREFIX_.'agence_ad` ag
				LEFT JOIN `'._DB_PREFIX_.'agence_ad_lang` agl ON (ag.`id_agence_ad` = agl.`id_agence_ad`)
				WHERE ag.`id_agence_ad` = '.(int)$id_agence_ad.'
				AND agl.lang = "'.$lang.'"'
			);

		return self::$cacheName[$id_agence_ad.$lang];
	}
	
	public static function getRefAgences()
	{
		

	return Db::getInstance()->ExecuteS('SELECT codevendeur FROM agence_ad_lang GROUP BY codevendeur ORDER BY codevendeur ASC' );
	
	
	}
	
	
	public static function getNameAgences()
	{
		return Db::getInstance()->ExecuteS('SELECT name FROM agence_ad_lang GROUP BY name ORDER BY name ASC' );
	}
	public static function getTypeAgences()
	{
		return Db::getInstance()->ExecuteS('SELECT typeagence FROM agence_ad_lang  GROUP BY typeagence ORDER BY typeagence ASC' );
	}
}