<?php
class Depense extends ObjectModelDB
{
	public $id_depense;
	public $designation;
	public $quantite;
	public $total;
	public $id_user_ad;
	public $motif;

	public $date_add;
	public $date_upd;


		
	protected $fieldsRequired = array();
		
	protected $fieldsValidate = array(
		'id_depense' => 'isUnsignedId',
		'designation' => 'isGenericName',
		'quantite' => 'isInt',	
		'total' => 'isInt',
		'id_user_ad' => 'isUnsignedId',
		'motif' => 'isCleanHtml',
		'date_add' => 'isDateFormat',
		'date_upd' => 'isDateFormat'
	);
		

	public static $definition = array(
		'table' => 'depense',
		'primary' => 'id_depense',
		'multilang' => false);

	public static function getDepenses()
	{
		$depenses = new Collection('depense');
		
		return $depenses;
	}
	

	public function getFullInfos()
	{
	}

	static protected $cacheName = array();
	
}