<?php
require_once(dirname(__FILE__).'/Article.php');
require_once(dirname(__FILE__).'/Vente.php');
require_once(dirname(__FILE__).'/Depense.php');
require_once(dirname(__FILE__).'/Autre_depense.php');
require_once(dirname(__FILE__).'/Image.php');
require_once(dirname(__FILE__).'/User_Ad.php');
require_once(dirname(__FILE__).'/Employe.php');
require_once(dirname(__FILE__).'/Salaire.php');
require_once(dirname(__FILE__).'/AdminArticle.php');

/*$error_log2 = "error_log";
unlink($error_log2);*/

class Immo extends Module
{
	public function __construct($id = false)
	{
		$this->name = 'immo';
		$this->version = 1.3;
		$this->category = 'Base de données';
		$this->visible = true;
		$this->requiredId = true;
		$this->error = false;
		$this->valid = false;
		$this->adminTab = 'AdminArticle';
		$this->picto = 'picto.png';		
		parent::__construct();
		
		$this->displayName = 'Base de données';
		$this->description = 'Gestion des articles';

		if($id)
		{
			$this->id = $id;
			$this->name.= '='.$id;
		}
	}
	
	public function getInfos()
	{
		if($this->id == 20)
			return $this->displayName .= ' : Articles';
		if($this->id == 21)
			return $this->displayName .= ' : Statistiques';
	}
	
	//-----Fonction d'installation du module-----
	//Vérification connexion BD 
	//Si ok: -création des tables et remplissage 
	//        des données via fichier xml;
	//		 -création des hooks.
	//-------------------------------------------
	public function install()
	{
		$dir = dirname(__FILE__).'/../../xml/';
		$xmlName = 'configuration.xml';
		$dirSql = dirname(__FILE__).'/sql/immo.sql';
		
		$xml = new SimpleDOM($dir.$xmlName, NULL, true);
		$dbServeur = $xml->db_server;
		$dbUser = $xml->db_user;
		$dbPass = $xml->db_passwd;
		$dbName = $xml->db_name;
			
		if(DbMySQLi::tryToConnect($dbServeur,$dbUser,$dbPass,$dbName)===0
			&& $dbServeur != '' && $dbUser != '' && $dbName != ''){
			$db = new DbMySQLi($dbServeur,$dbUser,$dbPass,$dbName);
			
			$sql = file_get_contents($dirSql);

			$sql_array = explode(";",$sql);
			foreach ($sql_array as $val) {
				$db->execute($val);
			}
		}else{
			return 'Installation du module "Base de données" impossible! Veuillez remplir correctement 
					les informations concernant la base de données dans l\'onglet "Configuration du site"';
		}
		
		if(parent::install())
		{
			Module::registerModuleHook('HOME', $this->name.'=10');
			$hook = 'NOT_ASSIGN';
			Module::registerModuleHook('STATS', $this->name.'=21');
			Module::registerModuleHook($hook, $this->name.'=21');
			
			return true;
		}
	}
	
	//--------Fonction de désinstallation du module-------
	//Suppression des hooks;
	//Si $supprBase=true: suppression des tables de la BD.
	//----------------------------------------------------
	public function uninstall()
	{	
		if(parent::uninstall())
		{
			Page::deleteModule($this->name.'=20');
			Page::deleteModule($this->name.'=21');

			return true;
		}
	}
	public function display_HOME()
	{
		return $this->getFront();
	}


	public function getFront()
	{		
		if($this->id == 11)
			return $this->displayMailAlert();

		global $smarty, $cookie, $controller, $listLang;

		session_start();
		$userinfos = User_Ad::getUserInfosByid($_SESSION['privateaccess'], 'fr');
		
		$page = $controller->getCurrentPage();
		$page_link = $page->getLinkRewrite($cookie->lang);
		
		$nb = 100;
		$nbCurrentPage = (Tools::isSubmit('page') ? Tools::getValue('page') : 1);
		$min = ($nbCurrentPage - 1) * $nb;
		
		$search = array();
		$where = array();

		if(Tools::isSubmit('nom') && Tools::getValue('nom') != '')
		{
			$where[] = 'a.`nom_article` LIKE "%'.pSQL(Tools::getValue('nom')).'%"';
			$search[] = 'nom='.pSQL(Tools::getValue('nom'));
		}


		$smarty->assign(array(
			'search' => count($search) ? implode('&', $search) : '',
			'nbCurrentPage' => $nbCurrentPage,
			'page_link' => $page_link)
		);

		$datetime1 = new DateTime();
		$datetime2 = $datetime1->format('d/m/Y');
		$datesal = $datetime1->format('m/Y');

		//echo($datetime2);
		//exit;
		

		$ventesdujour="";
		$totalventedujour=0;
		$totalventedujoursalon=0;
		$totalventedujourboisson=0;
		$ventetab="";

		$depensesdujour="";
		$depensesdumois="";
		$totaldepensedujour=0;
		$totaldepensedumois=0;
		$depensetab="";
		$depensetab2="";
		$usertab="";
		$employetab="";
		$salairetab="";

		$ventesdujour = Db::getInstance()->ExecuteS('
			SELECT v.*, a.`nom_article`, a.`type_article`
			FROM `vente` v
			LEFT JOIN `article` a
			ON (v.`id_article` = a.`id_article`)
		');
		foreach($ventesdujour as $ventedujour)
		{
			$datetime3 = new DateTime($ventedujour['date_add']);
			$datetime4 = $datetime3->format('d/m/Y');
			$datetime5 = $datetime3->format('H:i:s');

			if($datetime4 == $datetime2)
			{
				$ventetab .= '
					<tr>
						<td>0000'.$ventedujour["id_commande"].'</td>
						<td>'.$ventedujour["nom_article"].'</td>
						<td>'.$ventedujour["pu"].'</td>
						<td>'.$ventedujour["quantite"].'</td>
						<td>'.Tools::displayPrice($ventedujour["totalligne"]).'</td>
						<td>'.$datetime5.'</td>
						<td>'.$ventedujour["prestataire"].'</td>';

						//var_dump($userinfos);
						//echo('type = '.$userinfos[0]['type']);
						//exit;

						if($userinfos[0]['type']=="Admin")
						{
							$ventetab .= '<td class="d-flex align-items-center"><form role="form" method="post" class="m-0">
							<input type="hidden" name="id_vente" class="form-control" id="id_vente" value="'.$ventedujour["id_vente"].'"><button type="submit" class="bg-transparent border-0" name="supVente"><img src="'._BASE_URI_MODULES_.'immo/img/disabled.gif" alt="" /></button></form></td>';
						}

						
					$ventetab .= '</tr>
				';
				$totalventedujour+=(int)$ventedujour["totalligne"];

				if($ventedujour["type_article"] == "Salon")
						$totalventedujoursalon+=(int)$ventedujour["totalligne"];

				if($ventedujour["type_article"] == "Boisson")
						$totalventedujourboisson+=(int)$ventedujour["totalligne"];
				
			}
		}

		$depensesdujour = Db::getInstance()->ExecuteS('
			SELECT *
			FROM `depense` d
			ORDER BY d.`date_add` DESC
		');
		foreach($depensesdujour as $depensedujour)
		{
			$datetimedep = new DateTime($depensedujour['date_add']);
			$datetimedep2 = $datetimedep->format('d/m/Y à H:i:s');
			$datetimedep3 = $datetimedep->format('d');

			if($datetimedep3 == $datetime2)
			{
				$depensetab .= '
					<tr>
						<td>'.$depensedujour["designation"].'</td>
						<td>'.$depensedujour["quantite"].'</td>
						<td>'.Tools::displayPrice($depensedujour["total"]).'</td>
						<td>'.$depensedujour["motif"].'</td>					
						<td>'.$datetimedep2.'</td>
					</tr>
				';
				$totaldepensedujour+=(int)$depensedujour["total"];
			}
		}

		$depensesdumois = Db::getInstance()->ExecuteS('
			SELECT *
			FROM `autre_depense` a
		');
		foreach($depensesdumois as $depensedumois)
		{
			$datetimeautrdep = new DateTime($depensedumois['date_depense']);
			$datetimeautrdep2 = $datetimeautrdep->format('m/Y');
			$datetimeautrdep3 = $datetimeautrdep->format('d/m/Y');

			if($datetimeautrdep2 == $datesal)
			{
				$depensetab2 .= '
					<tr>
						<td>'.$depensedumois["libelle_depense"].'</td>
						<td>'.Tools::displayPrice($depensedumois["total_depense"]).'</td>
						<td>'.$datetimeautrdep3.'</td>
						<td>'.$depensedumois["motif_depense"].'</td>					
						
					</tr>
				';
				$totaldepensedumois+=(int)$depensedumois["total_depense"];
			}
		}

		$users = User_Ad::getCaissieres();

		foreach($users as $user)
		{
			$usertab .= '
				<tr>
					<td>'.$user->id_user_ad.'</td>
					<td class="d-flex align-items-center">'.$user->name.' <form role="form" method="post" class="m-0"><input type="hidden" name="id_user_ad" class="form-control" id="id_user_ad" value="'.$user->id_user_ad.'"><button type="submit" class="ml-3 p-1 btn btn-danger" name="deletUser">Supprimer</button></form></td>
				</tr>
			';
		}

		if(Tools::isSubmit('addDepense'))
		{
			//var_dump($_POST);
			//exit;
			
			$depense = new Depense();

			$depense->designation = trim(Tools::getValue('designation'));
			$depense->quantite = (int)Tools::getValue('quantite');
			$depense->total = (int)Tools::getValue('total');
			$depense->id_user_ad = (int)Tools::getValue('iduser');
			$depense->motif = Tools::htmlentitiesUTF8(Tools::stripslashes(Tools::getValue('motif')));

			if($depense->add())
				Tools::redirectAdmin('?validdep&depense');
			else
				$this->errors[] = $this->l("Echec ajout dépense");
		}

		if(Tools::isSubmit('addDepense2'))
		{
			//var_dump($_POST);
			//exit;
			
			$autredepense = new Autre_depense();

			$autredepense->libelle_depense = trim(Tools::getValue('libelle_depense'));
			$autredepense->total_depense = (int)Tools::getValue('total_depense');
			$autredepense->date_depense = Tools::getValue('date_depense');
			$autredepense->motif_depense = Tools::htmlentitiesUTF8(Tools::stripslashes(Tools::getValue('motif_depense')));

			if($autredepense->add())
				Tools::redirectAdmin('?validdep2&depense');
			else
				$this->errors[] = $this->l("Echec ajout dépense");
		}

		if(Tools::isSubmit('addUser'))
		{
			//var_dump($_POST);
			//exit;
			
			$user = new User_Ad();

			$user->type = array(
				'fr' => trim(Tools::getValue('type'))
			);
			$user->name = array(
				'fr' => trim(Tools::getValue('name'))
			);
			$user->login = array(
				'fr' => trim(Tools::getValue('login'))
			);
			$user->password = array(
				'fr' => trim(Tools::getValue('password'))
			);

			if($user->add())
				Tools::redirectAdmin('?validcai&depense');
			else
				$this->errors[] = $this->l("Echec ajout caissière");
		}


		if(Tools::isSubmit('updateArticle'))
		{
			$article = new Article((int)Tools::getValue('id_article'));

			$article->active = (int)Tools::getValue('active');
			$article->nom_article = (string)trim(Tools::getValue('nom_article'));
			$article->qte_article = (int)trim(Tools::getValue('qte_article'));
			$article->price = (int)trim(Tools::getValue('price'));
			$article->type_article = (string)trim(Tools::getValue('type_article'));
			if($article->update())
				Tools::redirectAdmin('?validupd&article');
			else
				$this->errors[] = $this->l("Echec mise à jour");
		}

		if(Tools::isSubmit('etatEmploye'))
		{
			$employe = new Employe((int)Tools::getValue('id_employe'));

			$datetimeemp = new DateTime();
			$datetimeempform = $datetimeemp->format('Y-m-d H:i:s');

			$etat = (int)Tools::getValue('active_employe');

			if($etat == 1){
				$employe->active_employe = 0;
				$employe->date_sortie = $datetimeempform;
			}
			else{
				$employe->active_employe = 1;
				$employe->date_sortie = "";
			}

			if($employe->update())
				Tools::redirectAdmin('?addemp=1&validactemp');
			else
				$this->errors[] = $this->l("Echec mise à jour");
		}

		if(Tools::isSubmit('supVente'))
		{
			$vente = new Vente((int)Tools::getValue('id_vente'));

			if($vente->delete())
				Tools::redirectAdmin('?supvente=1&validsupvente');
			else
				$this->errors[] = $this->l("Echec suppression");
		}

		if(Tools::isSubmit('deleteArticle'))
		{
			$article = new Article((int)Tools::getValue('id_article'));

			if($article->delete())
				Tools::redirectAdmin('?validdel&article');
			else
				$this->errors[] = $this->l("Echec suppression");
		}

		if(Tools::isSubmit('deletUser'))
		{
			$user = new User_Ad((int)Tools::getValue('id_user_ad'));

			if($user->delete())
				Tools::redirectAdmin('?addcai=1&validdeluser');
			else
				$this->errors[] = $this->l("Echec suppression");
		}

		if(Tools::isSubmit('addArticle'))
		{
			$typfichier = array(
				'image/jpeg',
				'image/jpg',
				'image/png'
			);
			$article = new Article();

			$article->active = (int)Tools::getValue('active');
			$article->nom_article = (string)trim(Tools::getValue('nom_article'));
			$article->qte_article = (string)trim(Tools::getValue('qte_article'));
			$article->price = (int)Tools::getValue('price');
			$article->type_article = (string)trim(Tools::getValue('type_article'));

			$dir = dirname(__FILE__).'/temporaire/';
			if (!file_exists($dir) || !is_dir($dir))
			{
				mkdir(dirname(__FILE__) . '/temporaire', 0775);
			}

			if(isset($_FILES['imgart']) && !empty($_FILES['imgart']['name']))
			{
				$type = $_FILES['imgart']['type'];
				$poid = (int)($_FILES['imgart']['size'])/1024;
				$poid = (int)$poid;

				if($_FILES['imgart']['error'] > 0)
				{
					$this->errors[] = $this->l('Erreur lors de l\'ajout de l\'image');
				}
			}
			$nameTmp = $_FILES['imgart']['tmp_name'];
			$nameFile = $_FILES['imgart']['name'];
			$type = $_FILES['imgart']['type'];
			$extension = pathinfo($nameFile, PATHINFO_EXTENSION);
			$nameImage = $nameFile;
			move_uploaded_file($nameTmp,$dir.$nameImage);
			$chemin = $dir.$nameFile;

			if($article->add())
			{
				$file = $dir.$nameFile;
				if (@getimagesize($file))
				{
					$image = new Image();
					$image->id_article = $article->id;
					$image->cover = 1;
					$image->position = 1;
					if($image->add())
					{
						copy($file, dirname(__FILE__).'/images/'.$image->id_article.'-'.$image->id.'.'.$extension);
						$image->getFullInfos();
						$image->generateImages();
						@unlink($file);
						@unlink($dir);

					}

					Tools::redirectAdmin('?validadd&article');
				}				
				return true;				
			}
			else
				$this->errors[] = $this->l("Echec ajout article");
		}

		if(Tools::isSubmit('addEmploye'))
		{
			//var_dump($_POST);
			//exit;
			
			$employe = new Employe();

			$employe->active_employe = Tools::getValue('active_employe');
			$employe->nom_employe = Tools::getValue('nom_employe');
			$employe->prenom_employe = Tools::getValue('prenom_employe');
			$employe->infos_employe = Tools::getValue('infos_employe');
			$employe->date_entree = Tools::getValue('date_entree');
			$employe->date_sortie = Tools::getValue('date_sortie');

			if($employe->add())
				Tools::redirectAdmin('?validemp&employe');
			else
				$this->errors[] = $this->l("Echec ajout employé");
		}

		if(Tools::isSubmit('addSalaire'))
		{
			//var_dump($_POST);
			//exit;
			
			$salaire = new Salaire();

			$salaire->id_employe = Tools::getValue('id_employe');
			$salaire->montant = Tools::getValue('montant');
			$salaire->date_paye = Tools::getValue('date_paye');
			$salaire->infos_salaire = Tools::getValue('infos_salaire');

			if($salaire->add())
				Tools::redirectAdmin('?addemp=1&validsal');
			else
				$this->errors[] = $this->l("Echec ajout salaire");
		}

		//$salaires = Salaire::getSalaires();

		$salaires = Db::getInstance()->ExecuteS('
			SELECT s.*, e.`nom_employe`, e.`prenom_employe`
			FROM `salaire` s
			LEFT JOIN `employe` e
			ON (s.`id_employe` = e.`id_employe`)
			ORDER BY e.`nom_employe`
		');

		foreach($salaires as $salaire)
		{
			$datetimesal = new DateTime($salaire["date_paye"]);
			$datetimesal2 = $datetimesal->format('m/Y');
			$datetimesal3 = $datetimesal->format('d/m/Y');

			if($datetimesal2 == $datesal)
			{
				$salairetab .= '
					<tr>
						<td>'.$salaire["nom_employe"].' '.$salaire["prenom_employe"].'</td>
						<td>'.Tools::displayPrice($salaire["montant"]).'</td>
						<td>'.$datetimesal3.'</td>
						<td>'.$salaire["infos_salaire"].'</td>
					</tr>
				';
				//$totaldepensedujour+=(int)$depensedujour["total"];
			}
		}
		
		Module::$CSS['article_list'] = $this->_path.'article-list.css';
		
		$allArticles = Article::getArticles();
		$articles = Article::getArticles();
		$articlesbytype = Article::getArticlesByType($type);

		$employesactifs = Employe::getEmployesActifs();
		$employes = Employe::getEmployes();

		$dateentree = "";
		$datesortie2 = "";

		foreach($employes as $employe)
		{
			$dateentree = new DateTime($employe->date_entree);
			$dateentree2 = $dateentree->format('d/m/Y');
			if($employe->date_sortie)
			{
				$datesortie = new DateTime($employe->date_sortie);			
				$datesortie2 = $datesortie->format('d/m/Y');
			}

			$employetab .= '
				<tr>
					<td>'.$employe->id_employe.'</td>
					<td class="">'.$employe->nom_employe.' '.$employe->prenom_employe.'</td>
					<td class="">'.$dateentree2.'</td>
					<td class="">'.$datesortie2.'</td>
					<td class="">'.$employe->infos_employe.'</td>
					<td class="d-flex align-items-center"><form role="form" method="post" class="m-0"><input type="hidden" name="active_employe" class="form-control" id="active_employe" value="'.$employe->active_employe.'"><input type="hidden" name="id_employe" class="form-control" id="id_employe" value="'.$employe->id_employe.'"><button type="submit" class="bg-transparent border-0" name="etatEmploye"><img src="'._BASE_URI_MODULES_.'immo/img/'.($employe->active_employe ? 'enabled' : 'disabled' ).'.gif" alt="" /></button></form></td>
				</tr>
			';
		}
		
		if($this->id == 20)
			//$where[] = 'id_article <> 0';
		
		foreach($where as $query)
		{
			$allArticles->where($query);
			$articles->where($query);
		}

		$total_articles = count($allArticles);
		$articles->limit($nb, $min);
		$articles->orderby('id_article ASC');
		
		$linkArticle = '';
		$tabLink = explode('/',$page_link);
		array_pop($tabLink);
		foreach($tabLink as $link)
		{
			$linkArticle .= $link.'/';
		}

		foreach($articles as $article)
		{
			$infosarticle = Article::getInfosByIdArticle((int)$article->id_article);

			$article->getFullInfos();

			$avecaccent = array("é","è","ù","ô","à","ç");
			$sansaccent = array("e","e","u","o","a","c");		
			$article->link_rewrite = $linkArticle.$article->id.'-'.$page->id.'-'.Tools::link_rewrite(str_replace($avecaccent,$sansaccent,$article->nom_article));
		}

		$usertypes = User_Ad::getUserAds($cookie->lang);

		$prestataires = Employe::getEmployes();


		$last_id_facture = Db::getInstance()->getValue('
				SELECT max(id_commande)
				FROM `vente`
			');
			$last_id_facture = (int)$last_id_facture+1;

		$smarty->assign(array(
			'errors' => $this->errors,
			'valid' => Tools::isSubmit('valid') ? $this->l('Opération réussie') : false,
			'validupd' => Tools::isSubmit('validupd') ? $this->l('Mise à jour effetuée') : false,
			'validdel' => Tools::isSubmit('validdel') ? $this->l('Suppression effetuée') : false,
			'validdeluser' => Tools::isSubmit('validdeluser') ? $this->l('Suppression effetuée') : false,

			'validadd' => Tools::isSubmit('validadd') ? $this->l('Ajout article effetué') : false,
			'validdep' => Tools::isSubmit('validdep') ? $this->l('Ajout depense effetué') : false,
			'validdep2' => Tools::isSubmit('validdep2') ? $this->l('Ajout depense effetué') : false,
			'validcai' => Tools::isSubmit('validcai') ? $this->l('Ajout caissière effetué') : false,
			'validemp' => Tools::isSubmit('validemp') ? $this->l('Ajout employé effetué') : false,
			'validsal' => Tools::isSubmit('validsal') ? $this->l('Ajout salaire effetué') : false,

			'validactemp' => Tools::isSubmit('validactemp') ? $this->l('Mise à jour effetuée') : false,
			'usertypes' => $usertypes,
			'ventetab' => $ventetab,
			'totalventedujour' => $totalventedujour,
			'totalventedujoursalon' => $totalventedujoursalon,
			'totalventedujourboisson' => $totalventedujourboisson,
			'depensetab' => $depensetab,
			'depensetab2' => $depensetab2,
			'totaldepensedujour' => $totaldepensedujour,
			'totaldepensedumois' => $totaldepensedumois,
			'usertab' => $usertab,
			'employetab' => $employetab,
			'employes' => $employes,
			'employesactifs' => $employesactifs,
			'salairetab' => $salairetab,
			'userinfos' => $userinfos,
			'articles' => $articles,
			'total_articles' => $total_articles,
			'total_pages' => $total_articles > 0 ? ceil($total_articles / $nb) : 0,
			'aimprimer' => $aimprimer,
			'prestataires' => $prestataires,
			'nomclient' => $nomclient,			
			'last_id_facture' => $last_id_facture
			
		));

			if($page->id==9)
			{
				//return $this->display(__FILE__, 'stat.tpl');
				return $this->display_STATS();
			}
			else
				return $this->display(__FILE__, 'article-list.tpl');
	}

	public function affDate($date)
	{
		$year = substr($date, 0, 4);
		$month = substr($date, 5, 2);
		$day = substr($date, 8, 2);

		$str = $day.'/'.$month.'/'.$year;
		return $str;
	}

	public function display_STATS()
	{		
		global $smarty, $cookie, $controller, $listLang;

		$page = $controller->getCurrentPage();
		$page_link = $page->getLinkRewrite($cookie->lang);
				
		$search = array();
		$where = array();

		if(Tools::isSubmit('nom') && Tools::getValue('nom') != '')
		{
			$where[] = 'a.`nom_article` LIKE "%'.pSQL(Tools::getValue('nom')).'%"';
			$search[] = 'nom='.pSQL(Tools::getValue('nom'));
		}


		$smarty->assign(array(
			'search' => count($search) ? implode('&', $search) : '',
			'page_link' => $page_link
		));

		$datetime1 = new DateTime();
		$datetime2 = $datetime1->format('d/m/Y');
		$datesal = $datetime1->format('m/Y');

		$ventes="";
		$totalvente=0;
		$totalventesalon=0;
		$totalventeboisson=0;
		$ventetab2="";

		$depenses="";
		$totaldepense=0;
		$depensetab2="";
		

		$ventes = Db::getInstance()->ExecuteS('
			SELECT v.*, a.`nom_article`, a.`type_article`
			FROM `vente` v
			LEFT JOIN `article` a
			ON (v.`id_article` = a.`id_article`)
		');

		$depenses = Db::getInstance()->ExecuteS('
			SELECT *
			FROM `depense` d
			ORDER BY d.`date_add` DESC
		');
		
		Module::$CSS['article_list'] = $this->_path.'article-list.css';
		
		$allArticles = Article::getArticles();
		$articles = Article::getArticles();
		
		
		$total_articles = count($allArticles);

		$articles->orderby('id_article ASC');
		
		foreach($articles as $article)
		{
			$infosarticle = Article::getInfosByIdArticle((int)$article->id_article);
			$article->getFullInfos();
		}

		if(Tools::isSubmit('intervaldate'))
		{
			$debut = Tools::getValue('date_depart');
			$fin = Tools::getValue('date_fin');
			$solde=0;
			$reduction=0;

			//var_dump($_POST);
			//exit;

			foreach($ventes as $vente)
			{
				$datetimevente = new DateTime($vente['date_add']);
				$datetimeventeform = $datetimevente->format('Y-m-d');
				$datetimeventeform2 = $datetimevente->format('d/m/Y à H:i:s');

				if(($datetimeventeform >= $debut) && ($datetimeventeform <= $fin))
				{
					$ventetab2 .= '
						<tr>
							<td>'.$vente["id_commande"].'</td>
							<td>'.$vente["nom_article"].'</td>
							<td>'.$vente["pu"].'</td>
							<td>'.$vente["quantite"].'</td>
							<td>'.Tools::displayPrice($vente["totalligne"]).'</td>
							<td>'.$datetimeventeform2.'</td>
							<td>'.$vente["prestataire"].'</td>
							<td class="d-flex align-items-center"><form role="form" method="post" class="m-0">
							<input type="hidden" name="id_vente" class="form-control" id="id_vente" value="'.$vente["id_vente"].'"><button type="submit" class="bg-transparent border-0 p-0" name="supVente" style="width: 16px;height: 16px"><img src="'._BASE_URI_MODULES_.'immo/img/disabled.gif" alt="" /></button></form></td>
						</tr>
					';

					$ventetab .= '';
					$totalvente+=(int)$vente["totalligne"];

					if($vente["type_article"] == "Salon")
						$totalventesalon+=(int)$vente["totalligne"];

					if($vente["type_article"] == "Boisson")
						$totalventeboisson+=(int)$vente["totalligne"];
				}
			}

			foreach($depenses as $depense)
			{
				$datetimedepense = new DateTime($depense['date_add']);
				$datetimedepenseform = $datetimedepense->format('Y-m-d');
				$datetimedepenseform2 = $datetimedepense->format('d/m/Y à H:i:s');

				if(($datetimedepenseform >= $debut) && ($datetimedepenseform <= $fin))
				{
					$depensetab2 .= '
						<tr>
							<td>'.$depense["designation"].'</td>
							<td>'.$depense["quantite"].'</td>
							<td>'.Tools::displayPrice($depense["total"]).'</td>
							<td>'.$depense["motif"].'</td>					
							<td>'.$datetimedepenseform2.'</td>
						</tr>
					';
					$totaldepense+=(int)$depense["total"];
				}
			}

			$solde = $totalvente - $totaldepense;

			$smarty->assign(array(
				'debut' => Tools::getValue('date_depart'),
				'fin' => Tools::getValue('date_fin'),
				'solde' => $solde
			));
		}

		$smarty->assign(array(
			'errors' => $this->errors,
			'valid' => Tools::isSubmit('valid') ? $this->l('Opération réussie') : false,
			'ventetab2' => $ventetab2,
			'totalvente' => $totalvente,
			'totalventesalon' => $totalventesalon,
			'totalventeboisson' => $totalventeboisson,
			'depensetab2' => $depensetab2,
			'totaldepense' => $totaldepense,
					
			'articles' => $articles,
			'total_articles' => $total_articles
		));

		return $this->display(__FILE__, 'stat.tpl');
	}

	public function venteData()
	{
		global $smarty, $cookie, $controller;

		$data = array();
		$dates = array();
		$totalligne = array();
		$datesdep = array();
		$totaldep = array();
		$json = array();
		
		$ventes = Vente::getVentes();
		$depenses = Depense::getDepenses();
		
		foreach($ventes as $vente)
		{
			$dateadd = new DateTime($vente->date_add);
			$dateaddform = $dateadd->format('d/m/Y');

			$dates[] = $dateaddform;
			$totalligne[] = $vente->totalligne;
		}

		foreach($depenses as $depense)
		{
			$dateadd2 = new DateTime($depense->date_add);
			$dateaddform2 = $dateadd2->format('d/m/Y');

			$datesdep[] = $dateaddform2;
			$totaldep[] = $depense->total;
		}

		$nbdata = count ($data);

		$json['dates'] =  $dates;
	   	$json['totalligne'] = $totalligne;
	   	$json['datesdep'] = $datesdep;
	   	$json['totaldep'] = $totaldep;

		echo json_encode($json);
	}

public function AddVenteAjax()
	{
		global $smarty, $cookie, $controller;

		$data = array();
		
		$json = array();

		//var_dump($_POST);
		//exit;

			$aimprimer ="";
			$aimprimer .='
				<style type="text/css" media="screen">
					#aimprim{
						text-align:center;
					}
					#aimprim tr td,
					#aimprim tr th{
						width:25%
					}
				</style>
				<br>

				<form method="post" action="#" id="printJS-form" class="w-100">
				<table id="aimprim">
					<thead>
						
					</thead>
					<tbody>						
			';

			setlocale (LC_TIME, 'fr_FR');

			$ids = array();

			$ids = $_POST['ids'];

			$noms = $_POST['noms'];
			$pu = $_POST['pu'];
			$qte = $_POST['qte'];
			$totalligne = $_POST['totalligne'];
			$totalachat = $_POST['totalachat'];
			$reduction = $_POST['reduction'];
			$netapayer = $_POST['netapayer'];
			$espece = $_POST['espece'];
			$rendu = $_POST['rendu'];
			$iduser = (int)$_POST['iduser'];
			$prestataire = $_POST['prestataire'];
			$nomclient = $_POST['nomclient'];

			$datejour = strftime("%A %d %B %G, %H:%M:%S");

			$last_id_cmd = Db::getInstance()->getValue('
				SELECT max(id_commande)
				FROM `vente`
			');
			$last_id_cmd = (int)$last_id_cmd+1;
			$vente = new Vente();

			for($i=0; $i<count($ids); $i++)
			{
				$aimprimer .='
				<tr>
					<td>'.$qte[$i].'</td>
					<td>'.$noms[$i].'</td>
					<td>'.$pu[$i].'</td>
					<td>'.$totalligne[$i].'</td>
				</tr>
			';

				$vente->id_commande = $last_id_cmd;
				$vente->id_article = $ids[$i];
				$vente->pu = $pu[$i];
				$vente->quantite = $qte[$i];
				$vente->totalligne = $totalligne[$i];
				$vente->totalachat = $totalachat;
				$vente->reduction = $reduction;
				$vente->netapayer = $netapayer;
				$vente->espece = $espece;
				$vente->rendu = $rendu;
				$vente->id_user_ad = $iduser;
				$vente->prestataire = $prestataire;
				$vente->nomclient = $nomclient;

				$vente->add();
			}
			$aimprimer .='
				</tbody>
				<tfoot>
					<tr style="height:30px">&nbsp;</tr>
					<tr>
						<td></td>
						<td></td>
						<td>Total</td>
						<td>'.$totalachat.'</td>
					</tr>
					<tr>
						<td></td>
						<td></td>
						<td>Réduction</td>
						<td>'.$reduction.'</td>
					</tr>
					<tr>
						<td></td>
						<td></td>
						<td>Net à payer</td>
						<td>'.$netapayer.'</td>
					</tr>
					<tr>
						<td></td>
						<td></td>
						<td>Espèce</td>
						<td>'.$espece.'</td>
					</tr>
					<tr>
						<td></td>
						<td></td>
						<td>Rendu</td>
						<td>'.$rendu.'</td>
					</tr>
					<tr style="height:30px">&nbsp;</tr>
					<tr>
						<td colspan="4" style="text-align:left;font-size:15px">Employé : '.$prestataire.'</td>
					</tr>
					<tr>
						<td colspan="4" style="text-align:left;font-size:15px">Client : '.$nomclient.'</td>
					</tr>
					<tr style="height:30px">&nbsp;</tr>
					<tr>
						<td colspan="4"><i>Merci et à bientôt !!!</i></td>
					</tr>
				</tfoot>
				</table>
				</form>
			';

		$json['aimprimer'] =  $aimprimer;

		echo json_encode($json);
	}
	
	//-----Fonction permettant l'indentation d'un fichier xml-----
	public function indentXml($xml){
		$xmlDoc = new DOMDocument();

		$xmlDoc->load($xml);
		$xmlDoc->preserveWhiteSpace = false;
		$xmlDoc->formatOutput = true;
		$xmlDoc->save($xml);
	}
	
	public function lectureCodeSource($url){
		if ($handle = @fopen($url, "rb")) {
			 if ($contents = stream_get_contents($handle)){
				   //$contents=htmlentities($contents);
				   return $contents;
			 }else{ return false;}
		}else { return false;}
		fclose($handle);
	}

	public function getCollection()
	{
		global $smarty, $cookie, $controller;

		$json = array();
		$where = array();
		
		if(Tools::isSubmit('mat')) {

			$articles = "";
			
			$mat = Tools::getValue('mat');
			
			$reqArticle = Article::getArticles();
			
			$where[] = '`active` = 1';
			
			if($mat != "")
				$where[] = '`matricule_article` like "%'.$mat.'%"';

			foreach($where as $query)
			{
				$reqArticle->where($query);
			}
			foreach($reqArticle as $result)
			{
				$num = (int)$result->id_article - 1;
				$articles .= '<tr>
					<td></td>
					<td><a href="https://www.epbomi-ci.com/'.$result->id_article.'-16--"><img class="img-responsive" width="25px" src="https://www.epbomi-ci.com/modules/immo/images/'.$result->matricule_article.'-'.$num.'.jpg" alt="" id="bigpic" /></a>
					</td>
            		<td><a href="https://www.epbomi-ci.com/'.$result->id_article.'-16--"" title="Détails">'.$result->matricule_article.'</a>
            		</td>
            		<td><a href="https://www.epbomi-ci.com/'.$result->id_article.'-16--"" title="Détails">'.$result->nom_article.' '.$result->prenom_article.'</a>
            		</td>                       
				</tr>';
    		}
			
			$nbarticle = count ($reqArticle);	
			$json['nbarticle'][] =  $nbarticle;
	   		$json['articles'][] = $articles;
			
		}
		echo json_encode($json);
	}
}

