(function($){
	$.fn.slideshowleft = function(options){
		var defaults = {
			width: 						210,
			height: 					150,
			thumbnail_visible: 			4,
			effect: 					'random', // Specify sets like: 'fold,fade,sliceDown'
			slices: 					15, // For slice animations
			boxCols: 					8, // For box animations
			boxRows: 					4, // For box animations
			animSpeed: 					300, // Slide transition speed
			pauseTime: 					3000, // How long each slide will show
			startSlide: 				0, // Set starting Slide (0 index)
			directionNav: 				true, // Next & Prev navigation
			directionNavHide: 			true, // Only show on hover
			controlNav: 				true, // 1,2,3... navigation
			controlNavThumbs: 			false, // Use thumbnails for Control Nav
			controlNavThumbsFromRel: 	false, // Use image rel for thumbs
			controlNavThumbsSearch: 	'.jpg', // Replace this with...
			controlNavThumbsReplace: 	'_thumb.jpg', // ...this in thumb Image src
			keyboardNav: 				true, // Use left & right arrows
			pauseOnHover: 				true, // Stop animation while hovering
			manualAdvance: 				false, // Force manual transitions
			captionOpacity: 			0.8, // Universal caption opacity
			prevText: 					'Prev', // Prev directionNav text
			nextText: 					'Next', // Next directionNav text
			randomStart: 				false, // Start on a random slide
			/*beforeChange: 			function(){}, // Triggers before a slide transition
			afterChange: 				function(){}, // Triggers after a slide transition
			slideshowEnd: 				function(){}, // Triggers after all slides have been shown
			lastSlide: 					function(){}, // Triggers when last slide is shown
			afterLoad: 					function(){} // Triggers when slider has loaded*/
			nav_style:					21,
			nav_style_width:			36,
			nav_style_height:			35,
			controlnav_style:			21,
			controlnav_style_width:		36,
			controlnav_style_height:	35
		};
		
		//On fusionne nos deux objets
		var options = $.extend(defaults, options);
		
		return this.each(function() {
			var o = options;	
			var obj = $(this);
			
			$(obj).css({
				'width' : o.width+'px'
			});
			
			$('.nivoSlider', obj).nivoSlider(options).css({
				'width' : o.width+'px',
				'height' : o.height+'px'
			});
			
			if(o.directionNav)
			{
				$('.nivo-directionNav a', obj).css({
					'width': o.nav_style_width+'px',
					'height': o.nav_style_height+'px'
				});
				
				$('a.nivo-nextNav', obj).css({
					'background' : 'url(modules/immo/btn_prevnext/'+o.nav_style+'_btn_next.png) top center no-repeat'
				});
				
				$('a.nivo-prevNav', obj).css({
					'background' : 'url(modules/immo/btn_prevnext/'+o.nav_style+'_btn_prev.png) top center no-repeat'
				});
			}
			
			if(o.controlNavThumbs)
			{
				$('.controlnav-thumbs .nivo-controlNav', obj).wrap('<div class="nivo-controlNavWrapper" />');
				$('.controlnav-thumbs .nivo-controlNavWrapper', obj).append('<a class="nivo-control-arrow left" />');
				$('.controlnav-thumbs .nivo-controlNavWrapper', obj).append('<a class="nivo-control-arrow right" />');
				$('.controlnav-thumbs .nivo-controlNav .nivo-control', obj).wrapAll('<div class="nivo-controlNavThumbs" />');
				
				var thumbs = $('.nivo-controlNav .nivo-controlNavThumbs a', obj);
				var current_thumb = 0;
				
				var nbThumbs = o.thumbnail_visible;
				var length = thumbs.length;
				
				var thumb_width = o.thumb_width + nbPixel(thumbs.css('margin-left')) + nbPixel(thumbs.css('margin-right')) + nbPixel(thumbs.css('border-left-width')) + nbPixel(thumbs.css('border-right-width'));
				
				var thumb_height = o.thumb_height + nbPixel(thumbs.css('margin-top')) + nbPixel(thumbs.css('margin-bottom')) + nbPixel(thumbs.css('border-top-width')) + nbPixel(thumbs.css('border-bottom-width'));
				
				var widthControlNav = (length < nbThumbs ? length : nbThumbs) * thumb_width;
				
				var overflowThumbs = length - nbThumbs;
				
				$('.controlnav-thumbs', obj).css({
					'margin-bottom' : (thumb_height+25)+'px'
				});
				
				$('.controlnav-thumbs .nivo-controlNavWrapper', obj).css({
					'width' : o.width+'px',
					'bottom' : -(thumb_height+15)+'px'
				});
				
				$('.controlnav-thumbs .nivo-controlNav', obj).css({
					'height' : thumb_height+'px',
					'width' : widthControlNav+'px'
				});
				
				$('.nivo-controlNav', obj).css({
					'height' : thumb_height+'px',
					'width' : widthControlNav+'px'
				});
				
				if(length <= nbThumbs )
					$('.controlnav-thumbs .nivo-controlNavWrapper .nivo-control-arrow', obj).hide();
				
				$('.controlnav-thumbs .nivo-controlNavWrapper .nivo-control-arrow', obj).css({
					'width': o.controlnav_style_width+'px',
					'height': o.controlnav_style_height+'px',
					'top': '50%',
					'margin-top': -(o.nav_style_height/2)+'px'
				});
				
				$('.controlnav-thumbs .nivo-controlNavWrapper .nivo-control-arrow.left', obj).css({
					'background' : 'url(modules/immo/btn_prevnext/'+o.controlnav_style+'_btn_prev.png) top center no-repeat'
				});
				
				$('.controlnav-thumbs .nivo-controlNavWrapper .nivo-control-arrow.right', obj).css({
					'background' : 'url(modules/immo/btn_prevnext/'+o.controlnav_style+'_btn_next.png)'
				});
				
				$('.controlnav-thumbs .nivo-control-arrow', obj).click(function(){
					$(this).hasClass('right') ? slideThumbsRight() : slideThumbsLeft();
					return false;
				});
					
				function slideThumbsRight()
				{
					if(overflowThumbs > current_thumb)
					{
						var margin = (current_thumb * thumb_width * -1) + (-1 * thumb_width);
						$('.nivo-controlNavThumbs', obj).stop().animate({'margin-left' : margin+'px'}, 200);
						current_thumb++;
					}
				}

				function slideThumbsLeft()
				{
					if(current_thumb > 0)
					{
						var margin = (current_thumb * thumb_width * -1) + thumb_width;
						$('.nivo-controlNavThumbs', obj).stop().animate({'margin-left' : margin+'px'}, 200);
						current_thumb--;
					}
				}
			}
		});
	}
})(jQuery);