<?php
require_once(dirname(__FILE__).'/SlideshowleftClass.php');
require_once(dirname(__FILE__).'/AdminSlideshowleft.php');

class Slideshowleft extends Module
{
	
	public function __construct($id = false)
	{
		$this->name = 'slideshowleft';
		$this->category = 'Diaporama';
		$this->visible = true;
		$this->requiredId = true;
		$this->version = 1.0;
		$this->error = false;
		$this->valid = false;
		$this->adminTab = 'AdminSlideshowleft';
		
		parent::__construct();
		
		$this->displayName = 'Diaporama';
		$this->description = 'Affiche un diaporama dans une colonne';
		
		if($id)
		{
			$this->id = $id;
			$this->name.= '='.$id;
		}
	}
	
	public function getInfos()
	{
		$slideshowleft = new SlideshowleftClass($this->id, 'fr');
		$this->displayName .= ' : '.$slideshowleft->name;
	}
	
	public function install()
	{
		if(parent::install())
		{
			$hook = 'LEFT_COLUMN';
			foreach(SlideshowleftClass::getList() as $slideshowleft)
				Module::registerModuleHook($hook, $this->name.'='.$slideshowleft['id']);
			return true;
		}
	}
	
	public function uninstall()
	{
		if(parent::uninstall())
		{
			foreach(SlideshowleftClass::getList() as $slideshowleft)
				Module::removeModuleHooks($this->name.'='.$slideshowleft['id']);
			return true;
		}
	}
	
	public function display_LEFT_COLUMN()
	{
		if($this->id)
		{
			global $smarty, $cookie;
			
			Module::$CSS['nivo-slider'] = $this->_path.'nivo-slider.css';
			Module::$CSS['theme-nivo-slider-default'] = $this->_path.'themes/default/default.css';
			Module::$JS['jquery.nivo.slider'] = $this->_path.'jquery.nivo.slider.pack.js';
			Module::$JS['slideshowleft'] = $this->_path.'slideshowleft.js';
			
			Module::$CSSSmartphone['nivo-slider'] = $this->_path.'nivo-slider.css';
			Module::$CSSSmartphone['theme-nivo-slider-default'] = $this->_path.'themes/default/default.css';
			Module::$JSSmartphone['jquery.nivo.slider'] = $this->_path.'jquery.nivo.slider.pack.js';
			Module::$JSSmartphone['slideshowleft'] = $this->_path.'slideshowleft.js';
			
			$slideshowleft = new SlideshowleftClass($this->id, $cookie->lang);
			
			if($slideshowleft->images)
			{
				$smarty->assign(array(
					'slideshowleft' => $slideshowleft));
				return $this->display(__FILE__, 'slideshowleft.tpl');
			}
		}
	}
	
	
	public function display_RIGHT_COLUMN()
	{
		return $this->display_LEFT_COLUMN();
	}
	
	
	
}