<?php
class AdminPrivateAccess extends AdminTab
{
	private $instanceModule;
	
	public function postProcess()
	{
		$this->instanceModule = new PrivateAccess();
		
		if(Tools::isSubmit('submitAddPrivateAccess'))
		{
			$this->instanceModule->setPrivateContent();
			Tools::redirectAdmin(self::$currentIndex.'&conf=4');
		}
		
		if(Tools::isSubmit('submitAddPrivateUser'))
		{
			$loginu = Tools::getValue('loginu');
			$passwordu = Tools::getValue('passwordu');
			$type = Tools::getValue('type');
			
			if(Tools::isSubmit('id_user') && $this->instanceModule->getUser(Tools::getValue('id_user')))
			{
				if($this->instanceModule->updateUser(Tools::getValue('id_user'), $loginu, $passwordu, $type))
					Tools::redirectAdmin(self::$currentIndex.'&id_user='.Tools::getValue('id_user').'&conf=4');
			}
			else
			{
				$id = $this->instanceModule->addUser($loginu, $passwordu, $type);
				if($id)
					Tools::redirectAdmin(self::$currentIndex.'&id_user='.$id.'&conf=3');
			}
		}
		
		if(Tools::isSubmit('submitDeletePrivateUser'))
		{
			if(Tools::isSubmit('id_user') && $this->instanceModule->getUser((int)Tools::getValue('id_user')))
			{
				if($this->instanceModule->deleteUser((int)Tools::getValue('id_user')))
					Tools::redirectAdmin(self::$currentIndex.'&conf=1');
			}
		}
	}
	
	public function display()
	{
		if(Tools::isSubmit('addUser') || Tools::isSubmit('id_user'))
			echo $this->displayUser();
		else
		{
			echo $this->displayUsers();
			echo $this->displayConfiguration();
		}
	}
	
	private function displayUser()
	{
		$user = Tools::isSubmit('id_user') ? $this->instanceModule->getUser(Tools::getValue('id_user')) : false;
		
		$loginu = $user ? $user->loginu : Tools::getValue('loginu');
		$passwordu = $user ? $user->passwordu : Tools::getValue('passwordu');
		$type = $user ? $user->type : Tools::getValue('type');
		
		$txt = '<h2>Utilisateur</h2>';
		
		if($user['id'])
			$txt .= '<script type="text/javascript">
			
			$(function(){

				$(".confirm").on(\'click\', function(){
					$("#dialog-confirm").html("<p>Êtes-vous sur de vouloir supprimer cet utilisateur ?</p>");
					$("#dialog-confirm").dialog({
						resizable: false,
						height: 150,
						modal: true,
						title: "Suppression",
						buttons: {
							Oui: function(){
								location.href = \''.self::$currentIndex.'&submitDeletePrivateUser&id_user='.$user['id'].'\';
							},
							Non: function(){
								$("#dialog-confirm").dialog("close");
							}
						}
					});	
				});
				
				});
			</script>';
		
		$txt .= '<form action="'.self::$currentIndex.($user['id'] ? '&id_user='.$user['id'] : '').'" method="post">';
		
		$txt .= '<label class="label" for="loginu">Utilisateur : </label>
					<div class="margin-form"><input type="text" name="loginu" id="loginu" value="'.$loginu.'" /></div>';
					
		$txt .= '<label class="label" for="passwordu">Mot de passe : </label>
					<div class="margin-form"><input type="text" name="passwordu" id="passwordu" value="'.$passwordu.'" /></div>';
		$txt .= '<label class="label" for="type">Type : </label>
					<div class="margin-form">
					<select name="type" id="type" class="">
				<option value="">Niveau d\'accès</option>
				<option value="Admin"'.($type == "Admin" ? ' selected="selected"' : '').'>Admin</option>
				<option value="Enregistreur"'.($type == "Enregistreur" ? ' selected="selected"' : '').'>Enregistreur</option>
			</select>
					</div>';

		return $txt .= '<div class="margin-form"><button type="submit" class="button save" name="submitAddPrivateUser">Enregistrer</button>&nbsp;&nbsp;&nbsp;&nbsp;'.($user['id']  ? '<a type="button" class="confirm button delete">Supprimer</a>' : '').'</form>';
	}
	
	private function displayUsers()
	{
		$txt = '<h2>Utilisateurs</h2>';
		$txt .= '<a style="vertical-align:bottom" href="'.self::$currentIndex.'&addUser"><img src="'._KAM_URI_.'img/add.gif" border="0" /> Ajouter</a><br /><br />';
		$users = $this->instanceModule->getUsersList();
		if($users)
		{
			$txt .= '
				<table class="table">
					<tr>
						<th style="width:24px;">Id</th>
						<th>Utilisateur</th>
						<th>Mot de passe</th>
						<th>Type</th>
						<th style="width:30px;">Action</th>
					</tr>';
			$irow = 0;
			foreach($users as $user)
			{
				$onclick = 'onclick="document.location =\''.self::$currentIndex.'&id_user='.$user['id'].'\'"';
				$txt .= '<tr'.($irow++ % 2 ? ' class="alt_row"' : '').'>';
				
				$txt .= '<td '.$onclick.'>'.$user['id'].'</td>';
				$txt .= '<td '.$onclick.'>'.$user->loginu.'</td>';
				$txt .= '<td '.$onclick.'>'.$user->passwordu.'</td>';
				$txt .= '<td '.$onclick.'>'.$user->type.'</td>';
				$txt .= '<td style="text-align:center;"><a href="'.self::$currentIndex.'&id_user='.$user['id'].'&deleteUser"><img src="img/delete.gif" alt="Supprimer" title="Supprimer" /></a></td>';
				
				$txt .= '</tr>';
			}
			$txt .= '</table>';
		}
		else
			$txt .= 'Aucun résultat';

		return $txt.'<div style="margin:10px">&nbsp;</div>';
	}
	
	private function displayConfiguration()
	{
		global $listLang;
		
		$txt = '<h2>Contenu restreint</h2>';
		$txt .= $this->displayFlags();
		$txt .= '
			<script type="text/javascript">
				$(function(){
					setupMCEBack();
				});
			</script>
		<form action="'.self::$currentIndex.'" method="post">';
		foreach($listLang as $lang)
		{
			$imgFlag = '&nbsp;<img src="img/lang/'.$lang.'.gif" />';
			$txt .= '<div class="display '.$lang.'">';
			$txt .= '<textarea name="content_'.$lang.'" class="editor">'.$this->instanceModule->getPrivateContent($lang).'</textarea>';
			$txt .= '</div>';
		}

		return $txt .= '<div class="margin-form"><button type="submit" class="button save" name="submitAddPrivateAccess">Enregistrer</button></form>';
	}
}