<?php
define('_FILE_PRIVATEACCESS_', dirname(__FILE__).'/privateaccess.xml');
require_once(dirname(__FILE__).'/AdminPrivateAccess.php');
require_once(_MODULES_DIR_.'immo/User_Ad.php');

class PrivateAccess extends Module
{
	private $xml;
	
	public function __construct()
	{
		$this->name = 'privateaccess';
		$this->hook = 'NOT_ASSIGN';
		$this->category = 'Front Office';
		$this->visible = false;
		$this->version = 1.1;
		//$this->adminTab = 'AdminPrivateAccess';
		parent::__construct();
		$this->displayName = 'Accès privé';
		$this->description = 'Page au contenu restreint pour chaque utilisateur';
		$this->picto = 'picto.png';
		$this->instanceXML();
	}
	
	private function instanceXML()
	{
		$this->xml = new SimpleDOM(_FILE_PRIVATEACCESS_ , NULL, true);
	}
	
	public function getFront()
	{
		
		session_start();
		
		global $smarty, $cookie;
		
		if(!isset($_SESSION['privateaccess']))
	{
		$_SESSION['privateaccess']=	false;
	}	
		
		
		Module::$CSS[] = $this->_path.'privateaccess.css';

		if(Tools::isSubmit('submitConnection'))
		{	
			
			
			$error = false;
			
			$loginu = Tools::getValue('loginu');
			$passwordu = Tools::getValue('passwordu');
			$name = Tools::getValue('name');
			$type = Tools::getValue('type');
			
			if(empty($loginu) || empty($passwordu))
				$error = true;
			
			if(!$error && $user = $this->connection($loginu, $passwordu))
			{
				$cookie->privateaccess = $user['0']['id_user_ad'];
				$_SESSION['privateaccess'] = $user['0']['id_user_ad'];
			}
				
		}
		
		if(Tools::isSubmit('logout'))
		{
			session_unset();
			$_SESSION['privateaccess']=	false;
		}
		
		$smarty->assign(array(
			'logged' => $_SESSION['privateaccess'] ? $_SESSION['privateaccess'] : false,
			'user' => $_SESSION['privateaccess'] ? User_Ad::getUserInfosByid($_SESSION['privateaccess'], $cookie->lang) : false,
			'content' => $this->getPrivateContent($cookie->lang)));
		
 	 	return $this->display(__FILE__, 'privateaccess.tpl');
	}
	
	public function connection($loginu, $passwordu)
	{
		global $smarty, $cookie;
				
		$user = User_Ad::getUserByInfos($loginu, $passwordu, $cookie->lang);
		if($user)
			return $user;
		
		return false;
	}
	
	public function getPrivateContent($lang)
	{
		return $this->xml->content->{$lang};
	}
	
	public function setPrivateContent()
	{
		global $listLang;
		
		foreach($listLang as $lang)
			$this->xml->content->{$lang} = Tools::htmlentitiesUTF8(Tools::stripslashes(Tools::getValue('content_'.$lang)));
		
		$this->xml->asXML(_FILE_PRIVATEACCESS_);
	}
	
	public function getUsersList()
	{
		return $this->xml->xpath("//users/user");
	}
	
	public function getUser($id)
	{
		$user = $this->xml->xpath("//users/user[@id=".$id."]");
		if($user)
			return $user[0];
		return false;
	}
	
	public function updateUser($id, $loginu, $passwordu, $name, $type)
	{
		$updateUser = $this->getUser($id);

		$updateUser->loginu = $loginu;
		$updateUser->passwordu = $passwordu;
		$updateUser->name = $name;
		$updateUser->type = $type;
		
		return $this->xml->asXML(_FILE_PRIVATEACCESS_);
	}
	
	public function addUser($loginu, $passwordu, $name, $type)
	{
		$newUser = $this->xml->users->addChild('user');
		
		$newUser['id'] = $this->nextIdXML();
		$newUser->addChild('loginu', $loginu);
		$newUser->addChild('passwordu', $passwordu);
		$newUser->addChild('name', $name);
		$newUser->addChild('type', $type);
		
		if($this->xml->asXML(_FILE_PRIVATEACCESS_))
		{
			mkdir(dirname(__FILE__).'/docs/'.$newUser['id'], 0775);
			return $newUser['id'];
		}
		return false;
	}
	
	
	public function addUser2($loginu, $passwordu, $name, $statut)
	{
		$newUser = $this->xml->users->addChild('user');
		
		$newUser['id'] = $this->nextIdXML();
		$newUser->addChild('name', $name);
		$newUser->addChild('loginu', $loginu);
		$newUser->addChild('passwordu', $passwordu);
		$newUser['statut'] = $statut;
		
		if($this->xml->asXML(_FILE_PRIVATEACCESS_))
		{
			return $newUser['id'];
		}
		return false;
	}
	
	
	public function addTypeUser($id_user, $loginu, $passwordu, $name, $statut)
	{
		$newUser = $this->xml->users->addChild('user');
		
		$newUser['id'] = $id_user;
		$newUser->addChild('name', $name);
		$newUser->addChild('loginu', $loginu);
		$newUser->addChild('passwordu', $passwordu);
		$newUser['statut'] = $statut;		
		
		if($this->xml->asXML(_FILE_PRIVATEACCESS_))
		{
			return $newUser['id'];
		}
		return false;
	}
	
	
	
	public function updateTypeUser($id_user, $loginu, $passwordu, $name, $statut)
	{
		$updateUser = $this->getUser($id_user);

		$updateUser->loginu = $loginu;
		$updateUser->passwordu = $passwordu;
		$updateUser->name = $name;
		$updateUser['statut'] = $statut;
				
		return $this->xml->asXML(_FILE_PRIVATEACCESS_);
	}
	
	
	public function updateTypeUserStatut($id_user,$statut)
	{
		$updateUser = $this->getUser($id_user);
		$updateUser['statut'] = $statut;	
				
		return $this->xml->asXML(_FILE_PRIVATEACCESS_);
	}
	
	public function deleteUser($id)
	{
		$deleteUser = $this->xml->getElementById((string)$id);
		$deleteUser->deleteSelf();		
		
		return $this->xml->asXML(_FILE_PRIVATEACCESS_);
	}
	
	protected function nextIdXML()
	{
		$elements = $this->xml->xpath("//users/user");
		if(count($elements) == 0)
			return 1;
		$list_id = array();
		foreach($elements as $element)
			$list_id[] = (int)$element['id'];
		return max($list_id)+1;
	}

	public function display_PRIVATEACCESS()
	{
 	 	return $this->getFront();
	}
	
	
}