<?php
class Gallery extends ObjectModel
{	
	public static $xml = _FILE_GALLERIES_;
	
	protected $table = 'gallery';
	
	public $name;
	
	public $path;
	
	public $uri;
	
	public $files = array();

	public $sub; // sous-dossier
	
	protected $fieldsRequired = array(
		'name');
		
	protected $fieldsValidate = array(
		'name' => 'isLinkRewrite',
		'sub' => 'isBool');
		
	protected function getFieldsWithSimpleDOM($id = false, $lang = false)
	{
		if(parent::getFieldsWithSimpleDOM($id, $lang))
		{
		
			if ((string)$this->sub) {
				if (self::getParent($this->name)) {
					$parentName = self::getParent($this->name)->name;

					$this->path = _GALLERIES_DIR_.$parentName.'/'.$this->name.'/';
					$this->uri = _BASE_URI_GALLERIES_.$parentName.'/'.$this->name.'/';
				}
			}
			else {
				$this->path = _GALLERIES_DIR_.$this->name.'/';
				$this->uri = _BASE_URI_GALLERIES_.$this->name.'/';
			}
			
			foreach (glob($this->path.'*') as $pathFile) 
			{
				$file = array();
				
				$name = basename($pathFile);
				
				$file['name'] = $name;
				
				$file['path'] = $file;
				$file['uri'] = $this->uri.$name;
				
				$this->files[] = $file;
			}
			return true;
		}
		return false;
	}
	
	public function add($onthefly = false)
	{
		if(!is_dir(_GALLERIES_DIR_.$this->name))
		{
			if(parent::add()) {
				if (!$onthefly) {
					if ((string)$this->sub)
						return (mkdir($this->path.'/', 0775));
					else
						return (mkdir(_GALLERIES_DIR_.$this->name.'/', 0775));
				}
				else
					return true;
			}
			return false;
		}
		else
		{
			if (!(string)$this->sub)
				if(parent::add())
					return true;
		}
		return false;
	}
	
	public function update()
	{
		if(parent::update())
		{
			$old_path = $this->path;
			$old_name = basename($old_path);
			if ((string)$this->sub)
				$this->path = _GALLERIES_DIR_.self::getParent($old_name)->name.'/'.$this->name.'/';
			else
				$this->path = _GALLERIES_DIR_.$this->name.'/';

			if($old_path != $this->path)
				return rename($old_path, $this->path);
			return true;
		}
		return false;
	}
	
	public function delete()
	{
		if (!(string)$this->sub) {
	      $objects = self::getChild($this->name);
	      foreach ($objects as $object) {
	        if (is_dir($this->path.$object) && $object != "." && $object != ".." )
	        {
	          $asup = self::get($object);
	          $new = new Gallery($asup['id']);
	          $new->delete();
	        }
	      }
	    }

		if(parent::delete())
			return (rrmdir($this->path));
		return false;
	}
	
	public static function getList()
	{
		$xml = self::getXML();
		return $xml->sortedXPath('//gallery', '@id', SORT_ASC);
	}
	
	public function nbElementsReal()
	{
		$objects = scandir(_GALLERIES_DIR_.$this->name.'/');
		$list = array();
		foreach ($objects as $object) {
			if ($object != "." && $object != "..") 
				$list[] = $object;
		}
				
		return count($list);
	}

	public function nbElementsDisplayed()
	{
		if (is_dir($this->path)) {
			$objects = scandir($this->path);
			$list = array();
			if (!empty($objects))
				foreach ($objects as $object) {
					if ($object != "." && $object != "..")
						if ((is_dir($this->path.$object) && self::get($object)) || !is_dir($this->path.$object))
							$list[] = $object;
				}
			return count($list);
		}
	}
	
	public function deleteFile($file)
	{
		if(file_exists($this->path.$file)) {
			$tmp = array();
			$tmp = explode('.',$file);
			$filename = array_shift($tmp);
			return unlink($this->path.$file);
		}
		return false;
	}
	
	public function addFile()
	{
		global $_STATS;
		
		if($_STATS->sizePercent < 100)
		{

			$upload = new Upload();
			$result = $upload->handleUpload($this->path);

			if(isset($result['success']) && $result['success'])
				$validate = Upload::validateUpload($this->path.$result['filename']);
				
			if((isset($validate) && $validate) || (isset($result['error']) && $result['error'])) {
				
				if (isset($validate) && $validate) {
					$tmp = array();
					$tmp = explode('.',basename($this->path.$result['filename']));
					$filename = array_shift($tmp);
					$exist = false;
					foreach ($this->files as $file) {
						if ($this->path.$result['filename'] == $file['name'])
							$exist = true;
					}	
				}

				return htmlspecialchars(json_encode($result), ENT_NOQUOTES);
			}


			unlink($this->path.$result['filename']);
			return htmlspecialchars(json_encode(array('error' => 'Le fichier est de type invalide')), ENT_NOQUOTES);
		}
		else
			return htmlspecialchars(json_encode(array('error' => 'Vous avez dépassé votre cota autorisé')), ENT_NOQUOTES);
	}
	
	public function fileExist($file)
	{
		return file_exists($this->path.$file);
	}

	public static function get($toCompare) {
		$galleries = self::getList();
		foreach ($galleries as $gallery) {
			if ($gallery->name == $toCompare)
				return $gallery;
		}
		return false;
	}

	public static function getParent($folder) {
		$galleries = self::getList();
		if (!empty($galleries))
		{
			foreach ($galleries as $gallery) {
				if (is_dir(_GALLERIES_DIR_.$gallery->name)) {
					$objects = scandir(_GALLERIES_DIR_.$gallery->name.'/');
					if (!empty($objects)) {
						foreach ($objects as $object) {
							if ($object == $folder)
								return $gallery;
						}
					}
				}
			}
		}
		return false;
	}

	public function getChild($folder) {
		if (is_dir(_GALLERIES_DIR_.$folder))
			return scandir(_GALLERIES_DIR_.$folder.'/');
		return false;
	}
}