<?php
require_once(_SMARTY_DIR_.'Smarty.class.php');

global $smarty;

$smarty = new Smarty();
$smarty->template_dir 	= _THEME_DIR_;
$smarty->compile_dir 	= _SMARTY_DIR_.'compile/';
$smarty->cache_dir 		= _SITE_DIR_.'cache/';
$smarty->caching 		= !(bool)(int)Configuration::get('smarty_compil');
$smarty->force_compile	= !(bool)(int)Configuration::get('smarty_compil');
$smarty->compile_check 	= true;
$smarty->debugging		= false;
$smarty->debug_tpl		= _SMARTY_DIR_.'debug.tpl';

$smarty->assign(array(
	'tpl_dir' => $smarty->template_dir,
	'base_dir' => _BASE_URI_,
	'base_uri' => _URI_,
	'theme_dir' => _BASE_THEME_,
	'img_dir' => _BASE_URI_IMG_,
	'module_dir' => substr(_MODULES_DIR_, 0, -1))); //sans le slash final pour éviter des problèmes

/*
* Warning : 2 lines have been added to the Smarty class.
* "public $currentTemplate = null;" into the class itself
* "$this->currentTemplate = substr(basename($resource_name), 0, -4);" into the "display" method
*/

function smartyTranslate($params, &$smarty)
{
	global $cookie, $_MODULES, $_MODULE, $_GLOBALS, $_GLOBAL;

	$msg = false;
	if (!isset($params['mod'])) $params['mod'] = false;

	$string = str_replace('\'', '\\\'', $params['s']);
	$key = md5($string);
	if($params['mod'])
	{
		$translationsFile = _MODULES_DIR_.$params['mod'].'/'.$cookie->lang.'.php';
		Tools::file_exists_cache($translationsFile);
		$modKey = '<{'.$params['mod'].'}>'.$key;

		if(@include_once($translationsFile))
			$_MODULES = array_merge($_MODULES, $_MODULE);

		$msg = (is_array($_MODULES) AND key_exists($modKey, $_MODULES)) ? stripslashes($_MODULES[$modKey]) : $params['s'];
	}
	else
	{
		$translationsFile = _TRANSLATIONS_DIR_.$cookie->lang.'.php';
		Tools::file_exists_cache($translationsFile);

		$filename = ((!isset($smarty->compiler_object) || !is_object($smarty->compiler_object->template)) ? $smarty->template_resource : $smarty->compiler_object->template->getTemplateFilepath());
		$key = Tools::substr(basename($filename), 0, -4).'_'.md5($string);

		if(@include_once($translationsFile))
			$_GLOBALS = array_merge($_GLOBALS, $_GLOBAL);

		$msg = (is_array($_GLOBALS) AND key_exists($key, $_GLOBALS)) ? stripslashes($_GLOBALS[$key]) : $params['s'];
	}
	return($msg);
}
$smarty->registerPlugin('function','l', 'smartyTranslate');
