<?php
class AdminEmployee extends AdminTab
{
	public function __construct()
	{
		parent::__construct();
		
		$this->className = 'Employee';
		$this->table = 'employee';
		
		if(Tools::isSubmit('id_employee') && Tools::getValue('id_employee') == 1)
				Tools::redirectAdmin(self::$currentIndex);
		if(Tools::isSubmit('employee') && Tools::getValue('employee') == 1)
				Tools::redirectAdmin(self::$currentIndex);
	}
	
	public function postProcess()
	{
		global $kameleon_user;
		
		if($kameleon_user->isAdmin())
		{
			if(Tools::isSubmit('employee') && Tools::isSubmit('active'))
			{
				if(Tools::getValue('employee') != 1)
				{
					$employee = new Employee(Tools::getValue('employee'));
					if(Validate::isLoadedObject($employee))
					{
						$employee->active = Tools::getValue('active');
						if($employee->update())
							Tools::redirectAdmin(self::$currentIndex.'&conf=4');
					}
				}
			}
			
			if(Tools::isSubmit('sliderUser'))
			Configuration::updateValue('sliderUser',Tools::getValue('sliderUser'));
			
		
			
			parent::postProcess();	
		}
	}
	
	public function display()
	{
		global $kameleon_user;

		if($kameleon_user->isAdmin())
		{
			if((Tools::isSubmit('addemployee') || Tools::isSubmit('id_employee')))
				echo $this->displayForm();
			else
				echo $this->displayList();
		}
	}
	
	private function displayForm()
	{		
		if(!($employee = $this->loadObject(true))) return;

		$currentIndex = self::$currentIndex;
		if ($employee->id)
			$currentIndex .= '&id_employee='.$employee->id;
		
		$txt = '';
		
		if($employee->id)
		{
			$txt .= '
			<script type="text/javascript">
				$(function(){
					$(".confirm").click(function(){
						$("#dialog-confirm").html("<p>Êtes-vous sur de vouloir supprimer cet utilisateur ?</p>");
						$("#dialog-confirm").dialog({
							resizable: false,
							height: 150,
							modal: true,
							title: "Suppression",
							buttons: {
								Oui: function(){
									location.href = "'.$currentIndex.'&deleteEmployee";
								},
								Non: function(){
									$("#dialog-confirm").dialog("close");
								}
							}
						});
					});
					$("#sortable").sortable();
					$("#sortable").disableSelection();
				});
			</script>';
			$titre = 'Modifier un utilisateur';
		}
		else
			$titre = 'Créer un utilisateur';
		
		$txt .= '<legend class="legend">'.$titre.'</legend>';
			
		$txt .= '<form method="post" action="'.$currentIndex.'">';
		
		$txt .= '
		<label class="label">Activer :</label>
		<div class="margin-form">
			<input type="radio" name="active" id="active_on" value="1" '.($this->getFieldValue($employee, 'active') == 1 ? 'checked="checked"' : '').' />
			<label class="t" for="active_on"><img src="img/enabled.gif" alt="Activé" title="Activé"></label>
			<input type="radio" name="active" id="active_off" value="0" '.($this->getFieldValue($employee, 'active') == 0 ? 'checked="checked"' : '').' />
			<label class="t" for="active_off"><img src="img/disabled.gif" alt="Désactivé" title="Désactivé"></label>
		</div>';
		$txt .= '
		<label class="label">Gérer les diaporamas :</label>
		<div class="margin-form">
			<input type="radio" name="sliderUser" id="sliderUser_on" value="1" '.(Configuration::get('sliderUser') == 1 ? 'checked="checked"' : '').' />
			<label class="t" for="sliderUser_on"><img src="img/enabled.gif" alt="Activé" title="Activé"></label>
			<input type="radio" name="sliderUser" id="sliderUser_off" value="0" '.(Configuration::get('sliderUser') == 0 ? 'checked="checked"' : '').' />
			<label class="t" for="sliderUser_off"><img src="img/disabled.gif" alt="Désactivé" title="Désactivé"></label>&nbsp;&nbsp;<p class="info enligne">créer, greffer, modifier, supprimer un diaporama</p>
		</div>';
		$txt .= '<label class="label">Nom de l\'utilisateur : </label>
				<div class="margin-form"><input type="text" name="name" value="'.$this->getFieldValue($employee, 'name').'" /></div>';
				
		$txt .= '<label class="label">Identifiant de connexion : </label>
				<div class="margin-form"><input type="text" name="login" value="'.$this->getFieldValue($employee, 'login').'" /></div>';
				
		$txt .= '<label class="label">Mot de passe de connexion : </label>
				<div class="margin-form"><input type="text" id="code" name="password" value="'.$this->getFieldValue($employee, 'password').'" />
			<img src="img/new.gif" alt="" onClick="gencode(8);" style="cursor:pointer" /></div>';
		
		$profiles = Employee::$profiles;
		$txt .= '<label class="label" for="profile">Profil : </label>
				<div class="margin-form">
				<select name="profile" id="profile">';
					foreach($profiles as $id_profile => $profile)
						if($id_profile != 1)
							$txt .= '<option value="'.$id_profile.'"'.($this->getFieldValue($employee, 'profile') == $id_profile ? ' selected="selected"' : '').'>'.$profile.'</option>';
		$txt .= '</select></div>';
		
		
		
		
				
		$txt .= '<div class="margin-form"><button type="submit" class="button save" name="submitAddEmployee">Enregistrer</button>&nbsp;&nbsp;&nbsp;&nbsp;'.($employee->id  ? '<button type="button" class="confirm button delete">Supprimer</button>' : '').'</div></form>
		
		<p class="info">L\'utilisateur peut modifier les pages et a accès à la configuration de certains modules.<br />
		L\'utilisateur avancé peut en plus créer, modifier, supprimer des pages et gérer l\'arborescence.</p>';
		
		
		
		return $txt;
	}
	
	private function displayList()
	{
		$txt = '';/*<legend class="legend">Gestion des utilisateurs</legend>';*/
		
		$txt .= '
			<script type="text/javascript">
				$(function(){
					$(".confirm").click(function(){
					var href = $(this).attr("href");
						$("#dialog-confirm").html("<p>Êtes-vous sur de vouloir supprimer cet utilisateur ?</p>");
						$("#dialog-confirm").dialog({
							resizable: false,
							height: 150,
							modal: true,
							title: "Suppression",
							buttons: {
								Oui: function(){
									location.href = href;
								},
								Non: function(){
									$("#dialog-confirm").dialog("close");
								}
							}
						});
						return false;
					});
					$("#sortable").sortable();
					$("#sortable").disableSelection();
				});
			</script>';
		
		$txt .= $this->displayAddButton();
		
		$employees = Employee::getList();
		
		$profiles = Employee::$profiles;
		
		$txt .= '<h2>Liste des utilisateurs</h2>';
		if($employees)
		{
			$txt .= '<table class="table documents" cellpadding="0" cellspacing="0">
				<thead>
					<tr>
						<th>Id</th>
						<th>Nom</th>
						<th>Login</th>
						<th>Profil</th>
						<th>Mot de passe</th>
						<th style="text-align:center; width:20px">Activer</th>
						<th style="text-align:center; width:20px">Actions</th>
					</tr>
				</thead>
				<tbody>';
			$irow = 0;
			foreach($employees as $employee)
			{
				if($employee['id'] != 1)
				{
					$employee = new Employee($employee['id']);
					$onclick = 'onclick="document.location =\''.self::$currentIndex.'&id_employee='.$employee->id.'\'"';
					$txt .= '
					<tr'.($irow++ % 2 ? ' class="alt_row"' : '').'>
						<td '.$onclick.'>'.$employee->id.'</td>
						<td '.$onclick.'>'.$employee->name.'</td>
						<td '.$onclick.'>'.$employee->login.'</td>
						<td '.$onclick.'>'.$profiles[$employee->profile].'</td>
						<td '.$onclick.'>'.$employee->password.'</td>
						<td '.$onclick.' style="text-align:center;"><a href="'.self::$currentIndex.'&employee='.$employee->id.'&active='.($employee->active ? 0 : 1 ).'"><img src="img/'.($employee->active ? 'enabled' : 'disabled' ).'.gif" alt="" /></a></td>
						<td style="text-align:center"><a class="confirm" href="'.self::$currentIndex.'&id_employee='.$employee->id.'&deleteEmployee"><img src="img/delete.gif" alt="" /></a></td>
					</tr>';
				}
			}
		}
		else
			$txt .= 'Aucun résultat';
		
		$txt .= '</tbody></table>';
		
		return $txt;
	}
}