<?php
class AdminLogger extends AdminTab
{
	public function __construct()
	{
		parent::__construct();
		
		$this->className = 'Logger';
	}
	
	public function postProcess()
	{
	}
	
	public function display()
	{
		global $kameleon_user;
		
		if($kameleon_user->isAdmin())
		{
			$page = Tools::isSubmit('page') ? Tools::getvalue('page') : 1;
			$irow = 0;
			$logs = Logger::getList($page, 25, $nbPages);
			$txt = '';
				/*<legend class="legend">Historique</legend>';*/
				
			if($logs)
			{
				$pagination = '<ul class="pagination">';
				if($nbPages > 1)
				{
					if($page > 1)
						$pagination .= '<li><a href="'.self::$currentIndex.'&page='.($page-1).'" class="arrow"><</a></li>';
					for($i = 1; $i <= $nbPages; $i++)
						$pagination .= '<li><a href="'.self::$currentIndex.'&page='.$i.'"'.($i == $page ? ' class="selected"' : '').'>'.$i.'</a></li>';
					if($page < $nbPages)
						$pagination .= '<li><a href="'.self::$currentIndex.'&page='.($page+1).'" class="arrow">></a></li>';
				}
				$pagination .= '</ul>';
				
				
				$txt .= $pagination.'
				<table class="table" cellpadding="0" cellspacing="0">
				<thead>
					<tr>
						<th>ID</th>
						<th>Utilisateur</th>
						<th>Gravité 1-4</th>
						<th>Message</th>
						<th>Type de l\'objet</th>
						<th>ID de l\'objet</th>
						<th>Code d\'erreur</th>
						<th>Date</th>
					</tr>
				</thead>
				<tbody>';			
				foreach($logs as $log)
				{
					$txt .= '<tr'.($irow++ % 2 ? ' class="alt_row"' : '').'>
						<td>'.$log['id'].'</td>
						<td>'.$log->user.'</td>
						<td>'.$log->severity.'</td>
						<td>'.$log->message.'</td>
						<td>'.$log->object_type.'</td>
						<td>'.$log->object_id.'</td>
						<td>'.$log->error_code.'</td>
						<td>'.date('d/m/Y à H\hi',strtotime($log->date_add)).'</td>
					</tr>';
				}
				
				$txt .= '</tbody>
				</table>
				'.$pagination;
			}
			else
				 $txt .= '<p>Aucun résultat</p>';
				 
			echo $txt;
		}
	}
}