<?php
class AdminModules extends AdminTab
{
	public function postProcess()
	{
		global $kameleon_user;
		if($kameleon_user->isAdmin())
		{
			if(Tools::isSubmit('install'))
			{
				$module = Module::getInstanceByName(Tools::getvalue('install'));
				if(($result = $module->install())===true)
					Tools::redirectAdmin(self::$currentIndex.'&conf=12');
				$this->_errors[] = $result;
			}
			
			if(Tools::isSubmit('uninstall'))
			{
				$module = Module::getInstanceByName(Tools::getvalue('uninstall'));
				if(Tools::isSubmit('supprBase')){
					$suppr = Tools::getvalue('supprBase');
					if(($result = $module->uninstall($suppr))===true)
						Tools::redirectAdmin(self::$currentIndex.'&conf=13');
					$this->_errors[] = $result;
				}else{
					$module->uninstall();
					Tools::redirectAdmin(self::$currentIndex.'&conf=13');
				}
			}
			
			if(Tools::isSubmit('saveTranslation'))
			{
				$module = Module::getInstanceByName(Tools::getvalue('saveTranslation'));
				$module->saveTranslation();
				Tools::redirectAdmin(self::$currentIndex.'&position&conf=4&translate='.$module->name);
			}
			
			if(Tools::isSubmit('savePosition'))
			{
				Module::savePosition();
				Tools::redirectAdmin(self::$currentIndex.'&position&conf=4');
			}
			
			if(Tools::isSubmit('addModuleHook'))
			{
				if(Module::registerModuleHook(Tools::getvalue('hookName'), Tools::getvalue('moduleName')))
					Tools::redirectAdmin(self::$currentIndex.'&position&conf=16');
				$this->_errors[] = 'Module déjà présent dans ce point d\'accroche';
			}
			
			if(Tools::isSubmit('deleteModuleHook'))
			{
				Module::removeModuleHooks(Tools::getvalue('moduleName'), Tools::getvalue('hookName'));
				Tools::redirectAdmin(self::$currentIndex.'&position&conf=17');
			}
		}
	}
	
	public function displayAjax()
	{
		if(Tools::isSubmit('configure'))
			return $this->displayConfigure(Tools::getvalue('configure'), true);
	}
	
	public function display()
	{
		if(Tools::isSubmit('configure'))
			return $this->displayConfigure(Tools::getvalue('configure'));
		if(Tools::isSubmit('translate'))
			return $this->displayTranslate(Tools::getvalue('translate'));
		if(Tools::isSubmit('position'))
			return $this->displayPosition();
		return $this->displayList();
	}
	
	private function displayList()
	{
		global $kameleon_user;
		
		$txt = '
		<script type="text/javascript">
		$(function(){
			$(".confirm").click(function(){
				var module = $(this).attr(\'module\');
				
				$("#dialog-confirm").html("<p>Êtes-vous sur de vouloir désinstaller ce module ?</p>");
				$("#dialog-confirm").dialog({
					resizable: false,
					height: 150,
					modal: true,
					title: "Désinstaller",
					buttons: {
						Oui: function(){
							if(module=="immo" || module=="offreEmploi"){
								$("#dialog-confirm").dialog("close");
								demandeViderBase(module);
							}
							else
								location.href = "'.self::$currentIndex.'&uninstall="+module;
						},
						Non: function(){
							$("#dialog-confirm").dialog("close");
						}
					}
				});
			});
		});
		function demandeViderBase(module){
			$("#dialog-confirm").html("<p>Voulez-vous vider la base ?</p>");
			$("#dialog-confirm").dialog({
				resizable: false,
				height: 150,
				modal: true,
				title: "Suppression",
				buttons: {
					Oui: function(){
						location.href = "'.self::$currentIndex.'&uninstall="+module+"&supprBase=true";
					},
					Non: function(){
						location.href = "'.self::$currentIndex.'&uninstall="+module+"&supprBase=false";
					}
				}
			});
		}
		</script>';
		
		$txt .= '';/*<legend class="legend">Liste des modules</legend>';	*/
		
		if($kameleon_user->isAdmin())
		{
			$txt .= '<div class="margin-form"><br/><a href="'.self::$currentIndex.'&position" class="button"><img src="img/settingswhite.png" style="margin-right:7px"/>Gérer la position des modules</a></div>
			<h2>Installé</h2>';
			foreach(Module::getList(true) as $category => $modules)
			{
				$txt .= '<div class="header_module">'.$category.'</div>
					<ul class="listModule">';
				foreach($modules as $module)
					$txt .= '<li><div class="moduleLeft"><b>'.($module->picto ? ('<img src="'._BASE_URI_.'modules/'.$module->name.'/'.$module->picto.'" />') :'').$module->displayName.'</b> v'.number_format($module->version,1).'
					<p>'.$module->description.'</p></div>
					<div class="moduleRight">
					'.($module->isInstall() ? '<a class="button traduction" href="'.self::$currentIndex.'&translate='.$module->name.'">Traduction</a>' : '' ).'
					'.($module->isInstall() ? (method_exists($module, 'getContent') ||  property_exists($module, 'adminTab') ? '
					<a class="button configurer" href="'.self::$currentIndex.'&configure='.$module->name.'">Configurer</a>' : '').'
					<a class="confirm button delete" module="'.$module->name.'">Désinstaller</a>' : '<a class="button save" href="'.self::$currentIndex.'&install='.$module->name.'">Installer</a>' ).'
					</div><div class="clear"></div></li>';
				$txt .= '</ul>';
			}
			$txt .= '<h2 style="margin-top:60px">Non installé</h2>';
			foreach(Module::getList() as $category => $modules)
			{
				$txt .= '<div class="header_module">'.$category.'</div>
					<ul class="listModule">';
				foreach($modules as $module)
				{
					$txt .= '<li><div class="moduleLeft"><b>'.($module->picto ? ('<img src="'._BASE_URI_.'modules/'.$module->name.'/'.$module->picto.'" />') :'').$module->displayName.'</b> v'.number_format($module->version,1).'
					<p>'.$module->description.'</p></div>
					<div class="moduleRight">
					'.($module->isInstall() ? '<a class="button" href="'.self::$currentIndex.'&translate='.$module->name.'">Traduction</a>' : '' ).'
					'.($module->isInstall() ? (method_exists($module, 'getContent') || property_exists($module, 'adminTab') ? '
					<a class="button" href="'.self::$currentIndex.'&configure='.$module->name.'">Configurer</a>' : '').'
					<a class="confirm button delete" module="'.$module->name.'">Désinstaller</a>' : '<a class="button save" href="'.self::$currentIndex.'&install='.$module->name.'">Installer</a>' ).'
					</div><div class="clear"></div></li>';
				}
				$txt .= '</ul>';
			}
		}
		else
		{	
			foreach(Module::getList(true) as $category => $modules)
			{
				$txt .= '<div class="header_module"><a class="header_module_toggle">'.$category.'</a></div>
					<ul class="listModule">';
				foreach($modules as $module)
					$txt .= '<li><div class="moduleLeft"><b>'.($module->picto ? ('<img src="'._BASE_URI_.'modules/'.$module->name.'/'.$module->picto.'" />') :'').$module->displayName.'</b>
					<p>'.$module->description.'</p></div>
					<div class="moduleRight">'.(method_exists($module, 'getContent') || property_exists($module, 'adminTab') ? '<a class="button configurer" href="'.self::$currentIndex.'&configure='.$module->name.'">Configurer</a>' : '').'</div><div class="clear"></div></li>';
				$txt .= '
					</ul>';
			}
		}
		echo $txt;
	}
	
	private function displayPosition()
	{
		$txt = '<legend class="legend">Positionnement des modules</legend>';
		
		$hooks = Module::getHookList();
		$modulesInstall = Module::getList(true, false);
		
		$txt .= '
		<script type="text/javascript">
			$(function(){
				$(".sortable").sortable({
				connectWith: ".connectedSortable",
				stop: function(event, ui){ 
					var item = ui.item;
					item.children().attr("name",item.parent().attr("rel")+"[]");
					}
				});
				$(".sortable").disableSelection();
			});
		</script>';
		
		
		$txt .= '
		<h2>Ajouter un module dans un point d\'accroche</h2>
		<form action="'.self::$currentIndex.'&position" method="post">
			<label for="hookName" class="label">Point d\'accroche :</label>
			<div class="margin-form"><select name="hookName" id="hookName">';
				foreach($hooks as $hook)
					$txt .= '<option value="'.$hook['id'].'">'.$hook['name'].' ('.$hook['id'].')</option>';
		$txt .= '</select></div>';
		
		$txt .= '<label for="hookName" class="label">Module :</label>
			<div class="margin-form"><select name="moduleName" id="moduleName">';
				foreach($modulesInstall as $module)
					if(!isset($module->requiredId) || !$module->requiredId)
						$txt .= '<option value="'.$module->name.'">'.$module->displayName.'</option>';
		$txt .= '</select></div>';
		$txt .= '<div class="margin-form"><input type="submit" class="button" name="addModuleHook" value="Ajouter" /></div>
		</form><hr/><br/>';
		
		$txt .= '
		<h2>Changer la position des modules</h2>
		<p>Faites glisser les modules avec la souris dans les cadres bleus afin de les déplacer.</p>
		<form method="post" action="'.self::$currentIndex.'&position">';
		foreach($hooks as $hook)
		{
			$txt .= '
			<fieldset class="fieldset white posmod">
				<legend class="legend">'.$hook['name'].' ('.$hook['id'].')</legend>
				<ul class="sortable connectedSortable" rel="'.$hook['id'].'">';
				foreach(Module::getHookListModule($hook['id']) as $module)
				{
					if(method_exists($module, 'getInfos'))
						$module->getInfos();
						
					$txt .= '<li><input type="hidden" name="'.$hook['id'].'[]" value="'.$module->name.'" />'.$module->displayName.''.(!isset($module->requiredId) || !$module->requiredId ? '<a href="'.self::$currentIndex.'&position&deleteModuleHook&moduleName='.$module->name.'&hookName='.$hook['id'].'" title="Supprimer de cet emplacement"><img src="img/delete.gif" alt="" /></a>' : ' *').'</li>';
				}
			$txt .= '</ul>
			</fieldset>';
		}
		$txt .= '<p>* à supprimer directement dans la configuration du module</p>';
		echo $txt .= '<div class="margin-form"><button class="button save" name="savePosition">Enregistrer</button></div></form>';
	}
	
	private function displayTranslate($param)
	{
		global $listLang;
		
		$module = Module::getInstanceByName($param);
		if($module && $module->isInstall())
		{
			$listTranslation = $module->findTranslation();
			
			$txt = '<legend class="legend">Traduction du module '.$module->displayName.'</legend>';
			
			if($listTranslation)
			{
				$txt .= '<p>Note : la modification se fait langue par langue, on ne peut pas modifier plusieurs langues en même temps</p>';
				
				foreach($listLang as $lang)
				{
					if($lang != 'fr')
					{
						$txt .= '
						<fieldset class="fieldset">
							<legend class="legend"><img class="flag" src="img/lang/'.$lang.'.gif" /></legend>
						<form method="post" action="'.self::$currentIndex.'&saveTranslation='.$module->name.'">
						<input type="hidden" name="lang" value="'.$lang.'" />
						<table id="listTranslation">';
						foreach($listTranslation as $translation)
						{
							$md5 = md5(str_replace('\'', '\\\'', $translation));
							$txt .= '<tr>
							<td class="tdLeft"><label for="'.$md5.'_'.$lang.'">'.$translation.'</label></td>';
							$txt .= '<td class="tdCenter">=</td>';
							$txt .='<td class="tdRight"><input type="text" class="large" name="md5['.$md5.']" id="'.$md5.'_'.$lang.'" value="'.$module->l($translation, $lang).'" /></td></tr>';
						}
						$txt .= '<tr></table>
							<div class="margin-form"><button class="button" type="submit">Enregistrer</button></div></form></fieldset>';
					}
					/* On réinisialise la variable globale $_MODULES afin de ne pas avoir de conflit pour le changement de langue et avoir le même comportement que dans le front */
					global $_MODULES;
					$_MODULES = array();
				}
			}
			else
				$txt .= '<p>Pas de traduction pour ce module</p>';
			echo $txt;
		}
		else
			echo "Ce module n'existe pas ou plus ou n'est pas installé";
	}
	
	private function displayConfigure($param, $ajax = false)
	{
		$module = Module::getInstanceByName($param);
		if($module && $module->isInstall())
		{
			if(!$ajax)
				echo '<legend class="legend"><a href="'.AdminTab::$currentIndex.'&configure='.$module->name.'">'.$module->displayName.'</a></legend>';
			if(property_exists($module, 'adminTab'))
			{
				AdminTab::$currentIndex .= '&configure='.$module->name;
				$adminObj = new $module->adminTab;
				$adminObj->postProcess();
				if($adminObj->ajax)
				{
					$action = Tools::getValue('action');
					if (!empty($action) && method_exists($adminObj, 'displayAjax'.Tools::toCamelCase($action)))
						echo $adminObj->{'displayAjax'.$action}();
					elseif (method_exists($adminObj, 'displayAjax'))
						echo $adminObj->displayAjax();
				}
				else
				{
					$adminObj->displayErrors();
					$adminObj->display();
				}
			}
			else
				$module->getContent();
		}
		else
			echo "Ce module n'existe pas ou plus ou n'est pas installé";
	}
}