<?php
class Configuration extends ObjectModel
{
	public static $xml = _FILE_CONFIGURATION_;

	protected $config = true;

	public $mail;  /* mail principal*/
	public $mail2; /* mail secondaire*/

	public $home;

	public $contrat = 0;

	public $website_name;

	public $filesizemax = 50;

	public $uploadimgsizemax = 2;

	public $uploaddocsizemax = 2;

	public $redimAuto = 1;

	public $list_lang;

	public $db_server;

	public $db_user;

	public $db_passwd;

	public $db_type = 'MySQL';

	public $db_name;

	public $smarty_compil;

	public $customHtaccess;

	public $particulars;

	public $URI;

	public $theme = 'default_3_columns';

	public $columnLeft = 1;

	public $columnRight = 1;

	public $maintenance_FO;

	public $maintenance_BO;

	public $dev_bootstrap;

	public $dev_materialize;

	public $dev_knacss;

	public $dev_animateCss;
	public $dev_envLocal = 0;

	public $dev_fontAwesome;

	public $dev_fancyBox;

	public $dev_jqueryUi;

	public $dev_googleRecaptcha;

	public $dev_hammerJs;

	public $dev_jqueryMousewheel;

	public $dev_momentJs;

	// ce tableau permet l'affichage dans la configuration
	public static $assets = array(
		'envLocal',
		'animateCss',
		'bootstrap',
		'materialize',
		'knacss',
		'fontAwesome',
		'fancyBox',
		'jqueryUi',
		'googleRecaptcha',
		'momentJs',
		'hammerJs',
		'jqueryMousewheel',
	);

	public $editor_width;

	public $smtp_host;

	public $smtp_port;

	public $smtp_user;

	public $smtp_passwd;


	protected $fieldsRequired = array(
		'URI',
		'home',
		'contrat',
		'website_name',
		'filesizemax',
		'uploadimgsizemax',
		'uploaddocsizemax',
		'redimAuto',
		'smarty_compil',
		'maintenance_FO',
		'maintenance_BO',
		'dev_bootstrap',
		'dev_materialize',
		'dev_knacss',
		'dev_fontAwesome',
		'dev_fancyBox',
		'dev_jqueryUi',
		'dev_googleRecaptcha',
		'dev_momentJs',
		'dev_hammerJs',
		'dev_jqueryMousewheel',
		'theme',
		'columnLeft',
		'columnRight',
		'editor_width'
	);

	protected $fieldsValidate = array(
		'URI' => 'isString',
		'home' => 'isInt',
		'contrat' => 'isInt',
		'website_name' => 'isGenericName',
		'mail' => 'isEmail',
		'mail2' => 'isEmail',
		'filesizemax' => 'isInt',
		'uploadimgsizemax' => 'isInt',
		'uploaddocsizemax' => 'isInt',
		'redimAuto' => 'isBool',
		'db_server' => 'isGenericName',
		'db_user' => 'isGenericName',
		'db_passwd' => 'isGenericName',
		'db_type' => 'isGenericName',
		'db_name' => 'isGenericName',
		'smtp_host' => 'isGenericName',
		'smtp_port' => 'isInt',
		'smtp_user' => 'isGenericName',
		'smtp_passwd' => 'isGenericName',
		'smarty_compil' => 'isBool',
		'particulars' => 'isString',
		'customHtaccess' => 'isString',
		'maintenance_FO' => 'isBool',
		'maintenance_BO' => 'isBool',
		'dev_bootstrap' => 'isBool',
		'dev_materialize' => 'isBool',
		'dev_knacss' => 'isBool',
		'dev_animateCss' => 'isBool',
		'dev_envLocal' => 'isBool',
		'dev_fontAwesome' => 'isBool',
		'dev_fancyBox' => 'isBool',
		'dev_jqueryUi' => 'isBool',
		'dev_googleRecaptcha' => 'isBool',
		'dev_momentJs' => 'isBool',
		'dev_hammerJs' => 'isBool',
		'dev_jqueryMousewheel' => 'isBool',
		'theme' => 'isGenericName',
		'columnRight' => 'isBool',
		'columnLeft' => 'isBool',
		'editor_width' => 'isInt');

	protected $fieldsArray = array(
		'list_lang' => 'isGenericName'
	);

	/** @var array Configuration cache */
	protected static $_CONF;

	public static function getListFlag()
	{
		$tabFlag = array();
		$handle = opendir(_KAM_IMG_DIR_.'lang/');
		$i = 0;
		while($file = readdir($handle))
		{
			if($file != '.' && $file != '..' && is_file(_KAM_IMG_DIR_.'lang/'.$file) && $file != 'fr.gif')
			{
				$tabFlag[$i]['path'] = _KAM_URI_.'img/lang/'.$file;
				$tabFlag[$i]['name'] = substr($file, 0, -4);
				$i++;
			}
        }
        closedir($handle);
		return $tabFlag;
	}

	public static function listLang()
	{
		$xml = new SimpleDOM(_FILE_CONFIGURATION_, NULL, true);
		if($xml->list_lang != '')
			return array_merge(array('fr'), explode(',' ,$xml->list_lang));
		return array('fr');
	}

	public function delete()
	{
		return false;
	}

	public static function loadConfiguration()
	{
		self::$_CONF = array();
		$xml = new SimpleDOM(_FILE_CONFIGURATION_, NULL, true);

		foreach($xml AS $key => $value)
			Configuration::set($key, (string)$value);
	}

	public static function get($key)
	{
		// If conf if not initialized, try manual query
		if (!self::$_CONF)
		{
			$xml = new SimpleDOM(_FILE_CONFIGURATION_, NULL, true);
			return $xml->{$key};
		}

		if (Configuration::hasKey($key))
			return self::$_CONF[$key];
		return false;
	}

	public static function set($key, $value)
	{
		if (!Validate::isConfigName($key))
			die(Tools::displayError());

		self::$_CONF[$key] = $value;
	}

	public static function updateValue($key, $value)
	{
		if (!Validate::isConfigName($key))
			die(Tools::displayError());

		$xml = new SimpleDOM(_FILE_CONFIGURATION_, NULL, true);

		$result = true;

		if ($value === Configuration::get($key))
			return $result;

		// If key already exists, update value
		if (Configuration::hasKey($key))
			$xml->{$key} = $value;
		// If key does not exists, create it
		else
			$xml->addChild($key, $value);

		$result = $xml->asXML(_FILE_CONFIGURATION_);

		Configuration::set($key, $value);

		return $result;
	}

	public static function deleteByName($key)
	{
	 	if (!Validate::isConfigName($key))
			return false;

		$xml = new SimpleDOM(_FILE_CONFIGURATION_, NULL, true);

		$delete = $xml->getElementsByTagName($key);
		$delete[0]->deleteSelf();

		return $xml->asXML(_FILE_CONFIGURATION_);
	}

	public static function hasKey($key)
	{
		return (isset(self::$_CONF) && array_key_exists($key, self::$_CONF));
	}

	public static function getThemeList()
	{
		$themes = array();
		foreach(glob(_THEMES_DIR_.'*') as $filePath)
			if(is_dir($filePath))
				$themes[]['name'] =  basename($filePath);
		return $themes;
	}


	public static function getAssets(){

		foreach (self::$assets as $value) {
			$configuration[$value] = self::get('dev_'.$value) ;
		}

		return $configuration;

	}

}
