<?php
class ImageManager
{
	static function resize($sourceFile, $destFile, $destWidth = NULL, $destHeight = NULL, $color = '#ffffff', $fileType = 'jpg')
	{
		if (!file_exists($sourceFile))
			return false;
		list($sourceWidth, $sourceHeight, $type, $attr) = getimagesize($sourceFile);
		
		if (!$sourceWidth)
			return false;
		if ($destWidth == NULL) $destWidth = $sourceWidth;
		if ($destHeight == NULL) $destHeight = $sourceHeight;

		$sourceImage = self::create($type, $sourceFile);

		$widthDiff = $destWidth / $sourceWidth;
		$heightDiff = $destHeight / $sourceHeight;

		if ($widthDiff > 1 AND $heightDiff > 1)
		{
			$nextWidth = $sourceWidth;
			$nextHeight = $sourceHeight;
		}
		else
		{
			if ($widthDiff > $heightDiff)
			{
				$nextHeight = $destHeight;
				$nextWidth = round(($sourceWidth * $nextHeight) / $sourceHeight);
			}
			else
			{
				$nextWidth = $destWidth;
				$nextHeight = round($sourceHeight * $destWidth / $sourceWidth);
			}
		}

		$destImage = imagecreatetruecolor($destWidth, $destHeight);

		// If image is a PNG and the output is PNG, fill with transparency. Else fill with white background.
		if ($fileType == 'png')
		{
			imagealphablending($destImage, false);
			imagesavealpha($destImage, true);	
			$transparent = imagecolorallocatealpha($destImage, 255, 255, 255, 127);
			imagefilledrectangle($destImage, 0, 0, $destWidth, $destHeight, $transparent);
		}else
		{
			$rgb_color = array();
			$rgb_color = self::convertColor($color);
			$white = imagecolorallocate($destImage, $rgb_color[0], $rgb_color[1], $rgb_color[2]);
			imagefilledrectangle ($destImage, 0, 0, $destWidth, $destHeight, $white);
		}

		imagecopyresampled($destImage, $sourceImage, (int)(($destWidth - $nextWidth) / 2), (int)(($destHeight - $nextHeight) / 2), 0, 0, $nextWidth, $nextHeight, $sourceWidth, $sourceHeight);
		$return = self::write($fileType, $destImage, $destFile);
		return	$return;
	}

	static function create($type, $filename)
	{
		switch ($type)
		{
			case 1:
				return imagecreatefromgif($filename);
				break;
			case 3:
				return imagecreatefrompng($filename);
				break;
			case 2:
			default:
				return imagecreatefromjpeg($filename);
				break;
		}
	}

	static function write($type, $ressource, $filename)
	{
		$flag = false;
		switch ($type)
		{
			case 'gif':
				$flag = imagegif($ressource, $filename);
				break;
			case 'png':
				$quality = 7;
				$flag = imagepng($ressource, $filename, (int)$quality);
				break;
			case 'jpg':
			case 'jpeg':
			default:
				$quality = 90;
				$flag = imagejpeg($ressource, $filename, (int)$quality);
				break;
		}
		imagedestroy($ressource);
		@chmod($filename, 0664);
		return $flag;
	}

	static function convertColor($color){
		#convert hexadecimal to RGB
		if (!is_array($color) && preg_match("/^[#]([0-9a-fA-F]{6})$/",$color)) {
			$hex_R = substr($color,1,2);
			$hex_G = substr($color,3,2);
			$hex_B = substr($color,5,2);

			$RGB = array();
			$RGB[0] = hexdec($hex_R);
			$RGB[1] = hexdec($hex_G);
			$RGB[2] = hexdec($hex_B);
			// $RGB = hexdec($hex_R).",".hexdec($hex_G).",".hexdec($hex_B);
			return $RGB;
		}
		#convert RGB to hexadecimal
		else {
			if(!is_array($color))
				$color = explode(",",$color);

			foreach($color as $value) {
				$hex_value = dechex($value); 
				if(strlen($hex_value)<2)
					$hex_value="0".$hex_value;
				$hex_RGB.=$hex_value;
			}
			return "#".$hex_RGB;
		}
	}

}